/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.custom.sweet;

import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;
import net.xstarlotte.snsnf.entity.SNSEntity;
import net.xstarlotte.snsnf.entity.client.ai.SugarRushAttackGoal;
import net.xstarlotte.snsnf.entity.client.variant.ChocolatePenguinVariant;
import net.xstarlotte.snsnf.item.SNSItem;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ChocolatePenguinEntity
extends TamableAnimal
implements GeoEntity {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(ChocolatePenguinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(ChocolatePenguinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ChocolatePenguinEntity(EntityType<? extends ChocolatePenguinEntity> type, Level level) {
        super(type, level);
        this.xpReward = 5;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> state) {
        if (state.isMoving()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.chocolate_penguin.run", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isSitting()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.chocolate_penguin.sit", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        state.getController().setAnimation(RawAnimation.begin().then("animation.chocolate_penguin.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.ARMOR, 6.0).add(Attributes.ARMOR_TOUGHNESS, 2.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.2).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.STEP_HEIGHT, 1.1);
    }

    protected void applyTamingSideEffects() {
        if (this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(40.0);
            this.setHealth(40.0f);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(8.0);
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new SugarRushAttackGoal((PathfinderMob)this, 1.2, true).totalDamage(12.0f));
        this.goalSelector.addGoal(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.2, 6.0f, 2.0f));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SNSItem.CANDY_CANE_SUGAR.get()}), true));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true));
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        Item itemForTaming;
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (item == (itemForTaming = (Item)SNSItem.CANDYFLOSS.get()) && !this.isTame()) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            if (!EventHooks.onAnimalTame((Animal)this, (Player)player)) {
                super.tame(player);
                this.navigation.recomputePath();
                this.setTarget(null);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
                this.setSitting(true);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && hand == InteractionHand.MAIN_HAND && !this.isFood(stack)) {
            this.setSitting(!this.isSitting());
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && this.getHealth() < this.getMaxHealth() && this.isFood(stack)) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            this.heal(5.0f);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public boolean canBeLeashed(Player player) {
        return false;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is((Item)SNSItem.CANDY_CANE_SUGAR.get());
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return (AgeableMob)SNSEntity.CHOCOLATE_PENGUIN.get().create((Level)level);
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        if (target instanceof Creeper) {
            return true;
        }
        if (target instanceof Ghast) {
            return false;
        }
        if (target instanceof Player && owner instanceof Player && !((Player)owner).canHarmPlayer((Player)target)) {
            return false;
        }
        if (target instanceof AbstractHorse && ((AbstractHorse)target).isTamed()) {
            return false;
        }
        return !(target instanceof TamableAnimal) || !((TamableAnimal)target).isTame();
    }

    public boolean hurt(DamageSource source, float amount) {
        TamableAnimal ta;
        OwnableEntity ownable;
        Projectile proj;
        Entity owner;
        Entity attacker = source.getEntity();
        Entity direct = source.getDirectEntity();
        if (attacker != null && this.isAlliedTo(attacker)) {
            return false;
        }
        if (direct instanceof Projectile && (owner = (proj = (Projectile)direct).getOwner()) != null && this.isAlliedTo(owner)) {
            return false;
        }
        if (direct instanceof OwnableEntity && (owner = (ownable = (OwnableEntity)direct).getOwner()) != null && this.isAlliedTo(owner)) {
            return false;
        }
        if (attacker instanceof TamableAnimal && (ta = (TamableAnimal)attacker).isTame()) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        ChocolatePenguinVariant variant = (ChocolatePenguinVariant)((Object)Util.getRandom((Object[])ChocolatePenguinVariant.values(), (RandomSource)this.random));
        this.setVariant(variant);
        return super.finalizeSpawn(level, difficulty, reason, spawnData);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SITTING, (Object)false);
        builder.define(VARIANT, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("isSitting", this.isSitting());
        tag.putInt("Variant", this.getTypeVariant());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSitting(tag.getBoolean("isSitting"));
        this.entityData.set(VARIANT, (Object)tag.getInt("Variant"));
    }

    private int getTypeVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public ChocolatePenguinVariant getVariant() {
        return ChocolatePenguinVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private void setVariant(ChocolatePenguinVariant variant) {
        this.entityData.set(VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public void setSitting(boolean sitting) {
        this.entityData.set(SITTING, (Object)sitting);
        this.setOrderedToSit(sitting);
    }
}

