/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.custom.sweet;

import java.util.function.DoubleSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;
import net.xstarlotte.snsnf.entity.SNSEntity;
import net.xstarlotte.snsnf.entity.client.ai.SugarRushAttackGoal;
import net.xstarlotte.snsnf.entity.client.variant.RainbowStripUnicornVariant;
import net.xstarlotte.snsnf.item.SNSItem;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RainbowStripUnicornEntity
extends TamableAnimal
implements GeoEntity,
PlayerRideableJumping {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(RainbowStripUnicornEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(RainbowStripUnicornEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected boolean isJumping;
    protected boolean canGallop = true;
    protected int gallopSoundCounter;
    protected float playerJumpPendingScale;
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RainbowStripUnicornEntity(EntityType<? extends RainbowStripUnicornEntity> type, Level level) {
        super(type, level);
        this.xpReward = 5;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> state) {
        boolean moving;
        boolean bl = moving = this.getDeltaMovement().horizontalDistanceSqr() > 5.0E-4;
        if (this.isVehicle() && moving) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.rainbow_strip_unicorn.run", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (moving) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.rainbow_strip_unicorn.walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isSitting()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.rainbow_strip_unicorn.sit", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        state.getController().setAnimation(RawAnimation.begin().then("animation.rainbow_strip_unicorn.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.ARMOR, 6.0).add(Attributes.ARMOR_TOUGHNESS, 2.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.2).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.34).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.STEP_HEIGHT, 1.1).add(Attributes.JUMP_STRENGTH, 0.4);
    }

    protected void applyTamingSideEffects() {
        if (this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(40.0);
            this.setHealth(40.0f);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(8.0);
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new SugarRushAttackGoal((PathfinderMob)this, 1.2, true).totalDamage(12.0f));
        this.goalSelector.addGoal(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.2, 6.0f, 2.0f));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1){

            public boolean canUse() {
                return !RainbowStripUnicornEntity.this.isSitting() && super.canUse();
            }

            public boolean canContinueToUse() {
                return !RainbowStripUnicornEntity.this.isSitting() && super.canContinueToUse();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SNSItem.CANDY_CANE_SUGAR.get()}), true));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true));
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        Item itemForTaming;
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (item == (itemForTaming = (Item)SNSItem.RAINBOW_STRIP.get()) && !this.isTame()) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            if (!EventHooks.onAnimalTame((Animal)this, (Player)player)) {
                super.tame(player);
                this.navigation.recomputePath();
                this.setTarget(null);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
                this.setSitting(true);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && this.getHealth() < this.getMaxHealth() && this.isFood(stack)) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            this.heal(5.0f);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (player.isShiftKeyDown()) {
            if (this.isTame() && this.isOwnedBy((LivingEntity)player)) {
                this.setSitting(!this.isSitting());
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            return InteractionResult.PASS;
        }
        if (!this.isBaby() && this.isTame() && this.isOwnedBy((LivingEntity)player) && !this.isSitting()) {
            if (!this.level().isClientSide) {
                player.startRiding((Entity)this);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    public boolean canBeLeashed(Player player) {
        return true;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is((Item)SNSItem.CANDY_CANE_SUGAR.get());
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return (AgeableMob)SNSEntity.RAINBOW_STRIP_UNICORN.get().create((Level)level);
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        if (target instanceof Creeper) {
            return true;
        }
        if (target instanceof Ghast) {
            return false;
        }
        if (target instanceof Player && owner instanceof Player && !((Player)owner).canHarmPlayer((Player)target)) {
            return false;
        }
        if (target instanceof AbstractHorse && ((AbstractHorse)target).isTamed()) {
            return false;
        }
        return !(target instanceof TamableAnimal) || !((TamableAnimal)target).isTame();
    }

    public boolean hurt(DamageSource source, float amount) {
        TamableAnimal ta;
        OwnableEntity ownable;
        Projectile proj;
        Entity owner;
        Entity attacker = source.getEntity();
        Entity direct = source.getDirectEntity();
        if (attacker != null && this.isAlliedTo(attacker)) {
            return false;
        }
        if (direct instanceof Projectile && (owner = (proj = (Projectile)direct).getOwner()) != null && this.isAlliedTo(owner)) {
            return false;
        }
        if (direct instanceof OwnableEntity && (owner = (ownable = (OwnableEntity)direct).getOwner()) != null && this.isAlliedTo(owner)) {
            return false;
        }
        if (attacker instanceof TamableAnimal && (ta = (TamableAnimal)attacker).isTame()) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @org.jetbrains.annotations.Nullable SpawnGroupData spawnData) {
        double spread;
        double base;
        RainbowStripUnicornVariant variant = (RainbowStripUnicornVariant)((Object)Util.getRandom((Object[])RainbowStripUnicornVariant.values(), (RandomSource)this.random));
        this.setVariant(variant);
        if (this.getAttribute(Attributes.MOVEMENT_SPEED) != null) {
            base = 0.3;
            spread = 0.06;
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(base + (this.random.nextDouble() - 0.5) * spread);
        }
        if (this.getAttribute(Attributes.JUMP_STRENGTH) != null) {
            base = 0.95;
            spread = 0.3;
            this.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(base + (this.random.nextDouble() - 0.5) * spread);
        }
        if (reason == MobSpawnType.BREEDING || reason == MobSpawnType.SPAWN_EGG || reason == MobSpawnType.COMMAND) {
            double offs = 0.15;
            double ang = this.random.nextDouble() * Math.PI * 2.0;
            this.setPos(this.getX() + Math.cos(ang) * offs, this.getY(), this.getZ() + Math.sin(ang) * offs);
        }
        return super.finalizeSpawn(level, difficulty, reason, spawnData);
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SITTING, (Object)false);
        builder.define(VARIANT, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("isSitting", this.isSitting());
        tag.putInt("Variant", this.getTypeVariant());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSitting(tag.getBoolean("isSitting"));
        this.entityData.set(VARIANT, (Object)tag.getInt("Variant"));
    }

    private int getTypeVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public RainbowStripUnicornVariant getVariant() {
        return RainbowStripUnicornVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private void setVariant(RainbowStripUnicornVariant variant) {
        this.entityData.set(VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public void setSitting(boolean sitting) {
        this.entityData.set(SITTING, (Object)sitting);
        this.setOrderedToSit(sitting);
        this.setInSittingPose(sitting);
        if (sitting) {
            this.getNavigation().stop();
            this.setDeltaMovement(Vec3.ZERO);
        }
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setIsJumping(boolean jumping) {
        this.isJumping = jumping;
    }

    public boolean isPushable() {
        return !this.isVehicle();
    }

    protected void playStepSound(BlockPos pos, BlockState block) {
        if (!block.liquid()) {
            BlockState blockstate = this.level().getBlockState(pos.above());
            SoundType soundtype = block.getSoundType((LevelReader)this.level(), pos, (Entity)this);
            if (blockstate.is(Blocks.SNOW)) {
                soundtype = blockstate.getSoundType((LevelReader)this.level(), pos, (Entity)this);
            }
            if (this.isVehicle() && this.canGallop) {
                ++this.gallopSoundCounter;
                if (this.gallopSoundCounter > 5 && this.gallopSoundCounter % 3 == 0) {
                    this.playGallopSound(soundtype);
                } else if (this.gallopSoundCounter <= 5) {
                    this.playSound(SoundEvents.HORSE_STEP_WOOD, soundtype.getVolume() * 0.15f, soundtype.getPitch());
                }
            } else if (this.isWoodSoundType(soundtype)) {
                this.playSound(SoundEvents.HORSE_STEP_WOOD, soundtype.getVolume() * 0.15f, soundtype.getPitch());
            } else {
                this.playSound(SoundEvents.HORSE_STEP, soundtype.getVolume() * 0.15f, soundtype.getPitch());
            }
        }
    }

    private boolean isWoodSoundType(SoundType soundType) {
        return soundType == SoundType.WOOD || soundType == SoundType.NETHER_WOOD || soundType == SoundType.STEM || soundType == SoundType.CHERRY_WOOD || soundType == SoundType.BAMBOO_WOOD;
    }

    protected void playGallopSound(SoundType soundType) {
        this.playSound(SoundEvents.HORSE_GALLOP, soundType.getVolume() * 0.15f, soundType.getPitch());
    }

    protected void doPlayerRide(Player player) {
        if (!this.level().isClientSide) {
            player.setYRot(this.getYRot());
            player.setXRot(this.getXRot());
            player.startRiding((Entity)this);
        }
    }

    public boolean isImmobile() {
        return super.isImmobile() && this.isVehicle();
    }

    protected void tickRidden(Player player, Vec3 travelVector) {
        super.tickRidden(player, travelVector);
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)player);
        this.setRot(vec2.y, vec2.x);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        if (this.isControlledByLocalInstance()) {
            if (travelVector.z <= 0.0) {
                this.gallopSoundCounter = 0;
            }
            if (this.onGround()) {
                this.setIsJumping(false);
                if (this.playerJumpPendingScale > 0.0f && !this.isJumping()) {
                    this.executeRidersJump(this.playerJumpPendingScale, travelVector);
                }
                this.playerJumpPendingScale = 0.0f;
            }
        }
    }

    protected Vec2 getRiddenRotation(LivingEntity entity) {
        return new Vec2(entity.getXRot() * 0.5f, entity.getYRot());
    }

    protected Vec3 getRiddenInput(Player player, Vec3 travelVector) {
        float strafe = player.xxa * 0.5f;
        float forward = player.zza;
        if (forward <= 0.0f) {
            forward *= 0.25f;
        }
        return new Vec3((double)strafe, 0.0, (double)forward);
    }

    protected float getRiddenSpeed(Player player) {
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
    }

    protected void executeRidersJump(float playerJumpPendingScale, Vec3 travelVector) {
        double d0 = this.getJumpPower(playerJumpPendingScale);
        Vec3 vec3 = this.getDeltaMovement();
        this.setDeltaMovement(vec3.x, d0, vec3.z);
        this.setIsJumping(true);
        this.hasImpulse = true;
        CommonHooks.onLivingJump((LivingEntity)this);
        if (travelVector.z > 0.0) {
            float f = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)));
            float f1 = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)));
            this.setDeltaMovement(this.getDeltaMovement().add((double)(-0.4f * f * playerJumpPendingScale), 0.0, (double)(0.4f * f1 * playerJumpPendingScale)));
        }
    }

    protected void playJumpSound() {
        this.playSound(SoundEvents.HORSE_JUMP, 0.4f, 1.0f);
    }

    public void onPlayerJump(int jumpPower) {
        this.playerJumpPendingScale = jumpPower >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPower / 90.0f;
    }

    public boolean canJump() {
        return true;
    }

    public void handleStartJump(int jumpPower) {
        this.playJumpSound();
    }

    public void handleStopJump() {
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction callback) {
        super.positionRider(passenger, callback);
        if (passenger instanceof LivingEntity) {
            ((LivingEntity)passenger).yBodyRot = this.yBodyRot;
        }
    }

    protected static float generateMaxHealth(IntUnaryOperator operator) {
        return 15.0f + (float)operator.applyAsInt(8) + (float)operator.applyAsInt(9);
    }

    protected static double generateJumpStrength(DoubleSupplier supplier) {
        return (double)0.4f + supplier.getAsDouble() * 0.2 + supplier.getAsDouble() * 0.2 + supplier.getAsDouble() * 0.2;
    }

    protected static double generateSpeed(DoubleSupplier supplier) {
        return ((double)0.45f + supplier.getAsDouble() * 0.3 + supplier.getAsDouble() * 0.3 + supplier.getAsDouble() * 0.3) * 0.25;
    }

    public boolean onClimbable() {
        return false;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof Player) {
            return (Player)entity;
        }
        return super.getControllingPassenger();
    }

    @Nullable
    private Vec3 getDismountLocationInDirection(Vec3 direction, LivingEntity passenger) {
        double d0 = this.getX() + direction.x;
        double d1 = this.getBoundingBox().minY;
        double d2 = this.getZ() + direction.z;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        block0: for (Pose pose : passenger.getDismountPoses()) {
            blockpos$mutableblockpos.set(d0, d1, d2);
            double d3 = this.getBoundingBox().maxY + 0.75;
            do {
                double d4 = this.level().getBlockFloorHeight((BlockPos)blockpos$mutableblockpos);
                if ((double)blockpos$mutableblockpos.getY() + d4 > d3) continue block0;
                if (DismountHelper.isBlockFloorValid((double)d4)) {
                    AABB aabb = passenger.getLocalBoundsForPose(pose);
                    Vec3 vec3 = new Vec3(d0, (double)blockpos$mutableblockpos.getY() + d4, d2);
                    if (DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)passenger, (AABB)aabb.move(vec3))) {
                        passenger.setPose(pose);
                        return vec3;
                    }
                }
                blockpos$mutableblockpos.move(Direction.UP);
            } while (!((double)blockpos$mutableblockpos.getY() < d3));
        }
        return null;
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity livingEntity) {
        Vec3 vec3 = RainbowStripUnicornEntity.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)livingEntity.getBbWidth(), (float)(this.getYRot() + (livingEntity.getMainArm() == HumanoidArm.RIGHT ? 90.0f : -90.0f)));
        Vec3 vec31 = this.getDismountLocationInDirection(vec3, livingEntity);
        if (vec31 != null) {
            return vec31;
        }
        Vec3 vec32 = RainbowStripUnicornEntity.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)livingEntity.getBbWidth(), (float)(this.getYRot() + (livingEntity.getMainArm() == HumanoidArm.LEFT ? 90.0f : -90.0f)));
        Vec3 vec33 = this.getDismountLocationInDirection(vec32, livingEntity);
        return vec33 != null ? vec33 : this.position();
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        return super.getPassengerAttachmentPoint(entity, dimensions, partialTick).add(new Vec3(0.0, 0.4, -0.0).yRot(-this.getYRot() * ((float)Math.PI / 180)));
    }
}

