/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.fluid;

import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.xstarlotte.snsnf.fluid.SNSFluid;

@EventBusSubscriber(modid="snsnf", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class SNSFluidClient {
    private static ResourceLocation tex(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)path);
    }

    private static ResourceLocation mc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)path);
    }

    @SubscribeEvent
    public static void onRegisterClientExtensions(RegisterClientExtensionsEvent event) {
        System.out.println("[SNSFluidClient] Registering fluid client extensions\u2026");
        event.registerFluidType(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return SNSFluidClient.tex("block/chocolate_still");
            }

            public ResourceLocation getFlowingTexture() {
                return SNSFluidClient.tex("block/chocolate_flow");
            }

            public ResourceLocation getOverlayTexture() {
                return SNSFluidClient.mc("block/water_overlay");
            }

            public int getTintColor() {
                return -11916525;
            }
        }, new FluidType[]{(FluidType)SNSFluid.CHOCOLATE_TYPE.get()});
        System.out.println("[SNSFluidClient]  -> chocolate registered");
        event.registerFluidType(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return SNSFluidClient.tex("block/cream_still");
            }

            public ResourceLocation getFlowingTexture() {
                return SNSFluidClient.tex("block/cream_flow");
            }

            public int getTintColor() {
                return -529978;
            }
        }, new FluidType[]{(FluidType)SNSFluid.CREAM_TYPE.get()});
        System.out.println("[SNSFluidClient]  -> cream registered");
        event.registerFluidType(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return SNSFluidClient.tex("block/mint_water_still");
            }

            public ResourceLocation getFlowingTexture() {
                return SNSFluidClient.tex("block/mint_water_flow");
            }

            public int getTintColor() {
                return -3932173;
            }
        }, new FluidType[]{(FluidType)SNSFluid.MINT_WATER_TYPE.get()});
        System.out.println("[SNSFluidClient]  -> mint_water registered");
    }
}

