/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.item.custom;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.xstarlotte.snsnf.item.SNSItem;

public class SNSBucketItem
extends MobBucketItem {
    public SNSBucketItem(Supplier<? extends EntityType<? extends Mob>> fishType, Fluid fluid, Item.Properties props) {
        super(fishType.get(), fluid, SoundEvents.BUCKET_EMPTY_FISH, props);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        InteractionResultHolder res = super.use(level, player, hand);
        if (!level.isClientSide && res.getResult().consumesAction() && !player.getAbilities().instabuild) {
            ItemStack customEmpty = new ItemStack((ItemLike)SNSItem.WAFFLE_BUCKET.get());
            player.setItemInHand(hand, customEmpty);
            return InteractionResultHolder.sidedSuccess((Object)customEmpty, (boolean)level.isClientSide);
        }
        return res;
    }
}

