/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.item.custom.armor;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.xstarlotte.snsnf.item.custom.armor.SNSArmorCategory;
import net.xstarlotte.snsnf.item.custom.armor.SNSArmorItem;
import net.xstarlotte.snsnf.item.custom.armor.SNSArmorSet;
import net.xstarlotte.snsnf.item.custom.armor.effects.CakeArmorEffects;
import net.xstarlotte.snsnf.item.custom.armor.effects.FruitArmorEffects;
import net.xstarlotte.snsnf.item.custom.armor.effects.HerbArmorEffects;
import net.xstarlotte.snsnf.item.custom.armor.effects.IceCreamArmorEffects;
import net.xstarlotte.snsnf.item.custom.armor.effects.SNSArmorEffects;
import net.xstarlotte.snsnf.item.custom.armor.effects.SweetArmorEffects;

@EventBusSubscriber(modid="snsnf", bus=EventBusSubscriber.Bus.GAME)
public final class SNSArmorEvents {
    private static final SNSArmorEffects SWEET = new SweetArmorEffects();
    private static final SNSArmorEffects HERB = new HerbArmorEffects();
    private static final SNSArmorEffects FRUIT = new FruitArmorEffects();
    private static final SNSArmorEffects CAKE = new CakeArmorEffects();
    private static final SNSArmorEffects ICE = new IceCreamArmorEffects();

    private static SNSArmorEffects forCategory(SNSArmorCategory c) {
        return switch (c) {
            default -> throw new MatchException(null, null);
            case SNSArmorCategory.SWEET -> SWEET;
            case SNSArmorCategory.HERB -> HERB;
            case SNSArmorCategory.FRUIT -> FRUIT;
            case SNSArmorCategory.CAKE -> CAKE;
            case SNSArmorCategory.ICE_CREAM -> ICE;
        };
    }

    private static WearInfo probeWearer(LivingEntity e) {
        int count = 0;
        SNSArmorCategory found = null;
        double scalarSum = 0.0;
        boolean sameSet = SNSArmorEvents.sameSet(e.getItemBySlot(EquipmentSlot.HEAD), e.getItemBySlot(EquipmentSlot.CHEST), e.getItemBySlot(EquipmentSlot.LEGS), e.getItemBySlot(EquipmentSlot.FEET));
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            Item item;
            if (!slot.isArmor() || !((item = (stack = e.getItemBySlot(slot)).getItem()) instanceof SNSArmorItem)) continue;
            SNSArmorItem item2 = (SNSArmorItem)item;
            ++count;
            if (found == null) {
                found = item2.set().category();
            }
            scalarSum += item2.set().scalar();
        }
        if (count == 0 || found == null) {
            return null;
        }
        double avgScalar = scalarSum / (double)count;
        boolean fullSet = sameSet && count == 4;
        return new WearInfo(found, avgScalar, fullSet);
    }

    private static boolean sameSet(ItemStack h, ItemStack c, ItemStack l, ItemStack b) {
        SNSArmorSet sB;
        SNSArmorSet sNSArmorSet;
        SNSArmorSet sNSArmorSet2;
        SNSArmorSet sNSArmorSet3;
        Item item = h.getItem();
        if (item instanceof SNSArmorItem) {
            SNSArmorItem i = (SNSArmorItem)item;
            sNSArmorSet3 = i.set();
        } else {
            sNSArmorSet3 = null;
        }
        SNSArmorSet sH = sNSArmorSet3;
        Item item2 = c.getItem();
        if (item2 instanceof SNSArmorItem) {
            SNSArmorItem i = (SNSArmorItem)item2;
            sNSArmorSet2 = i.set();
        } else {
            sNSArmorSet2 = null;
        }
        SNSArmorSet sC = sNSArmorSet2;
        Item item3 = l.getItem();
        if (item3 instanceof SNSArmorItem) {
            SNSArmorItem i = (SNSArmorItem)item3;
            sNSArmorSet = i.set();
        } else {
            sNSArmorSet = null;
        }
        SNSArmorSet sL = sNSArmorSet;
        Item item4 = b.getItem();
        if (item4 instanceof SNSArmorItem) {
            SNSArmorItem i = (SNSArmorItem)item4;
            v3 = i.set();
        } else {
            v3 = sB = null;
        }
        if (sH == null || sC == null || sL == null || sB == null) {
            return false;
        }
        return sH.id().equals((Object)sC.id()) && sC.id().equals((Object)sL.id()) && sL.id().equals((Object)sB.id());
    }

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Post e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        WearInfo info = SNSArmorEvents.probeWearer(living);
        if (info == null) {
            return;
        }
        SNSArmorEvents.forCategory(info.category()).onWearerTick(living, info.fullSet(), info.scalar());
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent e) {
        Player player = e.getEntity();
        if (!(player instanceof LivingEntity)) {
            return;
        }
        Player attacker = player;
        WearInfo info = SNSArmorEvents.probeWearer((LivingEntity)attacker);
        if (info == null) {
            return;
        }
        SNSArmorEvents.forCategory(info.category()).onWearerDealsDamage((LivingEntity)attacker, e.getTarget(), -1.0f, info.fullSet(), info.scalar());
    }

    @SubscribeEvent
    public static void onDamagePost(LivingDamageEvent.Post e) {
        LivingEntity victim = e.getEntity();
        WearInfo info = SNSArmorEvents.probeWearer(victim);
        if (info == null) {
            return;
        }
        DamageSource src = e.getSource();
        Entity attacker = src.getEntity();
        SNSArmorEvents.forCategory(info.category()).onWearerWasHit(victim, attacker, src, e.getNewDamage(), info.fullSet(), info.scalar());
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent e) {
        WearInfo info = SNSArmorEvents.probeWearer(e.getEntity());
        if (info != null && info.category() == SNSArmorCategory.CAKE) {
            e.setCanceled(true);
        }
    }

    private record WearInfo(SNSArmorCategory category, double scalar, boolean fullSet) {
    }
}

