/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.item.custom.armor;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.xstarlotte.snsnf.item.custom.armor.SNSArmorSet;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SNSArmorItem
extends ArmorItem
implements GeoItem {
    private final SNSArmorSet set;
    private final ItemAttributeModifiers modifiers;
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SNSArmorItem(Holder<ArmorMaterial> mat, ArmorItem.Type type, Item.Properties props, SNSArmorSet set) {
        super(mat, type, props);
        this.set = set;
        int armor = switch (type) {
            case ArmorItem.Type.BOOTS -> set.armorBoots();
            case ArmorItem.Type.LEGGINGS -> set.armorLeggings();
            case ArmorItem.Type.CHESTPLATE -> set.armorChest();
            case ArmorItem.Type.HELMET -> set.armorHelm();
            default -> 0;
        };
        float tough = set.toughnessPerPiece();
        float kb = set.knockbackResistPerPiece();
        EquipmentSlotGroup group = switch (type) {
            case ArmorItem.Type.BOOTS -> EquipmentSlotGroup.FEET;
            case ArmorItem.Type.LEGGINGS -> EquipmentSlotGroup.LEGS;
            case ArmorItem.Type.CHESTPLATE -> EquipmentSlotGroup.CHEST;
            case ArmorItem.Type.HELMET -> EquipmentSlotGroup.HEAD;
            default -> EquipmentSlotGroup.ANY;
        };
        ItemAttributeModifiers.Builder b = ItemAttributeModifiers.builder();
        String base = "armor/" + set.id().getPath() + "/" + group.getSerializedName();
        b.add(Attributes.ARMOR, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)(base + "/armor")), (double)armor, AttributeModifier.Operation.ADD_VALUE), group);
        if (tough > 0.0f) {
            b.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)(base + "/toughness")), (double)tough, AttributeModifier.Operation.ADD_VALUE), group);
        }
        if (kb > 0.0f) {
            b.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)(base + "/kb")), (double)kb, AttributeModifier.Operation.ADD_VALUE), group);
        }
        this.modifiers = b.build();
    }

    public SNSArmorSet set() {
        return this.set;
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.modifiers;
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        String base = this.set.id().getPath();
        String file = "textures/models/armor/" + base + (innerModel ? "_layer_2.png" : "_layer_1.png");
        return ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)file);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }
}

