/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.mixin;

import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.xstarlotte.snsnf.fluid.SNSFluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public final class CustomFluidBehaviourMixin {

    @Mixin(value={LivingEntity.class}, remap=false)
    public static abstract class LivingHooks {
        @Unique
        private static boolean snsnf$isWaterMob(Object o) {
            return o instanceof WaterAnimal || o instanceof Guardian || o instanceof ElderGuardian || o instanceof Axolotl;
        }

        @Unique
        private static boolean snsnf$isOurFluidType(FluidType t) {
            return t == SNSFluid.MINT_WATER_TYPE.get() || t == SNSFluid.CREAM_TYPE.get() || t == SNSFluid.CHOCOLATE_TYPE.get();
        }

        @Inject(method={"baseTick()V"}, at={@At(value="TAIL")}, remap=false)
        private void snsnf$afterBaseTick_updateWaterCache(CallbackInfo ci) {
            LivingEntity self = (LivingEntity)this;
            if (!LivingHooks.snsnf$isWaterMob(self)) {
                return;
            }
            EntityAccess inv = (EntityAccess)((Object)this);
            inv.snsnf$updateFluidHeightAndDoFluidPushing((TagKey<Fluid>)FluidTags.WATER, 0.014);
            inv.snsnf$updateFluidHeightAndDoFluidPushing((TagKey<Fluid>)FluidTags.LAVA, 0.007);
            inv.snsnf$updateInWaterStateAndDoWaterCurrentPushing();
            if (LivingHooks.snsnf$isOurFluidType(self.getEyeInFluidType())) {
                inv.snsnf$setWasTouchingWater(true);
            }
        }

        @Inject(method={"tick()V"}, at={@At(value="TAIL")}, remap=false)
        private void snsnf$refillAirIfInOurFluid(CallbackInfo ci) {
            LivingEntity self = (LivingEntity)this;
            if (!LivingHooks.snsnf$isWaterMob(self)) {
                return;
            }
            if (LivingHooks.snsnf$isOurFluidType(self.getEyeInFluidType())) {
                self.setAirSupply(self.getMaxAirSupply());
            }
        }
    }

    @Mixin(value={Entity.class}, priority=1200, remap=false)
    public static abstract class EntityHooks {
        @Shadow
        public abstract FluidType getEyeInFluidType();

        @Unique
        private static boolean snsnf$isOurFluidType(FluidType t) {
            return t == SNSFluid.MINT_WATER_TYPE.get() || t == SNSFluid.CREAM_TYPE.get() || t == SNSFluid.CHOCOLATE_TYPE.get();
        }

        @Inject(method={"isEyeInFluid(Lnet/minecraft/tags/TagKey;)Z"}, at={@At(value="HEAD")}, cancellable=true, require=0, remap=false)
        private void snsnf$eyeIsWater(TagKey<Fluid> tag, CallbackInfoReturnable<Boolean> cir) {
            if (tag != FluidTags.WATER) {
                return;
            }
            if (EntityHooks.snsnf$isOurFluidType(this.getEyeInFluidType())) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Mixin(value={Entity.class}, remap=false)
    public static interface EntityAccess {
        @Invoker(value="updateFluidHeightAndDoFluidPushing")
        public boolean snsnf$updateFluidHeightAndDoFluidPushing(TagKey<Fluid> var1, double var2);

        @Invoker(value="updateInWaterStateAndDoWaterCurrentPushing")
        public void snsnf$updateInWaterStateAndDoWaterCurrentPushing();

        @Accessor(value="wasTouchingWater")
        public void snsnf$setWasTouchingWater(boolean var1);

        @Accessor(value="wasTouchingWater")
        public boolean snsnf$getWasTouchingWater();
    }
}

