/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.worldgen.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.xstarlotte.snsnf.worldgen.tree.SNSTrunkPlacerTypes;

public class ChocolateTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<ChocolateTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> ChocolateTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, ChocolateTrunkPlacer::new));
    public static final Codec<ChocolateTrunkPlacer> codec = CODEC.codec();

    public ChocolateTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)SNSTrunkPlacerTypes.CHOCOLATE_TRUNK_PLACER.value();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> replacer, RandomSource rand, int height, BlockPos pos, TreeConfiguration config) {
        for (int y = 0; y < height; ++y) {
            BlockPos p = pos.above(y);
            replacer.accept(p, config.trunkProvider.getState(rand, p));
        }
        BlockPos attach = pos.above(height - 1);
        ArrayList<FoliagePlacer.FoliageAttachment> attachments = new ArrayList<FoliagePlacer.FoliageAttachment>();
        attachments.add(new FoliagePlacer.FoliageAttachment(attach, 0, false));
        return attachments;
    }
}

