/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.worldgen.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.xstarlotte.snsnf.worldgen.tree.SNSFoliagePlacerTypes;

public class RainbowStripFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<RainbowStripFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> RainbowStripFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, RainbowStripFoliagePlacer::new));
    public static final Codec<RainbowStripFoliagePlacer> codec = CODEC.codec();

    public RainbowStripFoliagePlacer(IntProvider radius, IntProvider offset) {
        super(radius, offset);
    }

    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)SNSFoliagePlacerTypes.RAINBOW_STRIP_FOLIAGE_PLACER.value();
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int radiusSample, int offsetSample) {
        BlockPos topLog = attachment.pos();
        this.placeLeafIfPossible(level, setter, random, config, topLog.above(1));
        this.placeFilledLayer(level, setter, random, config, topLog, 1, true);
        this.placeFilledLayer(level, setter, random, config, topLog.below(1), 1, true);
        this.placeFilledLayer(level, setter, random, config, topLog.below(2), 1, false);
        this.placeFilledLayer(level, setter, random, config, topLog.below(3), 2, true);
        this.placeFilledLayer(level, setter, random, config, topLog.below(4), 2, false);
    }

    private void placeFilledLayer(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, BlockPos center, int radius, boolean trimOuterCorners) {
        if (radius <= 0) {
            this.placeLeafIfPossible(level, setter, random, config, center);
            return;
        }
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                if (Math.max(Math.abs(dx), Math.abs(dz)) > radius || trimOuterCorners && Math.abs(dx) == radius && Math.abs(dz) == radius) continue;
                this.placeLeafIfPossible(level, setter, random, config, center.offset(dx, 0, dz));
            }
        }
    }

    private void placeLeafIfPossible(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, BlockPos pos) {
        BlockState state = ((BlockGetter)level).getBlockState(pos);
        if (state.isAir() || state.is(BlockTags.LEAVES)) {
            setter.set(pos, config.foliageProvider.getState(random, pos));
        }
    }

    public int foliageHeight(RandomSource random, int trunkHeight, TreeConfiguration config) {
        return 5;
    }

    protected boolean shouldSkipLocation(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return false;
    }
}

