/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.worldgen.tree;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;
import net.xstarlotte.snsnf.block.SNSBlock;
import net.xstarlotte.snsnf.worldgen.SNSConfiguredFeatures;

public class SNSTreeGrower {
    public static final TreeGrower CANDYFLOSS = new TreeGrower("snsnf:candyfloss", Optional.empty(), Optional.of(SNSConfiguredFeatures.CANDYFLOSS_TREE_KEY), Optional.empty());
    public static final TreeGrower CANDY_CANE = new TreeGrower("snsnf:candy_cane", Optional.empty(), Optional.of(SNSConfiguredFeatures.CANDY_CANE_TREE_KEY), Optional.empty());
    public static final TreeGrower CHOCOLATE = new TreeGrower("snsnf:chocolate", Optional.empty(), Optional.of(SNSConfiguredFeatures.CHOCOLATE_TREE_KEY), Optional.empty());
    public static final TreeGrower CINNAMON = new TreeGrower("snsnf:cinnamon", Optional.empty(), Optional.of(SNSConfiguredFeatures.CINNAMON_TREE_KEY), Optional.empty());
    public static final TreeGrower RAINBOW_STRIP = new TreeGrower("snsnf:rainbow_strip", Optional.empty(), Optional.of(SNSConfiguredFeatures.RAINBOW_STRIP_TREE_KEY), Optional.empty());

    public static void registerGrowListener() {
        NeoForge.EVENT_BUS.addListener(SNSTreeGrower::onBlockGrowFeature);
    }

    private static void onBlockGrowFeature(BlockGrowFeatureEvent event) {
        BlockPos pos = event.getPos();
        BlockState state = event.getLevel().getBlockState(pos);
        if (!state.is((Block)SNSBlock.CANDYFLOSS_SAPLING.get())) {
            return;
        }
        RandomSource rand = event.getRandom();
        ResourceKey<ConfiguredFeature<?, ?>> pick = switch (rand.nextInt(5)) {
            case 0 -> SNSConfiguredFeatures.CANDYFLOSS_TREE_KEY;
            case 1 -> SNSConfiguredFeatures.CANDYFLOSS_TREE_KEY_2;
            case 2 -> SNSConfiguredFeatures.CANDYFLOSS_TREE_KEY_3;
            case 3 -> SNSConfiguredFeatures.CANDYFLOSS_TREE_KEY_4;
            default -> SNSConfiguredFeatures.CANDYFLOSS_TREE_KEY_5;
        };
        event.setFeature(pick);
    }
}

