/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.xstarlotte.snsnf.Config;
import net.xstarlotte.snsnf.block.SNSBlock;
import net.xstarlotte.snsnf.block.entity.SNSBE;
import net.xstarlotte.snsnf.entity.SNSEntity;
import net.xstarlotte.snsnf.entity.client.berry.BlackboarryRenderer;
import net.xstarlotte.snsnf.entity.client.berry.BlueboarryRenderer;
import net.xstarlotte.snsnf.entity.client.berry.JamsterRenderer;
import net.xstarlotte.snsnf.entity.client.berry.RaspboarryRenderer;
import net.xstarlotte.snsnf.entity.client.berry.StrawboarryRenderer;
import net.xstarlotte.snsnf.entity.client.cake.CakeRabbitRenderer;
import net.xstarlotte.snsnf.entity.client.cake.CheesecakeMouseRenderer;
import net.xstarlotte.snsnf.entity.client.cake.SquirrollRenderer;
import net.xstarlotte.snsnf.entity.client.fruit.BunanaRenderer;
import net.xstarlotte.snsnf.entity.client.fruit.DuckanaRenderer;
import net.xstarlotte.snsnf.entity.client.fruit.FruitElfRenderer;
import net.xstarlotte.snsnf.entity.client.fruit.FruitPugRenderer;
import net.xstarlotte.snsnf.entity.client.fruit.HappleRenderer;
import net.xstarlotte.snsnf.entity.client.fruit.SnappleRenderer;
import net.xstarlotte.snsnf.entity.client.herb.CandyCaneCatRenderer;
import net.xstarlotte.snsnf.entity.client.herb.CandyCaneCrookRenderer;
import net.xstarlotte.snsnf.entity.client.herb.CandyCaneFlyRenderer;
import net.xstarlotte.snsnf.entity.client.herb.CandyCaneTigerRenderer;
import net.xstarlotte.snsnf.entity.client.herb.CinnabunRenderer;
import net.xstarlotte.snsnf.entity.client.herb.GingerbreadManRenderer;
import net.xstarlotte.snsnf.entity.client.herb.HumbugRenderer;
import net.xstarlotte.snsnf.entity.client.herb.HumpugRenderer;
import net.xstarlotte.snsnf.entity.client.herb.MintImperialRenderer;
import net.xstarlotte.snsnf.entity.client.herb.MintMarshmallowSheepRenderer;
import net.xstarlotte.snsnf.entity.client.herb.MintmunkRenderer;
import net.xstarlotte.snsnf.entity.client.herb.PeppermintChurlRenderer;
import net.xstarlotte.snsnf.entity.client.herb.PeppermintTwirlRenderer;
import net.xstarlotte.snsnf.entity.client.ice_cream.IceCreamCowRenderer;
import net.xstarlotte.snsnf.entity.client.ice_cream.ParfaitPixieRenderer;
import net.xstarlotte.snsnf.entity.client.ice_cream.WaferWitchRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.BonbonbiniRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.CandyflossLionRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.CandyflossSheepRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.ChocolateChickenRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.ChocolatePenguinRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.GummyBearRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.JellyBabyRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.SugargliderRenderer;
import net.xstarlotte.snsnf.entity.client.sweet.TreatToadRenderer;
import net.xstarlotte.snsnf.item.SNSItem;
import net.xstarlotte.snsnf.item.SNSTab;
import net.xstarlotte.snsnf.mob_effects.SNSEffect;
import net.xstarlotte.snsnf.network.SNSNFModVariables;
import org.slf4j.Logger;

@Mod(value="snsnf")
public class SNSNF {
    public static final String MOD_ID = "snsnf";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static boolean networkingRegistered = false;
    private static final Map<CustomPacketPayload.Type<?>, NetworkMessage<?>> MESSAGES = new HashMap();
    private static final Collection<Tuple<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<Tuple<Runnable, Integer>>();

    public SNSNF(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::registerNetworking);
        SNSBlock.register(modEventBus);
        SNSBE.register(modEventBus);
        SNSEntity.register(modEventBus);
        SNSItem.register(modEventBus);
        SNSEffect.register(modEventBus);
        SNSTab.register(modEventBus);
        SNSNFModVariables.ATTACHMENT_TYPES.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDY_CANE_BUSH.getId(), SNSBlock.POTTED_CANDY_CANE_BUSH);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDY_CANE_CARNATION.getId(), SNSBlock.POTTED_CANDY_CANE_CARNATION);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDY_CANE_FLOWER.getId(), SNSBlock.POTTED_CANDY_CANE_FLOWER);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDY_CANE_FLOWER_2.getId(), SNSBlock.POTTED_CANDY_CANE_FLOWER_2);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDY_CANE_FLOWER_3.getId(), SNSBlock.POTTED_CANDY_CANE_FLOWER_3);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDY_CANE_FLOWER_4.getId(), SNSBlock.POTTED_CANDY_CANE_FLOWER_4);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDY_CANE_GRASS.getId(), SNSBlock.POTTED_CANDY_CANE_GRASS);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SNSBlock.CANDY_CANE_GRASS_LONG.getId(), SNSBlock.POTTED_CANDY_CANE_GRASS_LONG);
        });
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    public static <T extends CustomPacketPayload> void addNetworkMessage(CustomPacketPayload.Type<T> id, StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
        if (networkingRegistered) {
            throw new IllegalStateException("Cannot register new network messages after networking has been registered");
        }
        MESSAGES.put(id, new NetworkMessage<T>(reader, handler));
    }

    private void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MOD_ID);
        MESSAGES.forEach((id, networkMessage) -> registrar.playBidirectional(id, networkMessage.reader(), networkMessage.handler()));
        networkingRegistered = true;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add((Tuple<Runnable, Integer>)new Tuple((Object)action, (Object)tick));
        }
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        ArrayList actions = new ArrayList();
        workQueue.forEach(work -> {
            work.setB((Object)((Integer)work.getB() - 1));
            if ((Integer)work.getB() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getA()).run());
        workQueue.removeAll(actions);
    }

    private record NetworkMessage<T extends CustomPacketPayload>(StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
    }

    @EventBusSubscriber(modid="snsnf", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
            EntityRenderers.register(SNSEntity.BLACKBOARRY.get(), BlackboarryRenderer::new);
            EntityRenderers.register(SNSEntity.BLUEBOARRY.get(), BlueboarryRenderer::new);
            EntityRenderers.register(SNSEntity.RASPBOARRY.get(), RaspboarryRenderer::new);
            EntityRenderers.register(SNSEntity.STRAWBOARRY.get(), StrawboarryRenderer::new);
            EntityRenderers.register(SNSEntity.JAMSTER.get(), JamsterRenderer::new);
            EntityRenderers.register(SNSEntity.CAKE_RABBIT.get(), CakeRabbitRenderer::new);
            EntityRenderers.register(SNSEntity.CHEESECAKE_MOUSE.get(), CheesecakeMouseRenderer::new);
            EntityRenderers.register(SNSEntity.SQUIRROLL.get(), SquirrollRenderer::new);
            EntityRenderers.register(SNSEntity.BUNANA.get(), BunanaRenderer::new);
            EntityRenderers.register(SNSEntity.DUCKANA.get(), DuckanaRenderer::new);
            EntityRenderers.register(SNSEntity.FRUIT_ELF.get(), FruitElfRenderer::new);
            EntityRenderers.register(SNSEntity.FRUIT_PUG.get(), FruitPugRenderer::new);
            EntityRenderers.register(SNSEntity.HAPPLE.get(), HappleRenderer::new);
            EntityRenderers.register(SNSEntity.SNAPPLE.get(), SnappleRenderer::new);
            EntityRenderers.register(SNSEntity.CANDY_CANE_CAT.get(), CandyCaneCatRenderer::new);
            EntityRenderers.register(SNSEntity.CANDY_CANE_CROOK.get(), CandyCaneCrookRenderer::new);
            EntityRenderers.register(SNSEntity.CANDY_CANE_FLY.get(), CandyCaneFlyRenderer::new);
            EntityRenderers.register(SNSEntity.CANDY_CANE_TIGER.get(), CandyCaneTigerRenderer::new);
            EntityRenderers.register(SNSEntity.CINNABUN.get(), CinnabunRenderer::new);
            EntityRenderers.register(SNSEntity.GINGERBREAD_MAN.get(), GingerbreadManRenderer::new);
            EntityRenderers.register(SNSEntity.HUMBUG.get(), HumbugRenderer::new);
            EntityRenderers.register(SNSEntity.HUMPUG.get(), HumpugRenderer::new);
            EntityRenderers.register(SNSEntity.MINTMUNK.get(), MintmunkRenderer::new);
            EntityRenderers.register(SNSEntity.MINT_IMPERIAL.get(), MintImperialRenderer::new);
            EntityRenderers.register(SNSEntity.MINT_MARSHMALLOW_SHEEP.get(), MintMarshmallowSheepRenderer::new);
            EntityRenderers.register(SNSEntity.PEPPERMINT_CHURL.get(), PeppermintChurlRenderer::new);
            EntityRenderers.register(SNSEntity.PEPPERMINT_TWIRL.get(), PeppermintTwirlRenderer::new);
            EntityRenderers.register(SNSEntity.ICE_CREAM_COW.get(), IceCreamCowRenderer::new);
            EntityRenderers.register(SNSEntity.PARFAIT_PIXIE.get(), ParfaitPixieRenderer::new);
            EntityRenderers.register(SNSEntity.WAFER_WITCH.get(), WaferWitchRenderer::new);
            EntityRenderers.register(SNSEntity.BONBONBINI.get(), BonbonbiniRenderer::new);
            EntityRenderers.register(SNSEntity.CANDYFLOSS_LION.get(), CandyflossLionRenderer::new);
            EntityRenderers.register(SNSEntity.CANDYFLOSS_SHEEP.get(), CandyflossSheepRenderer::new);
            EntityRenderers.register(SNSEntity.CHOCOLATE_CHICKEN.get(), ChocolateChickenRenderer::new);
            EntityRenderers.register(SNSEntity.CHOCOLATE_PENGUIN.get(), ChocolatePenguinRenderer::new);
            EntityRenderers.register(SNSEntity.GUMMY_BEAR.get(), GummyBearRenderer::new);
            EntityRenderers.register(SNSEntity.JELLY_BABY.get(), JellyBabyRenderer::new);
            EntityRenderers.register(SNSEntity.SUGARGLIDER.get(), SugargliderRenderer::new);
            EntityRenderers.register(SNSEntity.TREAT_TOAD.get(), TreatToadRenderer::new);
        }
    }
}

