/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.block.custom.lamp;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.xstarlotte.snsnf.block.custom.lamp.BaseLampBlock;
import org.jetbrains.annotations.Nullable;

public class CandyCaneLanternBlock
extends BaseLampBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty HANGING = BlockStateProperties.HANGING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape SHAPE_NT = CandyCaneLanternBlock.createShape(Direction.NORTH, true);
    protected static final VoxelShape SHAPE_NF = CandyCaneLanternBlock.createShape(Direction.NORTH, false);
    protected static final VoxelShape SHAPE_ST = CandyCaneLanternBlock.createShape(Direction.SOUTH, true);
    protected static final VoxelShape SHAPE_SF = CandyCaneLanternBlock.createShape(Direction.SOUTH, false);
    protected static final VoxelShape SHAPE_ET = CandyCaneLanternBlock.createShape(Direction.EAST, true);
    protected static final VoxelShape SHAPE_EF = CandyCaneLanternBlock.createShape(Direction.EAST, false);
    protected static final VoxelShape SHAPE_WT = CandyCaneLanternBlock.createShape(Direction.WEST, true);
    protected static final VoxelShape SHAPE_WF = CandyCaneLanternBlock.createShape(Direction.WEST, false);

    private static VoxelShape createShape(Direction facing, boolean hanging) {
        VoxelShape base = Block.box((double)7.0, (double)(hanging ? 9.5 : 0.0), (double)7.0, (double)9.0, (double)(hanging ? 16.0 : 6.5), (double)9.0);
        int dx = facing.getStepX();
        int dz = facing.getStepZ();
        int adx = Math.abs(dx);
        int adz = Math.abs(dz);
        int sx = dx < 0 ? 9 : 7;
        int ex = dx < 0 ? 7 : 9;
        int sz = dz < 0 ? 9 : 7;
        int ez = dz < 0 ? 7 : 9;
        VoxelShape middle = CandyCaneLanternBlock.safeBox((double)sx + (double)dx * 0.5, hanging ? 7.5 : 6.5, (double)sz + (double)dz * 0.5, ex + dx * 3, hanging ? 9.5 : 8.5, ez + dz * 3);
        VoxelShape top = CandyCaneLanternBlock.safeBox((double)sx + (double)dx * 1.5, hanging ? 7.0 : 8.5, (double)sz + (double)dz * 1.5, ex + dx * 2, hanging ? 7.5 : 9.0, ez + dz * 2);
        VoxelShape tip = CandyCaneLanternBlock.safeBox((double)sx + (double)dx * 3.5 + (double)adz * 0.25, hanging ? 9.5 : 5.5, (double)sz + (double)dz * 3.5 + (double)adx * 0.25, (double)(ex + dx * 3) - (double)adz * 0.25, hanging ? 10.5 : 6.5, (double)(ez + dz * 3) - (double)adx * 0.25);
        return Shapes.or((VoxelShape)base, (VoxelShape[])new VoxelShape[]{middle, top, tip});
    }

    private static VoxelShape safeBox(double x0, double y0, double z0, double x1, double y1, double z1) {
        return Block.box((double)Math.min(x0, x1), (double)Math.min(y0, y1), (double)Math.min(z0, z1), (double)Math.max(x0, x1), (double)Math.max(y0, y1), (double)Math.max(z0, z1));
    }

    public CandyCaneLanternBlock(BlockBehaviour.Properties p_153465_) {
        super(p_153465_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HANGING, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getHorizontalDirection().getOpposite();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean waterlogged = fluidstate.getType() == Fluids.WATER;
        boolean hanging = context.getClickedFace() == Direction.DOWN;
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).setValue((Property)HANGING, (Comparable)Boolean.valueOf(hanging));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean hanging = (Boolean)state.getValue((Property)HANGING);
        return switch (facing) {
            case Direction.NORTH -> {
                if (hanging) {
                    yield SHAPE_NT;
                }
                yield SHAPE_NF;
            }
            case Direction.SOUTH -> {
                if (hanging) {
                    yield SHAPE_ST;
                }
                yield SHAPE_SF;
            }
            case Direction.EAST -> {
                if (hanging) {
                    yield SHAPE_ET;
                }
                yield SHAPE_EF;
            }
            case Direction.WEST -> {
                if (hanging) {
                    yield SHAPE_WT;
                }
                yield SHAPE_WF;
            }
            default -> throw new RuntimeException("Unexpected facing");
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HANGING, WATERLOGGED});
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = CandyCaneLanternBlock.getConnectedDirection(state);
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.relative(direction), (Direction)direction.getOpposite());
    }

    protected static Direction getConnectedDirection(BlockState p_153496_) {
        return (Boolean)p_153496_.getValue((Property)HANGING) != false ? Direction.UP : Direction.DOWN;
    }

    public PushReaction getPistonPushReaction(BlockState p_153494_) {
        return PushReaction.DESTROY;
    }

    @Override
    public BlockState updateShape(BlockState p_153483_, Direction p_153484_, BlockState p_153485_, LevelAccessor p_153486_, BlockPos p_153487_, BlockPos p_153488_) {
        if (((Boolean)p_153483_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_153486_.scheduleTick(p_153487_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)p_153486_));
        }
        return CandyCaneLanternBlock.getConnectedDirection(p_153483_) == p_153484_ && !p_153483_.canSurvive((LevelReader)p_153486_, p_153487_) ? Blocks.AIR.defaultBlockState() : super.updateShape(p_153483_, p_153484_, p_153485_, p_153486_, p_153487_, p_153488_);
    }

    @Override
    public FluidState getFluidState(BlockState p_153492_) {
        return (Boolean)p_153492_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_153492_);
    }

    public boolean isPathfindable(BlockState p_153469_, BlockGetter p_153470_, BlockPos p_153471_, PathComputationType p_153472_) {
        return false;
    }
}

