/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.xstarlotte.snsnf.datagen.SNSBlockLootTableProvider;
import net.xstarlotte.snsnf.datagen.SNSBlockStateProvider;
import net.xstarlotte.snsnf.datagen.SNSBlockTagProvider;
import net.xstarlotte.snsnf.datagen.SNSItemModelProvider;
import net.xstarlotte.snsnf.datagen.SNSItemTagProvider;
import net.xstarlotte.snsnf.datagen.SNSRecipeProvider;
import net.xstarlotte.snsnf.datagen.SNSWorldGenProvider;

@EventBusSubscriber(modid="snsnf", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        net.minecraft.data.DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new SNSRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(SNSBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        SNSBlockTagProvider blockTagsProvider = new SNSBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new SNSItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new SNSItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new SNSBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new SNSWorldGenProvider(packOutput, lookupProvider));
    }
}

