/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.berry;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.xstarlotte.snsnf.entity.client.berry.JamsterModel;
import net.xstarlotte.snsnf.entity.client.variant.JamsterVariant;
import net.xstarlotte.snsnf.entity.custom.berry.JamsterEntity;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class JamsterRenderer
extends GeoEntityRenderer<JamsterEntity> {
    private static final Map<JamsterVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(JamsterVariant.class), map -> {
        map.put(JamsterVariant.BLACKBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/berry/blackberry_jamster.png"));
        map.put(JamsterVariant.BLUEBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/berry/blueberry_jamster.png"));
        map.put(JamsterVariant.RASPBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/berry/raspberry_jamster.png"));
        map.put(JamsterVariant.STRAWBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/berry/strawberry_jamster.png"));
    });

    public JamsterRenderer(EntityRendererProvider.Context context) {
        super(context, new JamsterModel());
    }

    public ResourceLocation getTextureLocation(JamsterEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public void render(JamsterEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.4f, 0.4f, 0.4f);
        } else {
            poseStack.scale(1.0f, 1.0f, 1.0f);
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

