/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.fruit;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.xstarlotte.snsnf.entity.client.fruit.FruitElfModel;
import net.xstarlotte.snsnf.entity.client.variant.FruitElfVariant;
import net.xstarlotte.snsnf.entity.custom.fruit.FruitElfEntity;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class FruitElfRenderer
extends GeoEntityRenderer<FruitElfEntity> {
    private static final Map<FruitElfVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(FruitElfVariant.class), map -> {
        map.put(FruitElfVariant.LEMON, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/fruit/lemon_fruit_elf.png"));
        map.put(FruitElfVariant.LIME, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/fruit/lime_fruit_elf.png"));
        map.put(FruitElfVariant.MANGO, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/fruit/mango_fruit_elf.png"));
        map.put(FruitElfVariant.ORANGE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/fruit/orange_fruit_elf.png"));
        map.put(FruitElfVariant.PEACH, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/fruit/peach_fruit_elf.png"));
        map.put(FruitElfVariant.PINEAPPLE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/fruit/pineapple_fruit_elf.png"));
    });

    public FruitElfRenderer(EntityRendererProvider.Context context) {
        super(context, new FruitElfModel());
    }

    public ResourceLocation getTextureLocation(FruitElfEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public void render(FruitElfEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.4f, 0.4f, 0.4f);
        } else {
            poseStack.scale(1.0f, 1.0f, 1.0f);
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

