/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.herb;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.xstarlotte.snsnf.entity.client.herb.CandyCaneFlyModel;
import net.xstarlotte.snsnf.entity.client.variant.CandyCaneFlyVariant;
import net.xstarlotte.snsnf.entity.custom.herb.CandyCaneFlyEntity;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class CandyCaneFlyRenderer
extends GeoEntityRenderer<CandyCaneFlyEntity> {
    private static final Map<CandyCaneFlyVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(CandyCaneFlyVariant.class), map -> {
        map.put(CandyCaneFlyVariant.APPLE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/herb/candy_cane_fly_apple.png"));
        map.put(CandyCaneFlyVariant.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/herb/candy_cane_fly.png"));
        map.put(CandyCaneFlyVariant.ICE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/herb/candy_cane_fly_ice.png"));
        map.put(CandyCaneFlyVariant.PEPPER, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/herb/candy_cane_fly_pepper.png"));
        map.put(CandyCaneFlyVariant.SPEAR, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/herb/candy_cane_fly_spear.png"));
        map.put(CandyCaneFlyVariant.WATERMELON, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/herb/candy_cane_fly_watermelon.png"));
    });

    public CandyCaneFlyRenderer(EntityRendererProvider.Context context) {
        super(context, new CandyCaneFlyModel());
    }

    public ResourceLocation getTextureLocation(CandyCaneFlyEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public void render(CandyCaneFlyEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.45f, 0.45f, 0.45f);
        } else {
            poseStack.scale(0.9f, 0.9f, 0.9f);
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

