/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.sweet;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.xstarlotte.snsnf.entity.client.sweet.CandyflossSheepModel;
import net.xstarlotte.snsnf.entity.client.variant.CandyflossSheepVariant;
import net.xstarlotte.snsnf.entity.custom.sweet.CandyflossSheepEntity;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class CandyflossSheepRenderer
extends GeoEntityRenderer<CandyflossSheepEntity> {
    private static final Map<CandyflossSheepVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(CandyflossSheepVariant.class), map -> {
        map.put(CandyflossSheepVariant.BLUE_RASPBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/blue_raspberry_candyfloss_sheep.png"));
        map.put(CandyflossSheepVariant.PINK_VANILLA, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/pink_vanilla_candyfloss_sheep.png"));
    });

    public CandyflossSheepRenderer(EntityRendererProvider.Context context) {
        super(context, new CandyflossSheepModel());
    }

    public ResourceLocation getTextureLocation(CandyflossSheepEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public void render(CandyflossSheepEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.4f, 0.4f, 0.4f);
        } else {
            poseStack.scale(0.8f, 0.8f, 0.8f);
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

