/*
 * Decompiled with CFR 0.152.
 */
package com.example.modid.forge;

import com.example.modid.forge.network.NetworkPackets;
import com.example.modid.krylix.Krylix;
import com.example.modid.krylix.model.KillEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J!\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u000bH\u0002J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Lcom/example/modid/forge/KillFeedManager;", "", "()V", "activeNotifications", "", "Lcom/example/modid/krylix/model/KillEntry;", "<set-?>", "", "isEnabled", "()Z", "broadcastKillNotification", "", "killEntry", "calculateDistance", "", "attacker", "Lnet/minecraft/world/entity/LivingEntity;", "victim", "(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/LivingEntity;)Ljava/lang/Double;", "cleanupOldNotifications", "getActiveNotifications", "", "getWeaponName", "", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "handleDeath", "entity", "setEnabled", "enabled", "forge"})
public final class KillFeedManager {
    @NotNull
    public static final KillFeedManager INSTANCE = new KillFeedManager();
    @NotNull
    private static final List<KillEntry> activeNotifications = new ArrayList();
    private static boolean isEnabled = true;

    private KillFeedManager() {
    }

    public final boolean isEnabled() {
        return isEnabled;
    }

    public final void handleDeath(@NotNull LivingEntity entity, @NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!isEnabled || entity.m_9236_().f_46443_) {
            return;
        }
        String victimName = entity.m_7755_().getString();
        Object object = entity instanceof Player ? (Player)entity : null;
        String victimUUIDString = object != null && (object = object.m_20148_()) != null ? ((UUID)object).toString() : null;
        Entity entity2 = source.m_7639_();
        LivingEntity killerEntity = entity2 instanceof LivingEntity ? (LivingEntity)entity2 : null;
        LivingEntity livingEntity = killerEntity;
        String killerName = livingEntity != null && (livingEntity = livingEntity.m_7755_()) != null ? livingEntity.getString() : null;
        Object object2 = killerEntity instanceof Player ? (Player)killerEntity : null;
        String killerUUIDString = object2 != null && (object2 = object2.m_20148_()) != null ? ((UUID)object2).toString() : null;
        Player player = killerEntity instanceof Player ? (Player)killerEntity : null;
        float killerHealth = player != null ? player.m_21223_() : 20.0f;
        String weaponName = this.getWeaponName(source);
        Double distance = this.calculateDistance(killerEntity, entity);
        Intrinsics.checkNotNull((Object)victimName);
        KillEntry killEntry = new KillEntry(killerName, killerUUIDString, victimName, victimUUIDString, killerHealth, weaponName, distance, 0L, false, 384, null);
        activeNotifications.add(killEntry);
        Krylix.INSTANCE.getLOGGER().info("Kill registered: " + killEntry);
        this.broadcastKillNotification(killEntry);
        this.cleanupOldNotifications();
    }

    private final String getWeaponName(DamageSource source) {
        String string;
        if (source.m_7640_() instanceof Player) {
            Entity entity = source.m_7640_();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)entity;
            ItemStack weapon = player.m_21205_();
            String string2 = weapon.m_41619_() ? "Fists" : weapon.m_41611_().getString();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            String string3 = source.m_19385_();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getMsgId(...)");
            if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"arrow", (boolean)false, (int)2, null)) {
                string = "Projectile";
            } else {
                String string4 = source.m_19385_();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getMsgId(...)");
                if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"fire", (boolean)false, (int)2, null)) {
                    string = "Fire";
                } else {
                    String string5 = source.m_19385_();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getMsgId(...)");
                    if (StringsKt.contains$default((CharSequence)string5, (CharSequence)"magic", (boolean)false, (int)2, null)) {
                        string = "Magic";
                    } else {
                        String string6 = source.m_19385_();
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getMsgId(...)");
                        if (StringsKt.contains$default((CharSequence)string6, (CharSequence)"explosion", (boolean)false, (int)2, null)) {
                            string = "Explosion";
                        } else {
                            String string7 = source.m_19385_();
                            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getMsgId(...)");
                            if (StringsKt.contains$default((CharSequence)string7, (CharSequence)"fall", (boolean)false, (int)2, null)) {
                                string = "Fall Damage";
                            } else {
                                String string8 = source.m_19385_();
                                string = string8;
                                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getMsgId(...)");
                            }
                        }
                    }
                }
            }
        }
        return string;
    }

    private final Double calculateDistance(LivingEntity attacker, LivingEntity victim) {
        return attacker != null && victim != null ? Double.valueOf(attacker.m_20280_((Entity)victim)) : null;
    }

    private final void broadcastKillNotification(KillEntry killEntry) {
        NetworkPackets.INSTANCE.sendKillNotificationToAll(killEntry);
        Krylix.INSTANCE.getLOGGER().debug("Broadcasted kill notification to all clients: " + killEntry);
    }

    private final void cleanupOldNotifications() {
        int fadeTime = 5;
        activeNotifications.removeIf(arg_0 -> KillFeedManager.cleanupOldNotifications$lambda$0((Function1)new Function1<KillEntry, Boolean>(fadeTime){
            final /* synthetic */ int $fadeTime;
            {
                this.$fadeTime = $fadeTime;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KillEntry it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.isExpired(this.$fadeTime);
            }
        }, arg_0));
    }

    public final void setEnabled(boolean enabled) {
        isEnabled = enabled;
        Krylix.INSTANCE.getLOGGER().info("Kill feed " + (enabled ? "enabled" : "disabled"));
    }

    @NotNull
    public final List<KillEntry> getActiveNotifications() {
        return CollectionsKt.toList((Iterable)activeNotifications);
    }

    private static final boolean cleanupOldNotifications$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

