/*
 * Decompiled with CFR 0.152.
 */
package com.example.modid.forge.client;

import com.example.modid.forge.client.KillFeedHud;
import com.example.modid.forge.client.KillStreak;
import com.example.modid.krylix.Krylix;
import com.example.modid.krylix.model.KillEntry;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005J\u0006\u0010\u0019\u001a\u00020\u0017J\b\u0010\u001a\u001a\u00020\u0017H\u0002J\u0006\u0010\u001b\u001a\u00020\u0017J\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0014\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010\u000fH\u0002J\u0006\u0010#\u001a\u00020\u0007J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020&H\u0002J\u0006\u0010'\u001a\u00020\fJ\u0012\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010+\u001a\u00020\u0017H\u0002J\u0012\u0010,\u001a\u00020\u00172\b\u0010-\u001a\u0004\u0018\u00010\u000fH\u0002J\u0014\u0010.\u001a\u0004\u0018\u00010\u000f2\b\u0010/\u001a\u0004\u0018\u00010\u000fH\u0002J\u0016\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u001fJ0\u00104\u001a\u00020\u00172\u0006\u00101\u001a\u0002022\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u0007H\u0002J2\u0010:\u001a\u00020\u00172\u0006\u00101\u001a\u0002022\b\u0010;\u001a\u0004\u0018\u00010\u000f2\u0006\u0010<\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J2\u0010=\u001a\u00020\u00172\u0006\u00101\u001a\u0002022\u0006\u0010>\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u000f2\u0006\u0010<\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u0007H\u0002J<\u0010?\u001a\u00020\u00172\u0006\u00101\u001a\u0002022\b\u0010@\u001a\u0004\u0018\u00010A2\b\u0010;\u001a\u0004\u0018\u00010\u000f2\u0006\u0010<\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010B\u001a\u00020\u00172\u0006\u0010C\u001a\u00020\fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/example/modid/forge/client/KillFeedHud;", "", "()V", "activeNotifications", "", "Lcom/example/modid/krylix/model/KillEntry;", "entryHeight", "", "entrySpacing", "headSize", "hpColor", "isEnabled", "", "killStreaks", "", "", "Lcom/example/modid/forge/client/KillStreak;", "killerColor", "maxEntries", "padding", "victimColor", "weaponSize", "addNotification", "", "killEntry", "addTestNotification", "cleanupOldNotifications", "clearNotifications", "getAlphaColor", "baseColor", "alpha", "", "getMobTexture", "Lnet/minecraft/resources/ResourceLocation;", "mobName", "getNotificationCount", "getWeaponAnimationOffset", "timestamp", "", "isHudEnabled", "parseWeaponItem", "Lnet/minecraft/world/item/ItemStack;", "weaponName", "playKillSound", "playStreakSound", "streakText", "processKillStreak", "killerName", "render", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "partialTick", "renderEntry", "font", "Lnet/minecraft/client/gui/Font;", "entry", "screenWidth", "y", "renderFallbackHead", "playerName", "x", "renderMobFace", "texture", "renderPlayerHead", "playerUUID", "Ljava/util/UUID;", "setEnabled", "enabled", "forge"})
@SourceDebugExtension(value={"SMAP\nKillFeedHud.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KillFeedHud.kt\ncom/example/modid/forge/client/KillFeedHud\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,494:1\n1864#2,3:495\n288#2,2:499\n1#3:498\n372#4,7:501\n*S KotlinDebug\n*F\n+ 1 KillFeedHud.kt\ncom/example/modid/forge/client/KillFeedHud\n*L\n149#1:495,3\n227#1:499,2\n434#1:501,7\n*E\n"})
public final class KillFeedHud {
    @NotNull
    public static final KillFeedHud INSTANCE = new KillFeedHud();
    @NotNull
    private static final List<KillEntry> activeNotifications = new ArrayList();
    private static boolean isEnabled = true;
    @NotNull
    private static final Map<String, KillStreak> killStreaks = new LinkedHashMap();
    private static final int maxEntries = 5;
    private static final int entryHeight = 20;
    private static final int headSize = 16;
    private static final int weaponSize = 16;
    private static final int padding = 4;
    private static final int entrySpacing = 4;
    private static final int killerColor = new Color(255, 100, 100).getRGB();
    private static final int victimColor = new Color(100, 150, 255).getRGB();
    private static final int hpColor = new Color(255, 255, 255).getRGB();

    private KillFeedHud() {
    }

    public final void addNotification(@NotNull KillEntry killEntry) {
        String streakText;
        Intrinsics.checkNotNullParameter((Object)killEntry, (String)"killEntry");
        if (!isEnabled) {
            return;
        }
        activeNotifications.add(killEntry);
        if (activeNotifications.size() > maxEntries) {
            activeNotifications.remove(0);
        }
        if ((streakText = this.processKillStreak(killEntry.getKillerName())) != null) {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer localPlayer = minecraft.f_91074_;
            if (localPlayer != null) {
                localPlayer.m_213846_((Component)Component.m_237113_((String)("\u00a76\u00a7l" + streakText)));
            }
            this.playStreakSound(streakText);
        } else {
            this.playKillSound();
        }
        Krylix.INSTANCE.getLOGGER().debug("Added kill notification to HUD: " + killEntry);
    }

    private final void playKillSound() {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localPlayer = minecraft.f_91074_;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        player.m_9236_().m_5594_((Player)player, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.5f, 1.2f);
    }

    private final ItemStack parseWeaponItem(String weaponName) {
        ItemStack itemStack;
        String string = weaponName;
        if (string == null) {
            string = "Unknown";
        }
        String name = string;
        if (StringsKt.contains((CharSequence)name, (CharSequence)"Sword", (boolean)true)) {
            ItemStack itemStack2 = Items.f_42388_.m_7968_();
            itemStack = itemStack2;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getDefaultInstance(...)");
        } else if (StringsKt.contains((CharSequence)name, (CharSequence)"Axe", (boolean)true)) {
            ItemStack itemStack3 = Items.f_42386_.m_7968_();
            itemStack = itemStack3;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"getDefaultInstance(...)");
        } else if (StringsKt.contains((CharSequence)name, (CharSequence)"Pickaxe", (boolean)true)) {
            ItemStack itemStack4 = Items.f_42385_.m_7968_();
            itemStack = itemStack4;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack4, (String)"getDefaultInstance(...)");
        } else if (StringsKt.contains((CharSequence)name, (CharSequence)"Shovel", (boolean)true)) {
            ItemStack itemStack5 = Items.f_42384_.m_7968_();
            itemStack = itemStack5;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack5, (String)"getDefaultInstance(...)");
        } else if (StringsKt.contains((CharSequence)name, (CharSequence)"Bow", (boolean)true)) {
            ItemStack itemStack6 = Items.f_42411_.m_7968_();
            itemStack = itemStack6;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack6, (String)"getDefaultInstance(...)");
        } else if (StringsKt.contains((CharSequence)name, (CharSequence)"Crossbow", (boolean)true)) {
            ItemStack itemStack7 = Items.f_42717_.m_7968_();
            itemStack = itemStack7;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack7, (String)"getDefaultInstance(...)");
        } else if (StringsKt.contains((CharSequence)name, (CharSequence)"Trident", (boolean)true)) {
            ItemStack itemStack8 = Items.f_42713_.m_7968_();
            itemStack = itemStack8;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack8, (String)"getDefaultInstance(...)");
        } else if (StringsKt.contains((CharSequence)name, (CharSequence)"Projectile", (boolean)true)) {
            ItemStack itemStack9 = Items.f_42412_.m_7968_();
            itemStack = itemStack9;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack9, (String)"getDefaultInstance(...)");
        } else if (StringsKt.contains((CharSequence)name, (CharSequence)"Arrow", (boolean)true)) {
            ItemStack itemStack10 = Items.f_42412_.m_7968_();
            itemStack = itemStack10;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack10, (String)"getDefaultInstance(...)");
        } else if (StringsKt.contains((CharSequence)name, (CharSequence)"Spectral Arrow", (boolean)true)) {
            ItemStack itemStack11 = Items.f_42737_.m_7968_();
            itemStack = itemStack11;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack11, (String)"getDefaultInstance(...)");
        } else if (StringsKt.contains((CharSequence)name, (CharSequence)"Fireball", (boolean)true)) {
            ItemStack itemStack12 = Items.f_42613_.m_7968_();
            itemStack = itemStack12;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack12, (String)"getDefaultInstance(...)");
        } else if (StringsKt.contains((CharSequence)name, (CharSequence)"Firework", (boolean)true)) {
            ItemStack itemStack13 = Items.f_42688_.m_7968_();
            itemStack = itemStack13;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack13, (String)"getDefaultInstance(...)");
        } else if (StringsKt.contains((CharSequence)name, (CharSequence)"Melee", (boolean)true)) {
            ItemStack itemStack14 = Items.f_42383_.m_7968_();
            itemStack = itemStack14;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack14, (String)"getDefaultInstance(...)");
        } else if (StringsKt.contains((CharSequence)name, (CharSequence)"Magic", (boolean)true)) {
            ItemStack itemStack15 = Items.f_42690_.m_7968_();
            itemStack = itemStack15;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack15, (String)"getDefaultInstance(...)");
        } else if (StringsKt.contains((CharSequence)name, (CharSequence)"Explosion", (boolean)true)) {
            ItemStack itemStack16 = Items.f_41996_.m_7968_();
            itemStack = itemStack16;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack16, (String)"getDefaultInstance(...)");
        } else {
            ItemStack itemStack17 = Items.f_42383_.m_7968_();
            itemStack = itemStack17;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack17, (String)"getDefaultInstance(...)");
        }
        return itemStack;
    }

    /*
     * WARNING - void declaration
     */
    public final void render(@NotNull GuiGraphics guiGraphics, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        if (!isEnabled || activeNotifications.isEmpty()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        Window window = minecraft.m_91268_();
        this.cleanupOldNotifications();
        int startY = 5;
        List notificationsCopy = CollectionsKt.toList((Iterable)activeNotifications);
        Iterable $this$forEachIndexed$iv = notificationsCopy;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void entry;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KillEntry killEntry = (KillEntry)item$iv;
            int index = n;
            boolean bl = false;
            int y = startY + index * (entryHeight + entrySpacing);
            Intrinsics.checkNotNull((Object)font);
            INSTANCE.renderEntry(guiGraphics, font, (KillEntry)entry, window.m_85445_(), y);
        }
    }

    private final void renderEntry(GuiGraphics guiGraphics, Font font, KillEntry entry, int screenWidth, int y) {
        int startX;
        int n;
        UUID uUID;
        UUID uUID2;
        float alpha = entry.getAlpha(15);
        String string = entry.getKillerUUIDString();
        if (string != null) {
            String it = string;
            boolean bl = false;
            uUID2 = UUID.fromString(it);
        } else {
            uUID2 = null;
        }
        UUID killerUUID = uUID2;
        String string2 = entry.getVictimUUIDString();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            uUID = UUID.fromString(it);
        } else {
            uUID = null;
        }
        UUID victimUUID = uUID;
        String hpText = (int)entry.getKillerHealth() + "HP";
        int hpWidth = font.m_92895_(hpText);
        String string3 = entry.getKillerName();
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            n = font.m_92895_(it);
        } else {
            n = 0;
        }
        int killerNameWidth = n;
        int victimNameWidth = font.m_92895_(entry.getVictimName());
        int totalWidth = headSize + padding + killerNameWidth + padding + weaponSize + padding + headSize + padding + victimNameWidth + padding + hpWidth;
        int currentX = startX = screenWidth - totalWidth - 10;
        this.renderPlayerHead(guiGraphics, killerUUID, entry.getKillerName(), currentX, y, alpha);
        currentX += headSize + padding;
        if (entry.getKillerName() != null) {
            guiGraphics.m_280488_(font, entry.getKillerName(), currentX, y + 4, this.getAlphaColor(killerColor, alpha));
            currentX += killerNameWidth + padding;
        }
        ItemStack weaponItem = this.parseWeaponItem(entry.getWeaponName());
        int animationOffset = this.getWeaponAnimationOffset(entry.getTimestamp());
        guiGraphics.m_280480_(weaponItem, currentX, y + animationOffset);
        this.renderPlayerHead(guiGraphics, victimUUID, entry.getVictimName(), currentX += weaponSize + padding, y, alpha);
        guiGraphics.m_280488_(font, entry.getVictimName(), currentX += headSize + padding, y + 4, this.getAlphaColor(victimColor, alpha));
        guiGraphics.m_280488_(font, hpText, currentX += victimNameWidth + padding, y + 4, this.getAlphaColor(hpColor, alpha));
    }

    private final void renderPlayerHead(GuiGraphics guiGraphics, UUID playerUUID, String playerName, int x, int y, float alpha) {
        PlayerInfo playerInfo;
        ClientPacketListener connection;
        Minecraft minecraft = Minecraft.m_91087_();
        ResourceLocation skinTexture = null;
        boolean isMob = false;
        if (playerUUID != null) {
            ClientPacketListener clientPacketListener = connection = minecraft.m_91403_();
            Object object = playerInfo = clientPacketListener != null ? clientPacketListener.m_104949_(playerUUID) : null;
            if (playerInfo != null) {
                skinTexture = playerInfo.m_105337_();
            }
        }
        if (skinTexture == null && playerName != null) {
            connection = minecraft.m_91403_();
            Object object = connection;
            if (object != null && (object = object.m_105142_()) != null) {
                Object v3;
                block18: {
                    Iterable $this$firstOrNull$iv = (Iterable)object;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PlayerInfo it = (PlayerInfo)element$iv;
                        boolean bl = false;
                        if (!StringsKt.equals((String)it.m_105312_().getName(), (String)playerName, (boolean)true)) continue;
                        v3 = element$iv;
                        break block18;
                    }
                    v3 = null;
                }
                v4 = v3;
            } else {
                v4 = playerInfo = null;
            }
            if (playerInfo != null) {
                skinTexture = playerInfo.m_105337_();
            } else {
                skinTexture = this.getMobTexture(playerName);
                if (skinTexture != null) {
                    isMob = true;
                } else {
                    try {
                        GameProfile gameProfile = new GameProfile(playerUUID, playerName);
                        SkinManager skinManager = minecraft.m_91109_();
                        skinTexture = skinManager.m_240306_(gameProfile);
                    }
                    catch (Exception e) {
                        Krylix.INSTANCE.getLOGGER().debug("Failed to load skin for " + playerName + ": " + e.getMessage());
                    }
                }
            }
        }
        if (skinTexture != null) {
            try {
                RenderSystem.setShaderTexture((int)0, skinTexture);
                RenderSystem.enableBlend();
                if (isMob) {
                    this.renderMobFace(guiGraphics, skinTexture, playerName, x, y);
                } else {
                    guiGraphics.m_280411_(skinTexture, x, y, headSize, headSize, 8.0f, 8.0f, 8, 8, 64, 64);
                    guiGraphics.m_280411_(skinTexture, x, y, headSize, headSize, 40.0f, 8.0f, 8, 8, 64, 64);
                }
                RenderSystem.disableBlend();
            }
            catch (Exception e) {
                Krylix.INSTANCE.getLOGGER().debug("Failed to render skin texture for " + playerName + ": " + e.getMessage());
                this.renderFallbackHead(guiGraphics, playerName, x, y, alpha);
            }
        } else {
            this.renderFallbackHead(guiGraphics, playerName, x, y, alpha);
        }
    }

    private final ResourceLocation getMobTexture(String mobName) {
        if (mobName == null) {
            return null;
        }
        String string = mobName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return switch (string) {
            case "zombie" -> new ResourceLocation("minecraft", "textures/entity/zombie/zombie.png");
            case "skeleton" -> new ResourceLocation("minecraft", "textures/entity/skeleton/skeleton.png");
            case "creeper" -> new ResourceLocation("minecraft", "textures/entity/creeper/creeper.png");
            case "spider" -> new ResourceLocation("minecraft", "textures/entity/spider/spider.png");
            case "cave spider" -> new ResourceLocation("minecraft", "textures/entity/spider/cave_spider.png");
            case "enderman" -> null;
            case "piglin" -> new ResourceLocation("minecraft", "textures/entity/piglin/piglin.png");
            case "piglin brute" -> new ResourceLocation("minecraft", "textures/entity/piglin/piglin_brute.png");
            case "zombified piglin", "zombie pigman" -> new ResourceLocation("minecraft", "textures/entity/piglin/zombified_piglin.png");
            case "wither skeleton" -> new ResourceLocation("minecraft", "textures/entity/skeleton/wither_skeleton.png");
            case "stray" -> new ResourceLocation("minecraft", "textures/entity/skeleton/stray.png");
            case "husk" -> new ResourceLocation("minecraft", "textures/entity/zombie/husk.png");
            case "drowned" -> new ResourceLocation("minecraft", "textures/entity/zombie/drowned.png");
            case "blaze" -> new ResourceLocation("minecraft", "textures/entity/blaze.png");
            case "ghast" -> new ResourceLocation("minecraft", "textures/entity/ghast/ghast.png");
            case "slime" -> new ResourceLocation("minecraft", "textures/entity/slime/slime.png");
            case "magmacube", "magma cube" -> new ResourceLocation("minecraft", "textures/entity/slime/magmacube.png");
            case "witch" -> new ResourceLocation("minecraft", "textures/entity/witch.png");
            case "pillager" -> new ResourceLocation("minecraft", "textures/entity/illager/pillager.png");
            case "vindicator" -> new ResourceLocation("minecraft", "textures/entity/illager/vindicator.png");
            case "evoker" -> new ResourceLocation("minecraft", "textures/entity/illager/evoker.png");
            case "ravager" -> new ResourceLocation("minecraft", "textures/entity/illager/ravager.png");
            case "vex" -> new ResourceLocation("minecraft", "textures/entity/illager/vex.png");
            case "phantom" -> new ResourceLocation("minecraft", "textures/entity/phantom.png");
            case "shulker" -> new ResourceLocation("minecraft", "textures/entity/shulker/shulker.png");
            case "silverfish" -> new ResourceLocation("minecraft", "textures/entity/silverfish.png");
            case "endermite" -> new ResourceLocation("minecraft", "textures/entity/endermite.png");
            case "guardian" -> new ResourceLocation("minecraft", "textures/entity/guardian.png");
            case "elder guardian" -> new ResourceLocation("minecraft", "textures/entity/guardian_elder.png");
            case "wither" -> new ResourceLocation("minecraft", "textures/entity/wither/wither.png");
            case "ender dragon" -> new ResourceLocation("minecraft", "textures/entity/enderdragon/dragon.png");
            default -> null;
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void renderMobFace(GuiGraphics guiGraphics, ResourceLocation texture, String mobName, int x, int y) {
        String string;
        String string2 = mobName;
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            v2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        } else {
            v2 = string = null;
        }
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 3214373: {
                    if (!string.equals("husk")) break;
                    n = 1;
                    break;
                }
                case -696355290: {
                    if (!string.equals("zombie")) break;
                    n = 1;
                    break;
                }
                case 1925942999: {
                    if (!string.equals("drowned")) break;
                    n = 1;
                    break;
                }
                case 1731036562: {
                    if (!string.equals("enderman")) break;
                    n = 2;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    guiGraphics.m_280411_(texture, x, y, headSize, headSize, 8.0f, 8.0f, 8, 8, 64, 64);
                    return;
                }
                case 2: {
                    guiGraphics.m_280411_(texture, x, y, headSize, headSize, 40.0f, 0.0f, 8, 8, 64, 32);
                    return;
                }
            }
        }
        guiGraphics.m_280411_(texture, x, y, headSize, headSize, 8.0f, 8.0f, 8, 8, 64, 32);
    }

    private final void renderFallbackHead(GuiGraphics guiGraphics, String playerName, int x, int y, float alpha) {
        String name;
        String string = playerName;
        if (string == null) {
            string = "Unknown";
        }
        int color = StringsKt.contains((CharSequence)(name = string), (CharSequence)"1", (boolean)true) ? killerColor : victimColor;
        guiGraphics.m_280509_(x, y, x + headSize, y + headSize, this.getAlphaColor(color, alpha));
    }

    private final int getAlphaColor(int baseColor, float alpha) {
        int alphaInt = (int)(alpha * (float)255);
        return baseColor & 0xFFFFFF | alphaInt << 24;
    }

    private final int getWeaponAnimationOffset(long timestamp) {
        long currentTime = System.currentTimeMillis();
        long age = currentTime - timestamp;
        double frequency = 2.0;
        double amplitude = 2.0;
        double offset = amplitude * Math.sin((double)age / 1000.0 * frequency * 2.0 * Math.PI);
        return (int)offset;
    }

    private final void cleanupOldNotifications() {
        activeNotifications.removeIf(arg_0 -> KillFeedHud.cleanupOldNotifications$lambda$5(cleanupOldNotifications.1.INSTANCE, arg_0));
    }

    public final void setEnabled(boolean enabled) {
        isEnabled = enabled;
        if (!enabled) {
            activeNotifications.clear();
        }
        Krylix.INSTANCE.getLOGGER().info("Kill feed HUD " + (enabled ? "enabled" : "disabled"));
    }

    public final boolean isHudEnabled() {
        return isEnabled;
    }

    public final int getNotificationCount() {
        return activeNotifications.size();
    }

    public final void addTestNotification() {
        KillEntry testEntry = new KillEntry("TestKiller", "12345678-1234-1234-1234-123456789abc", "TestVictim", "87654321-4321-4321-4321-cba987654321", 18.0f, "Diamond Sword", 5.0, 0L, false, 384, null);
        activeNotifications.add(testEntry);
        Krylix.INSTANCE.getLOGGER().info("Added test kill notification for debugging");
    }

    public final void clearNotifications() {
        activeNotifications.clear();
        killStreaks.clear();
        Krylix.INSTANCE.getLOGGER().info("Cleared all kill notifications");
    }

    private final String processKillStreak(String killerName) {
        KillStreak streak;
        KillStreak killStreak;
        if (killerName == null) {
            return null;
        }
        long currentTime = System.currentTimeMillis();
        Map<String, KillStreak> $this$getOrPut$iv = killStreaks;
        boolean $i$f$getOrPut = false;
        KillStreak value$iv = $this$getOrPut$iv.get(killerName);
        if (value$iv == null) {
            boolean bl = false;
            KillStreak answer$iv = new KillStreak(killerName, 0, currentTime);
            $this$getOrPut$iv.put(killerName, answer$iv);
            killStreak = answer$iv;
        } else {
            killStreak = value$iv;
        }
        if (currentTime - (streak = killStreak).getLastKillTime() > 10000L) {
            streak.setCount(1);
        } else {
            int n = streak.getCount();
            streak.setCount(n + 1);
        }
        streak.setLastKillTime(currentTime);
        return switch (streak.getCount()) {
            case 2 -> "DOUBLE KILL!";
            case 3 -> "TRIPLE KILL!";
            case 4 -> "MEGA KILL!";
            case 5 -> "ULTRA KILL!";
            case 6 -> "MONSTER KILL!";
            case 7 -> "RAMPAGE!";
            default -> streak.getCount() > 7 ? "GODLIKE!" : null;
        };
    }

    /*
     * Unable to fully structure code
     */
    private final void playStreakSound(String streakText) {
        block12: {
            block11: {
                block10: {
                    if (streakText == null) {
                        return;
                    }
                    minecraft = Minecraft.m_91087_();
                    v0 = minecraft.f_91074_;
                    if (v0 == null) {
                        return;
                    }
                    player = v0;
                    var5_4 = streakText;
                    switch (var5_4.hashCode()) {
                        case -1985671615: {
                            if (var5_4.equals("TRIPLE KILL!")) break;
                            ** break;
                        }
                        case -380650667: {
                            if (!var5_4.equals("MEGA KILL!")) {
                                ** break;
                            }
                            break block10;
                        }
                        case -1952115985: {
                            if (!var5_4.equals("ULTRA KILL!")) {
                                ** break;
                            }
                            break block11;
                        }
                        case -1483744396: {
                            if (!var5_4.equals("DOUBLE KILL!")) ** break;
                            v1 = new Triple((Object)SoundEvents.f_12275_, (Object)Float.valueOf(0.7f), (Object)Float.valueOf(1.2f));
                            break block12;
                        }
                    }
                    v1 = new Triple((Object)SoundEvents.f_12275_, (Object)Float.valueOf(0.8f), (Object)Float.valueOf(1.4f));
                    break block12;
                }
                v1 = new Triple((Object)SoundEvents.f_12275_, (Object)Float.valueOf(0.9f), (Object)Float.valueOf(1.6f));
                break block12;
            }
            v1 = new Triple((Object)SoundEvents.f_12275_, (Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.8f));
            break block12;
lbl33:
            // 5 sources

            v1 = new Triple((Object)SoundEvents.f_12275_, (Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f));
        }
        var4_5 = v1;
        sound = (SoundEvent)var4_5.component1();
        volume = ((Number)var4_5.component2()).floatValue();
        pitch = ((Number)var4_5.component3()).floatValue();
        player.m_9236_().m_5594_((Player)player, player.m_20183_(), sound, SoundSource.PLAYERS, volume, pitch);
    }

    private static final boolean cleanupOldNotifications$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

