/*
 * Decompiled with CFR 0.152.
 */
package com.example.modid.forge.network;

import com.example.modid.forge.client.KillFeedHud;
import com.example.modid.krylix.Krylix;
import com.example.modid.krylix.model.KillEntry;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/example/modid/forge/network/NetworkPackets;", "", "()V", "CHANNEL", "Lnet/minecraftforge/network/simple/SimpleChannel;", "getCHANNEL", "()Lnet/minecraftforge/network/simple/SimpleChannel;", "PROTOCOL_VERSION", "", "sendKillNotificationToAll", "", "killEntry", "Lcom/example/modid/krylix/model/KillEntry;", "sendKillNotificationToPlayer", "player", "Lnet/minecraft/server/level/ServerPlayer;", "KillNotificationPacket", "forge"})
public final class NetworkPackets {
    @NotNull
    public static final NetworkPackets INSTANCE = new NetworkPackets();
    @NotNull
    private static final String PROTOCOL_VERSION = "1";
    @NotNull
    private static final SimpleChannel CHANNEL;

    private NetworkPackets() {
    }

    @NotNull
    public final SimpleChannel getCHANNEL() {
        return CHANNEL;
    }

    public final void sendKillNotificationToAll(@NotNull KillEntry killEntry) {
        Intrinsics.checkNotNullParameter((Object)killEntry, (String)"killEntry");
        KillNotificationPacket packet = new KillNotificationPacket(killEntry);
        CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
        Krylix.INSTANCE.getLOGGER().debug("Sent kill notification to all clients: " + killEntry);
    }

    public final void sendKillNotificationToPlayer(@NotNull ServerPlayer player, @NotNull KillEntry killEntry) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)killEntry, (String)"killEntry");
        KillNotificationPacket packet = new KillNotificationPacket(killEntry);
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> NetworkPackets.sendKillNotificationToPlayer$lambda$4(player)), (Object)packet);
        Krylix.INSTANCE.getLOGGER().debug("Sent kill notification to " + player.m_7755_().getString() + ": " + killEntry);
    }

    private static final String CHANNEL$lambda$0() {
        return PROTOCOL_VERSION;
    }

    private static final boolean CHANNEL$lambda$1(String it) {
        return Intrinsics.areEqual((Object)PROTOCOL_VERSION, (Object)it);
    }

    private static final boolean CHANNEL$lambda$2(String it) {
        return Intrinsics.areEqual((Object)PROTOCOL_VERSION, (Object)it);
    }

    private static final void _init_$lambda$3(KillNotificationPacket msg, Supplier ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        msg.handle(ctx);
    }

    private static final ServerPlayer sendKillNotificationToPlayer$lambda$4(ServerPlayer $player) {
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        return $player;
    }

    static {
        SimpleChannel simpleChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("krylix", "main"), NetworkPackets::CHANNEL$lambda$0, NetworkPackets::CHANNEL$lambda$1, NetworkPackets::CHANNEL$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)simpleChannel, (String)"newSimpleChannel(...)");
        CHANNEL = simpleChannel;
        CHANNEL.messageBuilder(KillNotificationPacket.class, 0).encoder(KillNotificationPacket::encode).decoder(KillNotificationPacket.Companion::decode).consumerMainThread(NetworkPackets::_init_$lambda$3).add();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 02\u00020\u0001:\u00010B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B9\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\nH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011J\t\u0010\u001e\u001a\u00020\fH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u000eH\u00c6\u0003JN\u0010 \u001a\u00020\u00002\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001\u00a2\u0006\u0002\u0010!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0013\u0010&\u001a\u00020\u000e2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0014\u0010(\u001a\u00020#2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*J\b\u0010,\u001a\u00020#H\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001J\t\u0010/\u001a\u00020\u0006H\u00d6\u0001R\u0015\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0013R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015\u00a8\u00061"}, d2={"Lcom/example/modid/forge/network/NetworkPackets$KillNotificationPacket;", "", "killEntry", "Lcom/example/modid/krylix/model/KillEntry;", "(Lcom/example/modid/krylix/model/KillEntry;)V", "killerName", "", "victimName", "weaponName", "distance", "", "timestamp", "", "isHeadshot", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Double;JZ)V", "getDistance", "()Ljava/lang/Double;", "Ljava/lang/Double;", "()Z", "getKillerName", "()Ljava/lang/String;", "getTimestamp", "()J", "getVictimName", "getWeaponName", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Double;JZ)Lcom/example/modid/forge/network/NetworkPackets$KillNotificationPacket;", "encode", "", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "equals", "other", "handle", "ctx", "Ljava/util/function/Supplier;", "Lnet/minecraftforge/network/NetworkEvent$Context;", "handleOnClient", "hashCode", "", "toString", "Companion", "forge"})
    public static final class KillNotificationPacket {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String killerName;
        @NotNull
        private final String victimName;
        @NotNull
        private final String weaponName;
        @Nullable
        private final Double distance;
        private final long timestamp;
        private final boolean isHeadshot;

        public KillNotificationPacket(@Nullable String killerName, @NotNull String victimName, @NotNull String weaponName, @Nullable Double distance, long timestamp, boolean isHeadshot) {
            Intrinsics.checkNotNullParameter((Object)victimName, (String)"victimName");
            Intrinsics.checkNotNullParameter((Object)weaponName, (String)"weaponName");
            this.killerName = killerName;
            this.victimName = victimName;
            this.weaponName = weaponName;
            this.distance = distance;
            this.timestamp = timestamp;
            this.isHeadshot = isHeadshot;
        }

        @Nullable
        public final String getKillerName() {
            return this.killerName;
        }

        @NotNull
        public final String getVictimName() {
            return this.victimName;
        }

        @NotNull
        public final String getWeaponName() {
            return this.weaponName;
        }

        @Nullable
        public final Double getDistance() {
            return this.distance;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final boolean isHeadshot() {
            return this.isHeadshot;
        }

        public KillNotificationPacket(@NotNull KillEntry killEntry) {
            Intrinsics.checkNotNullParameter((Object)killEntry, (String)"killEntry");
            this(killEntry.getKillerName(), killEntry.getVictimName(), killEntry.getWeaponName(), killEntry.getDistance(), killEntry.getTimestamp(), killEntry.isHeadshot());
        }

        public final void encode(@NotNull FriendlyByteBuf buf) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            String string = this.killerName;
            if (string == null) {
                string = "";
            }
            buf.m_130070_(string);
            buf.m_130070_(this.victimName);
            buf.m_130070_(this.weaponName);
            Double d = this.distance;
            buf.writeDouble(d != null ? d : 0.0);
            buf.writeLong(this.timestamp);
            buf.writeBoolean(this.isHeadshot);
        }

        public final void handle(@NotNull Supplier<NetworkEvent.Context> ctx) {
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            ctx.get().enqueueWork(() -> KillNotificationPacket.handle$lambda$0(ctx, this));
            ctx.get().setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private final void handleOnClient() {
            KillEntry killEntry = new KillEntry(this.killerName, null, this.victimName, null, 0.0f, this.weaponName, this.distance, this.timestamp, this.isHeadshot, 26, null);
            KillFeedHud.INSTANCE.addNotification(killEntry);
            Krylix.INSTANCE.getLOGGER().debug("Received kill notification on client: " + killEntry);
        }

        @Nullable
        public final String component1() {
            return this.killerName;
        }

        @NotNull
        public final String component2() {
            return this.victimName;
        }

        @NotNull
        public final String component3() {
            return this.weaponName;
        }

        @Nullable
        public final Double component4() {
            return this.distance;
        }

        public final long component5() {
            return this.timestamp;
        }

        public final boolean component6() {
            return this.isHeadshot;
        }

        @NotNull
        public final KillNotificationPacket copy(@Nullable String killerName, @NotNull String victimName, @NotNull String weaponName, @Nullable Double distance, long timestamp, boolean isHeadshot) {
            Intrinsics.checkNotNullParameter((Object)victimName, (String)"victimName");
            Intrinsics.checkNotNullParameter((Object)weaponName, (String)"weaponName");
            return new KillNotificationPacket(killerName, victimName, weaponName, distance, timestamp, isHeadshot);
        }

        public static /* synthetic */ KillNotificationPacket copy$default(KillNotificationPacket killNotificationPacket, String string, String string2, String string3, Double d, long l, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = killNotificationPacket.killerName;
            }
            if ((n & 2) != 0) {
                string2 = killNotificationPacket.victimName;
            }
            if ((n & 4) != 0) {
                string3 = killNotificationPacket.weaponName;
            }
            if ((n & 8) != 0) {
                d = killNotificationPacket.distance;
            }
            if ((n & 0x10) != 0) {
                l = killNotificationPacket.timestamp;
            }
            if ((n & 0x20) != 0) {
                bl = killNotificationPacket.isHeadshot;
            }
            return killNotificationPacket.copy(string, string2, string3, d, l, bl);
        }

        @NotNull
        public String toString() {
            return "KillNotificationPacket(killerName=" + this.killerName + ", victimName=" + this.victimName + ", weaponName=" + this.weaponName + ", distance=" + this.distance + ", timestamp=" + this.timestamp + ", isHeadshot=" + this.isHeadshot + ")";
        }

        public int hashCode() {
            int result = this.killerName == null ? 0 : this.killerName.hashCode();
            result = result * 31 + this.victimName.hashCode();
            result = result * 31 + this.weaponName.hashCode();
            result = result * 31 + (this.distance == null ? 0 : ((Object)this.distance).hashCode());
            result = result * 31 + Long.hashCode(this.timestamp);
            int n = this.isHeadshot ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KillNotificationPacket)) {
                return false;
            }
            KillNotificationPacket killNotificationPacket = (KillNotificationPacket)other;
            if (!Intrinsics.areEqual((Object)this.killerName, (Object)killNotificationPacket.killerName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.victimName, (Object)killNotificationPacket.victimName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.weaponName, (Object)killNotificationPacket.weaponName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.distance, (Object)killNotificationPacket.distance)) {
                return false;
            }
            if (this.timestamp != killNotificationPacket.timestamp) {
                return false;
            }
            return this.isHeadshot == killNotificationPacket.isHeadshot;
        }

        private static final void handle$lambda$0(Supplier $ctx, KillNotificationPacket this$0) {
            Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            if (((NetworkEvent.Context)$ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                this$0.handleOnClient();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/example/modid/forge/network/NetworkPackets$KillNotificationPacket$Companion;", "", "()V", "decode", "Lcom/example/modid/forge/network/NetworkPackets$KillNotificationPacket;", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "forge"})
        @SourceDebugExtension(value={"SMAP\nNetworkPackets.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkPackets.kt\ncom/example/modid/forge/network/NetworkPackets$KillNotificationPacket$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KillNotificationPacket decode(@NotNull FriendlyByteBuf buf) {
                String string;
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                String it = string = buf.m_130277_();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                String killerName = ((CharSequence)it).length() > 0 ? string : null;
                String victimName = buf.m_130277_();
                String weaponName = buf.m_130277_();
                Double d = buf.readDouble();
                double it2 = ((Number)d).doubleValue();
                boolean bl2 = false;
                Double distance = !(it2 == 0.0) ? d : null;
                long timestamp = buf.readLong();
                boolean isHeadshot = buf.readBoolean();
                Intrinsics.checkNotNull((Object)victimName);
                Intrinsics.checkNotNull((Object)weaponName);
                return new KillNotificationPacket(killerName, victimName, weaponName, distance, timestamp, isHeadshot);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

