/*
 * Decompiled with CFR 0.152.
 */
package com.ddd.torchthrowmod;

import com.ddd.torchthrowmod.ModKeyBindings;
import com.ddd.torchthrowmod.ThrowTorchPacket;
import com.ddd.torchthrowmod.compat.TorchCompatManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="torch_throw_mod", value={Dist.CLIENT})
public class KeyInputHandler {
    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        ItemStack torchStack;
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player != null && minecraft.screen == null && ModKeyBindings.THROW_TORCH_KEY.consumeClick() && !(torchStack = KeyInputHandler.findTorchInInventory((Player)player)).isEmpty()) {
            if (player.getCooldowns().isOnCooldown(torchStack.getItem())) {
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new ThrowTorchPacket(torchStack), (CustomPacketPayload[])new CustomPacketPayload[0]);
            player.swing(player.getUsedItemHand());
        }
    }

    private static ItemStack findTorchInInventory(Player player) {
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || !TorchCompatManager.isTorchItem(stack)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }
}

