/*
 * Decompiled with CFR 0.152.
 */
package com.ddd.torchthrowmod;

import com.ddd.torchthrowmod.compat.TorchCompatManager;
import com.ddd.torchthrowmod.entity.ThrownTorchEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class PlayerInteractHandler {
    private static final int COOLDOWN_TICKS = 10;

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        InteractionHand hand;
        Player player = event.getEntity();
        ItemStack itemStack = player.getItemInHand(hand = event.getHand());
        if (this.isTorchItem(itemStack) && !player.getCooldowns().isOnCooldown(itemStack.getItem())) {
            event.setCancellationResult(InteractionResult.FAIL);
            if (!player.level().isClientSide) {
                ItemStack thrownStack = itemStack.copy();
                thrownStack.setCount(1);
                ThrownTorchEntity torchEntity = new ThrownTorchEntity(player.level(), (LivingEntity)player, thrownStack);
                Vec3 eyePos = player.getEyePosition();
                torchEntity.setPos(eyePos.x, eyePos.y - 0.1, eyePos.z);
                Vec3 lookVec = player.getLookAngle();
                float speed = 1.2f;
                torchEntity.shoot(lookVec.x, lookVec.y, lookVec.z, speed, 1.0f);
                player.level().addFreshEntity((Entity)torchEntity);
                if (!player.isCreative()) {
                    itemStack.shrink(1);
                }
                player.getCooldowns().addCooldown(itemStack.getItem(), 10);
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 0.5f, 0.4f / (player.getRandom().nextFloat() * 0.4f + 0.8f));
            }
            player.swing(hand);
        }
    }

    private boolean isTorchItem(ItemStack stack) {
        return TorchCompatManager.isTorchItem(stack);
    }
}

