/*
 * Decompiled with CFR 0.152.
 */
package com.ddd.torchthrowmod;

import com.ddd.torchthrowmod.entity.ThrownTorchEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ThrowTorchPacket(ItemStack torchStack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ThrowTorchPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"torch_throw_mod:throw_torch"));
    public static final StreamCodec<FriendlyByteBuf, ThrowTorchPacket> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ThrowTorchPacket>(){

        public ThrowTorchPacket decode(FriendlyByteBuf buf) {
            return new ThrowTorchPacket(buf);
        }

        public void encode(FriendlyByteBuf buf, ThrowTorchPacket packet) {
            packet.write(buf);
        }
    };

    public ThrowTorchPacket(FriendlyByteBuf buf) {
        this((ItemStack)ItemStack.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)buf)));
    }

    public void write(FriendlyByteBuf buf) {
        ItemStack.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)buf), (Object)this.torchStack);
    }

    public CustomPacketPayload.Type<ThrowTorchPacket> type() {
        return TYPE;
    }

    public static void handle(ThrowTorchPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                ThrowTorchPacket.throwTorchFromInventory(serverPlayer, packet.torchStack);
            }
        });
    }

    private static void throwTorchFromInventory(ServerPlayer player, ItemStack torchStack) {
        if (!player.level().isClientSide) {
            ThrownTorchEntity torchEntity = new ThrownTorchEntity(player.level(), (LivingEntity)player, torchStack);
            torchEntity.setPos(player.getX(), player.getEyeY() - 0.1, player.getZ());
            torchEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.2f, 1.0f);
            player.level().addFreshEntity((Entity)torchEntity);
            if (!player.isCreative()) {
                ThrowTorchPacket.consumeTorchFromInventory(player, torchStack.getItem());
            }
            player.getCooldowns().addCooldown(torchStack.getItem(), 10);
        }
    }

    private static void consumeTorchFromInventory(ServerPlayer player, Item torchItem) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || stack.getItem() != torchItem) continue;
            stack.shrink(1);
            if (!stack.isEmpty()) break;
            player.getInventory().setItem(i, ItemStack.EMPTY);
            break;
        }
    }
}

