/*
 * Decompiled with CFR 0.152.
 */
package com.ddd.torchthrowmod;

import com.ddd.torchthrowmod.compat.TorchCompatManager;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ToggleThrowManager {
    private static final Set<UUID> PLAYERS_WITH_THROW_ENABLED = new HashSet<UUID>();

    public static void toggleThrowForPlayer(ServerPlayer player) {
        UUID playerId = player.getUUID();
        ItemStack heldItem = player.getMainHandItem();
        if (heldItem.isEmpty()) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.torchthrowmod.no_item"));
            return;
        }
        boolean wasEnabled = PLAYERS_WITH_THROW_ENABLED.contains(playerId);
        if (wasEnabled) {
            PLAYERS_WITH_THROW_ENABLED.remove(playerId);
            player.sendSystemMessage((Component)Component.translatable((String)"message.torchthrowmod.throw_disabled"));
        } else {
            PLAYERS_WITH_THROW_ENABLED.add(playerId);
            player.sendSystemMessage((Component)Component.translatable((String)"message.torchthrowmod.throw_enabled"));
        }
    }

    public static boolean isThrowEnabledForPlayer(ServerPlayer player) {
        return PLAYERS_WITH_THROW_ENABLED.contains(player.getUUID());
    }

    public static boolean canThrowItem(ServerPlayer player, ItemStack itemStack) {
        if (!ToggleThrowManager.isThrowEnabledForPlayer(player)) {
            return false;
        }
        return TorchCompatManager.isTorchItem(itemStack);
    }
}

