/*
 * Decompiled with CFR 0.152.
 */
package com.ddd.torchthrowmod.compat;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class TorchCompatManager {
    private static final Set<Item> KNOWN_TORCH_ITEMS = ConcurrentHashMap.newKeySet();
    private static final Map<Item, Block> TORCH_ITEM_TO_BLOCK = new ConcurrentHashMap<Item, Block>();
    private static final Map<Item, Block> TORCH_ITEM_TO_WALL_BLOCK = new ConcurrentHashMap<Item, Block>();
    private static final Map<Item, Block> TORCH_ITEM_TO_CEILING_BLOCK = new ConcurrentHashMap<Item, Block>();
    private static final Map<Item, Boolean> TORCH_CACHE = new ConcurrentHashMap<Item, Boolean>();
    private static final Map<Item, Block> TORCH_BLOCK_CACHE = new ConcurrentHashMap<Item, Block>();
    private static final Map<Item, Block> WALL_TORCH_CACHE = new ConcurrentHashMap<Item, Block>();
    private static final Map<Item, Block> CEILING_TORCH_CACHE = new ConcurrentHashMap<Item, Block>();
    private static boolean isInitialized = false;
    private static boolean isAutoScanComplete = false;
    private static volatile boolean isScanning = false;
    private static int scanProgress = 0;
    private static final int SCAN_BATCH_SIZE = 100;
    private static final Set<String> TARGET_KEYWORDS = Set.of("torch", "lantern", "candle");
    private static final Set<String> EXCLUDE_KEYWORDS = Set.of("lightning", "switch", "sensor", "detector", "button", "lever", "redstone", "comparator", "repeater", "daylight", "ender");
    private static final String[] WALL_PATTERNS = new String[]{"wall_%s", "%s_wall"};
    private static final String[] CEILING_PATTERNS = new String[]{"ceiling_%s", "hanging_%s", "%s_ceiling", "%s_hanging"};

    public static void initialize() {
        if (isInitialized) {
            return;
        }
        TorchCompatManager.registerVanillaTorches();
        TorchCompatManager.importFromCeilingTorchMod();
        isInitialized = true;
    }

    public static void importFromCeilingTorchMod() {
        try {
            if (!TorchCompatManager.isCeilingTorchModLoaded()) {
                System.out.println("[TorchCompat] \u5012\u7f6e\u706b\u628a\u6a21\u7ec4\u672a\u52a0\u8f7d\uff0c\u8df3\u8fc7\u5bfc\u5165");
                return;
            }
            System.out.println("[TorchCompat] \u5f00\u59cb\u4ece\u5012\u7f6e\u706b\u628a\u6a21\u7ec4\u5bfc\u5165\u5012\u7f6e\u706b\u628a\u6620\u5c04...");
            Map<String, Object> compatList = TorchCompatManager.getCeilingTorchCompatList();
            if (compatList == null || compatList.isEmpty()) {
                System.out.println("[TorchCompat] \u672a\u627e\u5230\u5012\u7f6e\u706b\u628a\u6a21\u7ec4\u7684\u517c\u5bb9\u5217\u8868");
                return;
            }
            int importedCount = 0;
            for (Object compat : compatList.values()) {
                Map<ResourceLocation, Block> placeEntries = TorchCompatManager.getPlaceEntriesFromCompat(compat);
                if (placeEntries == null) continue;
                importedCount += TorchCompatManager.processCeilingTorchEntries(placeEntries);
            }
            System.out.println("[TorchCompat] \u6210\u529f\u4ece\u5012\u7f6e\u706b\u628a\u6a21\u7ec4\u5bfc\u5165 " + importedCount + " \u4e2a\u5012\u7f6e\u706b\u628a\u6620\u5c04");
        }
        catch (Exception e) {
            System.err.println("[TorchCompat] \u4ece\u5012\u7f6e\u706b\u628a\u6a21\u7ec4\u5bfc\u5165\u6620\u5c04\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static boolean isCeilingTorchModLoaded() {
        try {
            Class.forName("bl4ckscor3.mod.ceilingtorch.CeilingTorch");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static Map<String, Object> getCeilingTorchCompatList() {
        try {
            Class<?> ceilingTorchClass = Class.forName("bl4ckscor3.mod.ceilingtorch.CeilingTorch");
            Field compatListField = ceilingTorchClass.getDeclaredField("COMPAT_LIST");
            compatListField.setAccessible(true);
            return (Map)compatListField.get(null);
        }
        catch (Exception e) {
            System.err.println("[TorchCompat] \u83b7\u53d6\u5012\u7f6e\u706b\u628a\u6a21\u7ec4\u517c\u5bb9\u5217\u8868\u5931\u8d25: " + e.getMessage());
            return null;
        }
    }

    private static Map<ResourceLocation, Block> getPlaceEntriesFromCompat(Object compat) {
        try {
            Method getPlaceEntriesMethod = compat.getClass().getMethod("getPlaceEntries", new Class[0]);
            return (Map)getPlaceEntriesMethod.invoke(compat, new Object[0]);
        }
        catch (Exception e) {
            System.err.println("[TorchCompat] \u83b7\u53d6\u653e\u7f6e\u6761\u76ee\u5931\u8d25: " + e.getMessage());
            return null;
        }
    }

    private static int processCeilingTorchEntries(Map<ResourceLocation, Block> placeEntries) {
        int processed = 0;
        for (Map.Entry<ResourceLocation, Block> entry : placeEntries.entrySet()) {
            ResourceLocation itemId = entry.getKey();
            Block ceilingBlock = entry.getValue();
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (item == null || item == Items.AIR) continue;
            if (TorchCompatManager.isLantern(item)) {
                System.out.println("[TorchCompat] \u8df3\u8fc7\u706f\u7b3c: " + String.valueOf(itemId) + " (\u706f\u7b3c\u4e0d\u9700\u8981\u5012\u7f6e\u53d8\u79cd)");
                continue;
            }
            TorchCompatManager.registerCeilingTorchFromCeilingTorchMod(item, ceilingBlock);
            ++processed;
            System.out.println("[TorchCompat] \u6ce8\u518c\u5012\u7f6e\u706b\u628a: " + String.valueOf(itemId) + " -> " + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)ceilingBlock)));
        }
        return processed;
    }

    private static boolean isLantern(Item item) {
        if (item == null) {
            return false;
        }
        if (item == Items.LANTERN || item == Items.SOUL_LANTERN) {
            return true;
        }
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
        return itemId != null && itemId.getPath().contains("lantern");
    }

    private static void registerCeilingTorchFromCeilingTorchMod(Item torchItem, Block ceilingBlock) {
        KNOWN_TORCH_ITEMS.add(torchItem);
        Block torchBlock = TorchCompatManager.extractTorchBlock(new ItemStack((ItemLike)torchItem));
        if (torchBlock != null) {
            TORCH_ITEM_TO_BLOCK.put(torchItem, torchBlock);
            TORCH_BLOCK_CACHE.put(torchItem, torchBlock);
        }
        TORCH_ITEM_TO_CEILING_BLOCK.put(torchItem, ceilingBlock);
        CEILING_TORCH_CACHE.put(torchItem, ceilingBlock);
        TORCH_CACHE.put(torchItem, true);
        Block wallBlock = TorchCompatManager.findWallTorchVariant(torchBlock);
        if (wallBlock != null) {
            TORCH_ITEM_TO_WALL_BLOCK.put(torchItem, wallBlock);
            WALL_TORCH_CACHE.put(torchItem, wallBlock);
        }
    }

    private static void registerVanillaTorches() {
        TorchCompatManager.registerTorch(Items.TORCH, Blocks.TORCH, Blocks.WALL_TORCH, null);
        TorchCompatManager.registerTorch(Items.REDSTONE_TORCH, Blocks.REDSTONE_TORCH, Blocks.REDSTONE_WALL_TORCH, null);
        TorchCompatManager.registerTorch(Items.SOUL_TORCH, Blocks.SOUL_TORCH, Blocks.SOUL_WALL_TORCH, null);
        TorchCompatManager.registerTorch(Items.LANTERN, Blocks.LANTERN, null, null);
        TorchCompatManager.registerTorch(Items.SOUL_LANTERN, Blocks.SOUL_LANTERN, null, null);
        TORCH_CACHE.put(Items.TORCH, true);
        TORCH_CACHE.put(Items.REDSTONE_TORCH, true);
        TORCH_CACHE.put(Items.SOUL_TORCH, true);
        TORCH_CACHE.put(Items.LANTERN, true);
        TORCH_CACHE.put(Items.SOUL_LANTERN, true);
    }

    public static void startStagedAutoScan() {
        if (isAutoScanComplete || isScanning) {
            return;
        }
        isScanning = true;
        scanProgress = 0;
        NeoForge.EVENT_BUS.addListener(TorchCompatManager::onServerTick);
    }

    private static void onServerTick(ServerTickEvent.Post event) {
        if (!isScanning || isAutoScanComplete) {
            return;
        }
        ArrayList allItemIds = new ArrayList(BuiltInRegistries.ITEM.keySet());
        int totalItems = allItemIds.size();
        int processedInBatch = 0;
        while (scanProgress < totalItems && processedInBatch < 100) {
            ResourceLocation itemId = (ResourceLocation)allItemIds.get(scanProgress);
            if (TorchCompatManager.quickTargetedPreCheck(itemId)) {
                try {
                    Block torchBlock;
                    ItemStack stack;
                    Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
                    if (item != Items.AIR && !KNOWN_TORCH_ITEMS.contains(item) && TorchCompatManager.isTorchItem(stack = new ItemStack((ItemLike)item)) && (torchBlock = TorchCompatManager.extractTorchBlock(stack)) != null && torchBlock != Blocks.AIR) {
                        if (TorchCompatManager.isLantern(item)) {
                            TorchCompatManager.registerTorch(item, torchBlock, null, null);
                        } else {
                            Block wallBlock = TorchCompatManager.findWallTorchVariant(torchBlock);
                            Block ceilingBlock = TorchCompatManager.findCeilingTorchVariant(torchBlock, itemId);
                            TorchCompatManager.registerTorch(item, torchBlock, wallBlock, null);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++processedInBatch;
            }
            ++scanProgress;
        }
        if (scanProgress >= totalItems) {
            isAutoScanComplete = true;
            isScanning = false;
            NeoForge.EVENT_BUS.unregister(TorchCompatManager.class);
            System.out.println("[TorchCompat] \u9488\u5bf9\u6027\u626b\u63cf\u5b8c\u6210\uff0c\u5171\u6ce8\u518c " + KNOWN_TORCH_ITEMS.size() + " \u4e2a\u706b\u628a\u76f8\u5173\u7269\u54c1");
        }
    }

    private static boolean quickTargetedPreCheck(ResourceLocation itemId) {
        String path = itemId.getPath();
        for (String exclude : EXCLUDE_KEYWORDS) {
            if (!path.contains(exclude)) continue;
            return false;
        }
        for (String keyword : TARGET_KEYWORDS) {
            if (!path.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTorchItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        Boolean cached = TORCH_CACHE.get(item);
        if (cached != null) {
            return cached;
        }
        TorchCompatManager.initialize();
        boolean result = false;
        result = KNOWN_TORCH_ITEMS.contains(item) ? true : TorchCompatManager.strictKeywordCheck(stack);
        TORCH_CACHE.put(item, result);
        return result;
    }

    private static boolean strictKeywordCheck(ItemStack stack) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        if (itemId == null) {
            return false;
        }
        String itemPath = itemId.getPath();
        for (String exclude : EXCLUDE_KEYWORDS) {
            if (!itemPath.contains(exclude)) continue;
            return false;
        }
        for (String keyword : TARGET_KEYWORDS) {
            if (!itemPath.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    public static Block getCeilingTorchBlock(ItemStack torchItem) {
        Block torchBlock;
        if (torchItem == null || torchItem.isEmpty()) {
            return null;
        }
        TorchCompatManager.initialize();
        Item item = torchItem.getItem();
        if (item == null) {
            return null;
        }
        if (TorchCompatManager.isLantern(item)) {
            return null;
        }
        Block cached = CEILING_TORCH_CACHE.get(item);
        if (cached != null) {
            return cached;
        }
        Block result = TORCH_ITEM_TO_CEILING_BLOCK.get(item);
        if (result == null && (torchBlock = TorchCompatManager.getTorchBlock(torchItem)) != null) {
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)torchItem.getItem());
            result = TorchCompatManager.findCeilingTorchVariant(torchBlock, itemId);
        }
        if (result != null) {
            CEILING_TORCH_CACHE.put(item, result);
        }
        return result;
    }

    public static Block getTorchBlock(ItemStack torchItem) {
        if (torchItem == null || torchItem.isEmpty()) {
            return null;
        }
        TorchCompatManager.initialize();
        Item item = torchItem.getItem();
        if (item == null) {
            return null;
        }
        Block cached = TORCH_BLOCK_CACHE.get(item);
        if (cached != null) {
            return cached;
        }
        Block result = TORCH_ITEM_TO_BLOCK.get(item);
        if (result == null) {
            result = TorchCompatManager.extractTorchBlock(torchItem);
        }
        if (result != null) {
            TORCH_BLOCK_CACHE.put(item, result);
        }
        return result;
    }

    public static Block getWallTorchBlock(ItemStack torchItem) {
        Block torchBlock;
        if (torchItem == null || torchItem.isEmpty()) {
            return null;
        }
        TorchCompatManager.initialize();
        Item item = torchItem.getItem();
        if (item == null) {
            return null;
        }
        if (TorchCompatManager.isLantern(item)) {
            return null;
        }
        Block cached = WALL_TORCH_CACHE.get(item);
        if (cached != null) {
            return cached;
        }
        Block result = TORCH_ITEM_TO_WALL_BLOCK.get(item);
        if (result == null && (torchBlock = TorchCompatManager.getTorchBlock(torchItem)) != null) {
            result = TorchCompatManager.findWallTorchVariant(torchBlock);
        }
        if (result != null) {
            WALL_TORCH_CACHE.put(item, result);
        }
        return result;
    }

    private static Block extractTorchBlock(ItemStack stack) {
        try {
            Block block;
            ResourceLocation blockId;
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                return ((BlockItem)item).getBlock();
            }
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
            if (itemId != null && (blockId = ResourceLocation.tryParse((String)(itemId.getNamespace() + ":" + itemId.getPath()))) != null && (block = (Block)BuiltInRegistries.BLOCK.get(blockId)) != null && block != Blocks.AIR) {
                return block;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Block findWallTorchVariant(Block torchBlock) {
        ResourceLocation torchId = BuiltInRegistries.BLOCK.getKey((Object)torchBlock);
        if (torchId == null) {
            return null;
        }
        for (String pattern : WALL_PATTERNS) {
            Block wallBlock;
            String formatted = String.format(pattern, torchId.getPath());
            ResourceLocation wallId = ResourceLocation.tryParse((String)(torchId.getNamespace() + ":" + formatted));
            if (wallId == null || (wallBlock = (Block)BuiltInRegistries.BLOCK.get(wallId)) == null || wallBlock == Blocks.AIR) continue;
            return wallBlock;
        }
        return null;
    }

    private static Block findCeilingTorchVariant(Block torchBlock, ResourceLocation torchItemId) {
        ResourceLocation torchId = BuiltInRegistries.BLOCK.getKey((Object)torchBlock);
        if (torchId == null) {
            return null;
        }
        for (String pattern : CEILING_PATTERNS) {
            Block ceilingBlock;
            String formatted = String.format(pattern, torchId.getPath());
            ResourceLocation ceilingId = ResourceLocation.tryParse((String)(torchId.getNamespace() + ":" + formatted));
            if (ceilingId == null || (ceilingBlock = (Block)BuiltInRegistries.BLOCK.get(ceilingId)) == null || ceilingBlock == Blocks.AIR) continue;
            return ceilingBlock;
        }
        return null;
    }

    public static void registerTorch(Item torchItem, Block torchBlock, Block wallTorchBlock, String ceilingTorchId) {
        Block ceilingBlock;
        ResourceLocation ceilingId;
        KNOWN_TORCH_ITEMS.add(torchItem);
        TORCH_ITEM_TO_BLOCK.put(torchItem, torchBlock);
        if (wallTorchBlock != null) {
            TORCH_ITEM_TO_WALL_BLOCK.put(torchItem, wallTorchBlock);
        }
        if (ceilingTorchId != null && (ceilingId = ResourceLocation.tryParse((String)ceilingTorchId)) != null && (ceilingBlock = (Block)BuiltInRegistries.BLOCK.get(ceilingId)) != null && ceilingBlock != Blocks.AIR) {
            TORCH_ITEM_TO_CEILING_BLOCK.put(torchItem, ceilingBlock);
        }
        TORCH_CACHE.put(torchItem, true);
        TORCH_BLOCK_CACHE.put(torchItem, torchBlock);
        if (wallTorchBlock != null) {
            WALL_TORCH_CACHE.put(torchItem, wallTorchBlock);
        }
    }

    public static void registerCeilingTorch(Item torchItem, Block ceilingBlock) {
        if (torchItem != null && ceilingBlock != null) {
            TORCH_ITEM_TO_CEILING_BLOCK.put(torchItem, ceilingBlock);
            CEILING_TORCH_CACHE.put(torchItem, ceilingBlock);
        }
    }

    public static Set<Item> getKnownTorchItems() {
        TorchCompatManager.initialize();
        return Collections.unmodifiableSet(KNOWN_TORCH_ITEMS);
    }

    public static void rescanTorches() {
        TORCH_CACHE.clear();
        TORCH_BLOCK_CACHE.clear();
        WALL_TORCH_CACHE.clear();
        CEILING_TORCH_CACHE.clear();
        isAutoScanComplete = false;
        TorchCompatManager.startStagedAutoScan();
    }

    public static String getStats() {
        TorchCompatManager.initialize();
        return String.format("\u5df2\u77e5\u706b\u628a: %d, \u5899\u4e0a\u53d8\u79cd: %d, \u5012\u7f6e\u53d8\u79cd: %d, \u7f13\u5b58\u547d\u4e2d\u7387: \u9ad8", KNOWN_TORCH_ITEMS.size(), TORCH_ITEM_TO_WALL_BLOCK.size(), TORCH_ITEM_TO_CEILING_BLOCK.size());
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static String getScanStatus() {
        if (!isInitialized) {
            return "\u672a\u521d\u59cb\u5316";
        }
        if (isScanning) {
            return "\u626b\u63cf\u4e2d (" + scanProgress + "/" + BuiltInRegistries.ITEM.keySet().size() + ")";
        }
        if (isAutoScanComplete) {
            return "\u626b\u63cf\u5b8c\u6210";
        }
        return "\u7b49\u5f85\u626b\u63cf";
    }
}

