/*
 * Decompiled with CFR 0.152.
 */
package com.ddd.torchthrowmod.entity;

import com.ddd.torchthrowmod.ModEntities;
import com.ddd.torchthrowmod.compat.TorchCompatManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownTorchEntity
extends ThrowableItemProjectile {
    private ItemStack torchItem;

    public ThrownTorchEntity(EntityType<? extends ThrownTorchEntity> entityType, Level level) {
        super(entityType, level);
        this.torchItem = new ItemStack((ItemLike)Items.TORCH);
    }

    public ThrownTorchEntity(Level level, LivingEntity shooter, ItemStack torchItem) {
        super((EntityType)ModEntities.THROWN_TORCH.get(), shooter, level);
        this.torchItem = torchItem != null && !torchItem.isEmpty() ? torchItem.copyWithCount(1) : new ItemStack((ItemLike)Items.TORCH);
    }

    protected Item getDefaultItem() {
        return this.getTorchItem().getItem();
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)Items.TORCH);
    }

    public ItemStack getTorchItem() {
        if (this.torchItem == null || this.torchItem.isEmpty()) {
            this.torchItem = new ItemStack((ItemLike)Items.TORCH);
        }
        return this.torchItem;
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            if (result.getType() == HitResult.Type.BLOCK) {
                BlockHitResult blockResult = (BlockHitResult)result;
                this.placeTorch(blockResult);
            } else if (result.getType() == HitResult.Type.ENTITY) {
                EntityHitResult entityResult = (EntityHitResult)result;
                this.igniteEntity(entityResult.getEntity());
            }
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity target;
        super.onHitEntity(result);
        if (!this.level().isClientSide && (target = result.getEntity()) instanceof LivingEntity) {
            Vec3 knockbackDirection = target.position().subtract(this.position()).normalize();
            double knockbackStrength = 0.5;
            target.setDeltaMovement(target.getDeltaMovement().add(knockbackDirection.x * knockbackStrength, 0.3, knockbackDirection.z * knockbackStrength));
            target.hurtMarked = true;
        }
    }

    private void placeTorch(BlockHitResult result) {
        BlockPos placePos;
        Direction direction;
        BlockPos hitPos;
        Level level = this.level();
        if (this.tryPlaceTorchWithCompat(level, hitPos = result.getBlockPos(), direction = result.getDirection(), placePos = hitPos.relative(direction))) {
            return;
        }
        if (this.searchAndPlaceNearby(level, hitPos, direction)) {
            return;
        }
        this.spawnTorchItem(level, placePos);
    }

    private boolean searchAndPlaceNearby(Level level, BlockPos hitPos, Direction hitDirection) {
        Direction oppositeDirection = hitDirection.getOpposite();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos searchPos;
                    if (x == 0 && y == 0 && z == 0 || this.isPositionInOppositeDirection(hitPos, searchPos = hitPos.offset(x, y, z), hitDirection, oppositeDirection) || !level.isEmptyBlock(searchPos)) continue;
                    for (Direction dir : Direction.values()) {
                        BlockPos adjacentPos = searchPos.relative(dir.getOpposite());
                        if (!this.tryPlaceTorchWithCompat(level, adjacentPos, dir, searchPos)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean isPositionInOppositeDirection(BlockPos hitPos, BlockPos searchPos, Direction hitDirection, Direction oppositeDirection) {
        int dx = searchPos.getX() - hitPos.getX();
        int dy = searchPos.getY() - hitPos.getY();
        int dz = searchPos.getZ() - hitPos.getZ();
        switch (oppositeDirection) {
            case DOWN: {
                return dy < 0;
            }
            case UP: {
                return dy > 0;
            }
            case NORTH: {
                return dz < 0;
            }
            case SOUTH: {
                return dz > 0;
            }
            case WEST: {
                return dx < 0;
            }
            case EAST: {
                return dx > 0;
            }
        }
        return false;
    }

    private boolean tryPlaceTorchWithCompat(Level level, BlockPos hitPos, Direction direction, BlockPos placePos) {
        BlockState ceilingState;
        Block ceilingTorchBlock;
        BlockState state = level.getBlockState(placePos);
        if (!state.is(Blocks.SNOW) && !state.isAir()) {
            return false;
        }
        ItemStack torchStack = this.getTorchItem();
        Block torchBlock = TorchCompatManager.getTorchBlock(torchStack);
        if (torchBlock == null) {
            return false;
        }
        if (this.isLantern(torchBlock) && direction == Direction.DOWN) {
            BlockState lanternState = torchBlock.defaultBlockState();
            if (lanternState.hasProperty((Property)LanternBlock.HANGING)) {
                lanternState = (BlockState)lanternState.setValue((Property)LanternBlock.HANGING, (Comparable)Boolean.valueOf(true));
            }
            if (lanternState.canSurvive((LevelReader)level, placePos)) {
                level.setBlock(placePos, lanternState, 3);
                level.playSound(null, placePos, SoundEvents.LANTERN_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        }
        if (direction == Direction.DOWN && (ceilingTorchBlock = TorchCompatManager.getCeilingTorchBlock(torchStack)) != null && (ceilingState = ceilingTorchBlock.defaultBlockState()).canSurvive((LevelReader)level, placePos)) {
            level.setBlock(placePos, ceilingState, 3);
            level.playSound(null, placePos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        BlockState torchState = this.getTorchStateForDirection(direction, torchBlock);
        if (torchState != null && torchState.canSurvive((LevelReader)level, placePos)) {
            level.setBlock(placePos, torchState, 3);
            level.playSound(null, placePos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private boolean isLantern(Block block) {
        if (block == null) {
            return false;
        }
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)block);
        return blockId != null && blockId.getPath().contains("lantern");
    }

    private BlockState getTorchStateForDirection(Direction direction, Block torchBlock) {
        Block wallTorchBlock;
        if (torchBlock == null) {
            return null;
        }
        if (direction == Direction.UP) {
            return torchBlock.defaultBlockState();
        }
        if (direction != Direction.DOWN && (wallTorchBlock = TorchCompatManager.getWallTorchBlock(this.getTorchItem())) != null) {
            BlockState wallState = wallTorchBlock.defaultBlockState();
            if (wallState.hasProperty((Property)WallTorchBlock.FACING)) {
                return (BlockState)wallState.setValue((Property)WallTorchBlock.FACING, (Comparable)direction);
            }
            return wallState;
        }
        return null;
    }

    private void spawnTorchItem(Level level, BlockPos pos) {
        if (!level.isClientSide) {
            ItemStack torchStack = this.getTorchItem();
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 1.0;
            double z = (double)pos.getZ() + 0.5;
            ItemStack singleTorch = torchStack.copy();
            singleTorch.setCount(1);
            ItemEntity torchItemEntity = new ItemEntity(level, x, y, z, singleTorch);
            torchItemEntity.setDeltaMovement((level.random.nextDouble() - 0.5) * 0.1, level.random.nextDouble() * 0.1, (level.random.nextDouble() - 0.5) * 0.1);
            torchItemEntity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)torchItemEntity);
            level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.2f, (level.random.nextFloat() - level.random.nextFloat()) * 1.4f + 2.0f);
        }
    }

    private void igniteEntity(Entity entity) {
        if (entity instanceof LivingEntity) {
            Level level;
            entity.setRemainingFireTicks(100);
            this.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.FIRECHARGE_USE, SoundSource.NEUTRAL, 0.5f, 1.0f);
            if (!this.level().isClientSide && (level = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 5; ++i) {
                    double x = entity.getX() + (this.random.nextDouble() - 0.5) * (double)entity.getBbWidth();
                    double y = entity.getY() + this.random.nextDouble() * (double)entity.getBbHeight();
                    double z = entity.getZ() + (this.random.nextDouble() - 0.5) * (double)entity.getBbWidth();
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            SimpleParticleType particleType = ParticleTypes.FLAME;
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)particleType, this.getX() + (this.random.nextDouble() - 0.5) * 0.1, this.getY() + 0.1, this.getZ() + (this.random.nextDouble() - 0.5) * 0.1, 0.0, 0.0, 0.0);
            }
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }
}

