/*
 * Decompiled with CFR 0.152.
 */
package com.ddd.torchthrowmod;

import com.ddd.torchthrowmod.entity.ThrownTorchEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ThrowTorchPacket {
    private final ItemStack torchStack;

    public ThrowTorchPacket(ItemStack torchStack) {
        this.torchStack = torchStack != null ? torchStack.m_41777_() : ItemStack.f_41583_;
    }

    public ThrowTorchPacket(FriendlyByteBuf buf) {
        this.torchStack = buf.m_130267_();
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130055_(this.torchStack);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null) {
                ThrowTorchPacket.throwTorchFromInventory(player, this.torchStack);
            }
        });
        context.get().setPacketHandled(true);
    }

    private static void throwTorchFromInventory(ServerPlayer player, ItemStack torchStack) {
        if (!player.m_9236_().f_46443_ && !torchStack.m_41619_()) {
            ThrownTorchEntity torchEntity = new ThrownTorchEntity(player.m_9236_(), (LivingEntity)player, torchStack);
            torchEntity.m_6034_(player.m_20185_(), player.m_20188_() - 0.1, player.m_20189_());
            torchEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.2f, 1.0f);
            player.m_9236_().m_7967_((Entity)torchEntity);
            if (!player.m_7500_()) {
                ThrowTorchPacket.consumeTorchFromInventory(player, torchStack.m_41720_());
            }
            player.m_36335_().m_41524_(torchStack.m_41720_(), 10);
        }
    }

    private static void consumeTorchFromInventory(ServerPlayer player, Item torchItem) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || stack.m_41720_() != torchItem) continue;
            stack.m_41774_(1);
            if (!stack.m_41619_()) break;
            player.m_150109_().m_6836_(i, ItemStack.f_41583_);
            break;
        }
    }
}

