/*
 * Decompiled with CFR 0.152.
 */
package com.ddd.torchthrowmod;

import com.ddd.torchthrowmod.compat.TorchCompatManager;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ToggleThrowManager {
    private static final Set<UUID> PLAYERS_WITH_THROW_ENABLED = new HashSet<UUID>();

    public static void toggleThrowForPlayer(ServerPlayer player) {
        UUID playerId = player.m_20148_();
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41619_()) {
            player.m_213846_((Component)Component.m_237115_((String)"message.torchthrowmod.no_item"));
            return;
        }
        boolean wasEnabled = PLAYERS_WITH_THROW_ENABLED.contains(playerId);
        if (wasEnabled) {
            PLAYERS_WITH_THROW_ENABLED.remove(playerId);
            player.m_213846_((Component)Component.m_237115_((String)"message.torchthrowmod.throw_disabled"));
        } else {
            PLAYERS_WITH_THROW_ENABLED.add(playerId);
            player.m_213846_((Component)Component.m_237115_((String)"message.torchthrowmod.throw_enabled"));
        }
    }

    public static boolean isThrowEnabledForPlayer(ServerPlayer player) {
        return PLAYERS_WITH_THROW_ENABLED.contains(player.m_20148_());
    }

    public static boolean canThrowItem(ServerPlayer player, ItemStack itemStack) {
        if (!ToggleThrowManager.isThrowEnabledForPlayer(player)) {
            return false;
        }
        return TorchCompatManager.isTorchItem(itemStack);
    }
}

