/*
 * Decompiled with CFR 0.152.
 */
package com.ddd.torchthrowmod.compat;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;

public class TorchCompatManager {
    private static final Set<Item> KNOWN_TORCH_ITEMS = ConcurrentHashMap.newKeySet();
    private static final Map<Item, Block> TORCH_ITEM_TO_BLOCK = new ConcurrentHashMap<Item, Block>();
    private static final Map<Item, Block> TORCH_ITEM_TO_WALL_BLOCK = new ConcurrentHashMap<Item, Block>();
    private static final Map<Item, Block> TORCH_ITEM_TO_CEILING_BLOCK = new ConcurrentHashMap<Item, Block>();
    private static final Map<Item, Boolean> TORCH_CACHE = new ConcurrentHashMap<Item, Boolean>();
    private static final Map<Item, Block> TORCH_BLOCK_CACHE = new ConcurrentHashMap<Item, Block>();
    private static final Map<Item, Block> WALL_TORCH_CACHE = new ConcurrentHashMap<Item, Block>();
    private static final Map<Item, Block> CEILING_TORCH_CACHE = new ConcurrentHashMap<Item, Block>();
    private static boolean isInitialized = false;
    private static boolean isAutoScanComplete = false;
    private static volatile boolean isScanning = false;
    private static int scanProgress = 0;
    private static final int SCAN_BATCH_SIZE = 100;
    private static final Set<String> TARGET_KEYWORDS = Set.of("torch", "lantern", "candle");
    private static final Set<String> EXCLUDE_KEYWORDS = Set.of("lightning", "switch", "sensor", "detector", "button", "lever", "redstone", "comparator", "repeater", "daylight", "ender");
    private static final String[] WALL_PATTERNS = new String[]{"wall_%s", "%s_wall"};
    private static final String[] CEILING_PATTERNS = new String[]{"ceiling_%s", "hanging_%s", "%s_ceiling", "%s_hanging"};

    public static void initialize() {
        if (isInitialized) {
            return;
        }
        TorchCompatManager.registerVanillaTorches();
        TorchCompatManager.importFromCeilingTorchMod();
        isInitialized = true;
    }

    public static void importFromCeilingTorchMod() {
        try {
            if (!TorchCompatManager.isCeilingTorchModLoaded()) {
                System.out.println("[TorchCompat] \u5012\u7f6e\u706b\u628a\u6a21\u7ec4\u672a\u52a0\u8f7d\uff0c\u8df3\u8fc7\u5bfc\u5165");
                return;
            }
            System.out.println("[TorchCompat] \u5f00\u59cb\u4ece\u5012\u7f6e\u706b\u628a\u6a21\u7ec4\u5bfc\u5165\u5012\u7f6e\u706b\u628a\u6620\u5c04...");
            Map<String, Object> compatList = TorchCompatManager.getCeilingTorchCompatList();
            if (compatList == null || compatList.isEmpty()) {
                System.out.println("[TorchCompat] \u672a\u627e\u5230\u5012\u7f6e\u706b\u628a\u6a21\u7ec4\u7684\u517c\u5bb9\u5217\u8868");
                return;
            }
            int importedCount = 0;
            for (Object compat : compatList.values()) {
                Map<ResourceLocation, Block> placeEntries = TorchCompatManager.getPlaceEntriesFromCompat(compat);
                if (placeEntries == null) continue;
                importedCount += TorchCompatManager.processCeilingTorchEntries(placeEntries);
            }
            System.out.println("[TorchCompat] \u6210\u529f\u4ece\u5012\u7f6e\u706b\u628a\u6a21\u7ec4\u5bfc\u5165 " + importedCount + " \u4e2a\u5012\u7f6e\u706b\u628a\u6620\u5c04");
        }
        catch (Exception e) {
            System.err.println("[TorchCompat] \u4ece\u5012\u7f6e\u706b\u628a\u6a21\u7ec4\u5bfc\u5165\u6620\u5c04\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static boolean isCeilingTorchModLoaded() {
        try {
            Class.forName("bl4ckscor3.mod.ceilingtorch.CeilingTorch");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static Map<String, Object> getCeilingTorchCompatList() {
        try {
            Class<?> ceilingTorchClass = Class.forName("bl4ckscor3.mod.ceilingtorch.CeilingTorch");
            Field compatListField = ceilingTorchClass.getDeclaredField("COMPAT_LIST");
            compatListField.setAccessible(true);
            return (Map)compatListField.get(null);
        }
        catch (Exception e) {
            System.err.println("[TorchCompat] \u83b7\u53d6\u5012\u7f6e\u706b\u628a\u6a21\u7ec4\u517c\u5bb9\u5217\u8868\u5931\u8d25: " + e.getMessage());
            return null;
        }
    }

    private static Map<ResourceLocation, Block> getPlaceEntriesFromCompat(Object compat) {
        try {
            Method getPlaceEntriesMethod = compat.getClass().getMethod("getPlaceEntries", new Class[0]);
            return (Map)getPlaceEntriesMethod.invoke(compat, new Object[0]);
        }
        catch (Exception e) {
            System.err.println("[TorchCompat] \u83b7\u53d6\u653e\u7f6e\u6761\u76ee\u5931\u8d25: " + e.getMessage());
            return null;
        }
    }

    private static int processCeilingTorchEntries(Map<ResourceLocation, Block> placeEntries) {
        int processed = 0;
        for (Map.Entry<ResourceLocation, Block> entry : placeEntries.entrySet()) {
            ResourceLocation itemId = entry.getKey();
            Block ceilingBlock = entry.getValue();
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId);
            if (item == null || item == Items.f_41852_) continue;
            if (TorchCompatManager.isLantern(item)) {
                System.out.println("[TorchCompat] \u8df3\u8fc7\u706f\u7b3c: " + itemId + " (\u706f\u7b3c\u4e0d\u9700\u8981\u5012\u7f6e\u53d8\u79cd)");
                continue;
            }
            TorchCompatManager.registerCeilingTorchFromCeilingTorchMod(item, ceilingBlock);
            ++processed;
            System.out.println("[TorchCompat] \u6ce8\u518c\u5012\u7f6e\u706b\u628a: " + itemId + " -> " + BuiltInRegistries.f_256975_.m_7981_((Object)ceilingBlock));
        }
        return processed;
    }

    private static boolean isLantern(Item item) {
        if (item == null) {
            return false;
        }
        if (item == Items.f_42778_ || item == Items.f_42779_) {
            return true;
        }
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        return itemId != null && itemId.m_135815_().contains("lantern");
    }

    private static void registerCeilingTorchFromCeilingTorchMod(Item torchItem, Block ceilingBlock) {
        KNOWN_TORCH_ITEMS.add(torchItem);
        Block torchBlock = TorchCompatManager.extractTorchBlock(new ItemStack((ItemLike)torchItem));
        if (torchBlock != null) {
            TORCH_ITEM_TO_BLOCK.put(torchItem, torchBlock);
            TORCH_BLOCK_CACHE.put(torchItem, torchBlock);
        }
        TORCH_ITEM_TO_CEILING_BLOCK.put(torchItem, ceilingBlock);
        CEILING_TORCH_CACHE.put(torchItem, ceilingBlock);
        TORCH_CACHE.put(torchItem, true);
        Block wallBlock = TorchCompatManager.findWallTorchVariant(torchBlock);
        if (wallBlock != null) {
            TORCH_ITEM_TO_WALL_BLOCK.put(torchItem, wallBlock);
            WALL_TORCH_CACHE.put(torchItem, wallBlock);
        }
    }

    private static void registerVanillaTorches() {
        TorchCompatManager.registerTorch(Items.f_42000_, Blocks.f_50081_, Blocks.f_50082_, null);
        TorchCompatManager.registerTorch(Items.f_41978_, Blocks.f_50174_, Blocks.f_50123_, null);
        TorchCompatManager.registerTorch(Items.f_42053_, Blocks.f_50139_, Blocks.f_50140_, null);
        TorchCompatManager.registerTorch(Items.f_42778_, Blocks.f_50681_, null, null);
        TorchCompatManager.registerTorch(Items.f_42779_, Blocks.f_50682_, null, null);
        TORCH_CACHE.put(Items.f_42000_, true);
        TORCH_CACHE.put(Items.f_41978_, true);
        TORCH_CACHE.put(Items.f_42053_, true);
        TORCH_CACHE.put(Items.f_42778_, true);
        TORCH_CACHE.put(Items.f_42779_, true);
    }

    public static void startStagedAutoScan() {
        if (isAutoScanComplete || isScanning) {
            return;
        }
        isScanning = true;
        scanProgress = 0;
        MinecraftForge.EVENT_BUS.addListener(TorchCompatManager::onServerTick);
    }

    private static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!isScanning || isAutoScanComplete) {
            return;
        }
        ArrayList allItemIds = new ArrayList(BuiltInRegistries.f_257033_.m_6566_());
        int totalItems = allItemIds.size();
        int processedInBatch = 0;
        while (scanProgress < totalItems && processedInBatch < 100) {
            ResourceLocation itemId = (ResourceLocation)allItemIds.get(scanProgress);
            if (TorchCompatManager.quickTargetedPreCheck(itemId)) {
                try {
                    Block torchBlock;
                    ItemStack stack;
                    Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId);
                    if (item != Items.f_41852_ && !KNOWN_TORCH_ITEMS.contains(item) && TorchCompatManager.isTorchItem(stack = new ItemStack((ItemLike)item)) && (torchBlock = TorchCompatManager.extractTorchBlock(stack)) != null && torchBlock != Blocks.f_50016_) {
                        if (TorchCompatManager.isLantern(item)) {
                            TorchCompatManager.registerTorch(item, torchBlock, null, null);
                        } else {
                            Block wallBlock = TorchCompatManager.findWallTorchVariant(torchBlock);
                            Block ceilingBlock = TorchCompatManager.findCeilingTorchVariant(torchBlock, itemId);
                            TorchCompatManager.registerTorch(item, torchBlock, wallBlock, null);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++processedInBatch;
            }
            ++scanProgress;
        }
        if (scanProgress >= totalItems) {
            isAutoScanComplete = true;
            isScanning = false;
            MinecraftForge.EVENT_BUS.unregister(TorchCompatManager.class);
            System.out.println("[TorchCompat] \u9488\u5bf9\u6027\u626b\u63cf\u5b8c\u6210\uff0c\u5171\u6ce8\u518c " + KNOWN_TORCH_ITEMS.size() + " \u4e2a\u706b\u628a\u76f8\u5173\u7269\u54c1");
        }
    }

    private static boolean quickTargetedPreCheck(ResourceLocation itemId) {
        String path = itemId.m_135815_();
        for (String exclude : EXCLUDE_KEYWORDS) {
            if (!path.contains(exclude)) continue;
            return false;
        }
        for (String keyword : TARGET_KEYWORDS) {
            if (!path.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTorchItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        Boolean cached = TORCH_CACHE.get(item);
        if (cached != null) {
            return cached;
        }
        TorchCompatManager.initialize();
        boolean result = false;
        result = KNOWN_TORCH_ITEMS.contains(item) ? true : TorchCompatManager.strictKeywordCheck(stack);
        TORCH_CACHE.put(item, result);
        return result;
    }

    private static boolean strictKeywordCheck(ItemStack stack) {
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        if (itemId == null) {
            return false;
        }
        String itemPath = itemId.m_135815_();
        for (String exclude : EXCLUDE_KEYWORDS) {
            if (!itemPath.contains(exclude)) continue;
            return false;
        }
        for (String keyword : TARGET_KEYWORDS) {
            if (!itemPath.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    public static Block getCeilingTorchBlock(ItemStack torchItem) {
        Block torchBlock;
        if (torchItem == null || torchItem.m_41619_()) {
            return null;
        }
        TorchCompatManager.initialize();
        Item item = torchItem.m_41720_();
        if (item == null) {
            return null;
        }
        if (TorchCompatManager.isLantern(item)) {
            return null;
        }
        Block cached = CEILING_TORCH_CACHE.get(item);
        if (cached != null) {
            return cached;
        }
        Block result = TORCH_ITEM_TO_CEILING_BLOCK.get(item);
        if (result == null && (torchBlock = TorchCompatManager.getTorchBlock(torchItem)) != null) {
            ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)torchItem.m_41720_());
            result = TorchCompatManager.findCeilingTorchVariant(torchBlock, itemId);
        }
        if (result != null) {
            CEILING_TORCH_CACHE.put(item, result);
        }
        return result;
    }

    public static Block getTorchBlock(ItemStack torchItem) {
        if (torchItem == null || torchItem.m_41619_()) {
            return null;
        }
        TorchCompatManager.initialize();
        Item item = torchItem.m_41720_();
        if (item == null) {
            return null;
        }
        Block cached = TORCH_BLOCK_CACHE.get(item);
        if (cached != null) {
            return cached;
        }
        Block result = TORCH_ITEM_TO_BLOCK.get(item);
        if (result == null) {
            result = TorchCompatManager.extractTorchBlock(torchItem);
        }
        if (result != null) {
            TORCH_BLOCK_CACHE.put(item, result);
        }
        return result;
    }

    public static Block getWallTorchBlock(ItemStack torchItem) {
        Block torchBlock;
        if (torchItem == null || torchItem.m_41619_()) {
            return null;
        }
        TorchCompatManager.initialize();
        Item item = torchItem.m_41720_();
        if (item == null) {
            return null;
        }
        if (TorchCompatManager.isLantern(item)) {
            return null;
        }
        Block cached = WALL_TORCH_CACHE.get(item);
        if (cached != null) {
            return cached;
        }
        Block result = TORCH_ITEM_TO_WALL_BLOCK.get(item);
        if (result == null && (torchBlock = TorchCompatManager.getTorchBlock(torchItem)) != null) {
            result = TorchCompatManager.findWallTorchVariant(torchBlock);
        }
        if (result != null) {
            WALL_TORCH_CACHE.put(item, result);
        }
        return result;
    }

    private static Block extractTorchBlock(ItemStack stack) {
        try {
            Block block;
            ResourceLocation blockId;
            Item item = stack.m_41720_();
            if (item instanceof BlockItem) {
                return ((BlockItem)item).m_40614_();
            }
            ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)item);
            if (itemId != null && (blockId = new ResourceLocation(itemId.m_135827_(), itemId.m_135815_())) != null && (block = (Block)BuiltInRegistries.f_256975_.m_7745_(blockId)) != null && block != Blocks.f_50016_) {
                return block;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Block findWallTorchVariant(Block torchBlock) {
        ResourceLocation torchId = BuiltInRegistries.f_256975_.m_7981_((Object)torchBlock);
        if (torchId == null) {
            return null;
        }
        for (String pattern : WALL_PATTERNS) {
            Block wallBlock;
            String formatted = String.format(pattern, torchId.m_135815_());
            ResourceLocation wallId = new ResourceLocation(torchId.m_135827_(), formatted);
            if (wallId == null || (wallBlock = (Block)BuiltInRegistries.f_256975_.m_7745_(wallId)) == null || wallBlock == Blocks.f_50016_) continue;
            return wallBlock;
        }
        return null;
    }

    private static Block findCeilingTorchVariant(Block torchBlock, ResourceLocation torchItemId) {
        ResourceLocation torchId = BuiltInRegistries.f_256975_.m_7981_((Object)torchBlock);
        if (torchId == null) {
            return null;
        }
        for (String pattern : CEILING_PATTERNS) {
            Block ceilingBlock;
            String formatted = String.format(pattern, torchId.m_135815_());
            ResourceLocation ceilingId = new ResourceLocation(torchId.m_135827_(), formatted);
            if (ceilingId == null || (ceilingBlock = (Block)BuiltInRegistries.f_256975_.m_7745_(ceilingId)) == null || ceilingBlock == Blocks.f_50016_) continue;
            return ceilingBlock;
        }
        return null;
    }

    public static void registerTorch(Item torchItem, Block torchBlock, Block wallTorchBlock, String ceilingTorchId) {
        Block ceilingBlock;
        ResourceLocation ceilingId;
        KNOWN_TORCH_ITEMS.add(torchItem);
        TORCH_ITEM_TO_BLOCK.put(torchItem, torchBlock);
        if (wallTorchBlock != null) {
            TORCH_ITEM_TO_WALL_BLOCK.put(torchItem, wallTorchBlock);
        }
        if (ceilingTorchId != null && (ceilingId = new ResourceLocation(ceilingTorchId)) != null && (ceilingBlock = (Block)BuiltInRegistries.f_256975_.m_7745_(ceilingId)) != null && ceilingBlock != Blocks.f_50016_) {
            TORCH_ITEM_TO_CEILING_BLOCK.put(torchItem, ceilingBlock);
        }
        TORCH_CACHE.put(torchItem, true);
        TORCH_BLOCK_CACHE.put(torchItem, torchBlock);
        if (wallTorchBlock != null) {
            WALL_TORCH_CACHE.put(torchItem, wallTorchBlock);
        }
    }

    public static void registerCeilingTorch(Item torchItem, Block ceilingBlock) {
        if (torchItem != null && ceilingBlock != null) {
            TORCH_ITEM_TO_CEILING_BLOCK.put(torchItem, ceilingBlock);
            CEILING_TORCH_CACHE.put(torchItem, ceilingBlock);
        }
    }

    public static Set<Item> getKnownTorchItems() {
        TorchCompatManager.initialize();
        return Collections.unmodifiableSet(KNOWN_TORCH_ITEMS);
    }

    public static void rescanTorches() {
        TORCH_CACHE.clear();
        TORCH_BLOCK_CACHE.clear();
        WALL_TORCH_CACHE.clear();
        CEILING_TORCH_CACHE.clear();
        isAutoScanComplete = false;
        TorchCompatManager.startStagedAutoScan();
    }

    public static String getStats() {
        TorchCompatManager.initialize();
        return String.format("\u5df2\u77e5\u706b\u628a: %d, \u5899\u4e0a\u53d8\u79cd: %d, \u5012\u7f6e\u53d8\u79cd: %d, \u7f13\u5b58\u547d\u4e2d\u7387: \u9ad8", KNOWN_TORCH_ITEMS.size(), TORCH_ITEM_TO_WALL_BLOCK.size(), TORCH_ITEM_TO_CEILING_BLOCK.size());
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static String getScanStatus() {
        if (!isInitialized) {
            return "\u672a\u521d\u59cb\u5316";
        }
        if (isScanning) {
            return "\u626b\u63cf\u4e2d (" + scanProgress + "/" + BuiltInRegistries.f_257033_.m_6566_().size() + ")";
        }
        if (isAutoScanComplete) {
            return "\u626b\u63cf\u5b8c\u6210";
        }
        return "\u7b49\u5f85\u626b\u63cf";
    }
}

