/*
 * Decompiled with CFR 0.152.
 */
package com.ddd.torchthrowmod.entity;

import com.ddd.torchthrowmod.ModEntities;
import com.ddd.torchthrowmod.compat.TorchCompatManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownTorchEntity
extends ThrowableItemProjectile {
    private ItemStack torchItem;

    public ThrownTorchEntity(EntityType<? extends ThrownTorchEntity> entityType, Level level) {
        super(entityType, level);
        this.torchItem = new ItemStack((ItemLike)Items.f_42000_);
    }

    public ThrownTorchEntity(Level level, LivingEntity shooter, ItemStack torchItem) {
        super((EntityType)ModEntities.THROWN_TORCH.get(), shooter, level);
        this.torchItem = torchItem != null && !torchItem.m_41619_() ? torchItem.m_255036_(1) : new ItemStack((ItemLike)Items.f_42000_);
    }

    protected Item m_7881_() {
        return this.getTorchItem().m_41720_();
    }

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)Items.f_42000_);
    }

    public ItemStack getTorchItem() {
        if (this.torchItem == null || this.torchItem.m_41619_()) {
            this.torchItem = new ItemStack((ItemLike)Items.f_42000_);
        }
        return this.torchItem;
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_) {
            if (result.m_6662_() == HitResult.Type.BLOCK) {
                BlockHitResult blockResult = (BlockHitResult)result;
                this.placeTorch(blockResult);
            } else if (result.m_6662_() == HitResult.Type.ENTITY) {
                EntityHitResult entityResult = (EntityHitResult)result;
                this.igniteEntity(entityResult.m_82443_());
            }
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult result) {
        Entity target;
        super.m_5790_(result);
        if (!this.m_9236_().f_46443_ && (target = result.m_82443_()) instanceof LivingEntity) {
            Vec3 knockbackDirection = target.m_20182_().m_82546_(this.m_20182_()).m_82541_();
            double knockbackStrength = 0.5;
            target.m_20256_(target.m_20184_().m_82520_(knockbackDirection.f_82479_ * knockbackStrength, 0.3, knockbackDirection.f_82481_ * knockbackStrength));
            target.f_19864_ = true;
        }
    }

    private void placeTorch(BlockHitResult result) {
        BlockPos placePos;
        Direction direction;
        BlockPos hitPos;
        Level level = this.m_9236_();
        if (this.tryPlaceTorchWithCompat(level, hitPos = result.m_82425_(), direction = result.m_82434_(), placePos = hitPos.m_121945_(direction))) {
            return;
        }
        if (this.searchAndPlaceNearby(level, hitPos, direction)) {
            return;
        }
        this.spawnTorchItem(level, placePos);
    }

    private boolean searchAndPlaceNearby(Level level, BlockPos hitPos, Direction hitDirection) {
        Direction oppositeDirection = hitDirection.m_122424_();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos searchPos;
                    if (x == 0 && y == 0 && z == 0 || this.isPositionInOppositeDirection(hitPos, searchPos = hitPos.m_7918_(x, y, z), hitDirection, oppositeDirection) || !level.m_46859_(searchPos)) continue;
                    for (Direction dir : Direction.values()) {
                        BlockPos adjacentPos = searchPos.m_121945_(dir.m_122424_());
                        if (!this.tryPlaceTorchWithCompat(level, adjacentPos, dir, searchPos)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean isPositionInOppositeDirection(BlockPos hitPos, BlockPos searchPos, Direction hitDirection, Direction oppositeDirection) {
        int dx = searchPos.m_123341_() - hitPos.m_123341_();
        int dy = searchPos.m_123342_() - hitPos.m_123342_();
        int dz = searchPos.m_123343_() - hitPos.m_123343_();
        switch (oppositeDirection) {
            case DOWN: {
                return dy < 0;
            }
            case UP: {
                return dy > 0;
            }
            case NORTH: {
                return dz < 0;
            }
            case SOUTH: {
                return dz > 0;
            }
            case WEST: {
                return dx < 0;
            }
            case EAST: {
                return dx > 0;
            }
        }
        return false;
    }

    private boolean tryPlaceTorchWithCompat(Level level, BlockPos hitPos, Direction direction, BlockPos placePos) {
        BlockState ceilingState;
        Block ceilingTorchBlock;
        BlockState state = level.m_8055_(placePos);
        if (!state.m_60713_(Blocks.f_50125_) && !state.m_60795_()) {
            return false;
        }
        ItemStack torchStack = this.getTorchItem();
        Block torchBlock = TorchCompatManager.getTorchBlock(torchStack);
        if (torchBlock == null) {
            return false;
        }
        if (this.isLantern(torchBlock) && direction == Direction.DOWN) {
            BlockState lanternState = torchBlock.m_49966_();
            if (lanternState.m_61138_((Property)LanternBlock.f_153459_)) {
                lanternState = (BlockState)lanternState.m_61124_((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(true));
            }
            if (lanternState.m_60710_((LevelReader)level, placePos)) {
                level.m_7731_(placePos, lanternState, 3);
                level.m_5594_(null, placePos, SoundEvents.f_12028_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        }
        if (direction == Direction.DOWN && (ceilingTorchBlock = TorchCompatManager.getCeilingTorchBlock(torchStack)) != null && (ceilingState = ceilingTorchBlock.m_49966_()).m_60710_((LevelReader)level, placePos)) {
            level.m_7731_(placePos, ceilingState, 3);
            level.m_5594_(null, placePos, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        BlockState torchState = this.getTorchStateForDirection(direction, torchBlock);
        if (torchState != null && torchState.m_60710_((LevelReader)level, placePos)) {
            level.m_7731_(placePos, torchState, 3);
            level.m_5594_(null, placePos, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private boolean isLantern(Block block) {
        if (block == null) {
            return false;
        }
        ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        return blockId != null && blockId.m_135815_().contains("lantern");
    }

    private BlockState getTorchStateForDirection(Direction direction, Block torchBlock) {
        Block wallTorchBlock;
        if (torchBlock == null) {
            return null;
        }
        if (direction == Direction.UP) {
            return torchBlock.m_49966_();
        }
        if (direction != Direction.DOWN && (wallTorchBlock = TorchCompatManager.getWallTorchBlock(this.getTorchItem())) != null) {
            BlockState wallState = wallTorchBlock.m_49966_();
            if (wallState.m_61138_((Property)WallTorchBlock.f_58119_)) {
                return (BlockState)wallState.m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)direction);
            }
            return wallState;
        }
        return null;
    }

    private void spawnTorchItem(Level level, BlockPos pos) {
        if (!level.f_46443_) {
            ItemStack torchStack = this.getTorchItem();
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 1.0;
            double z = (double)pos.m_123343_() + 0.5;
            ItemStack singleTorch = torchStack.m_41777_();
            singleTorch.m_41764_(1);
            ItemEntity torchItemEntity = new ItemEntity(level, x, y, z, singleTorch);
            torchItemEntity.m_20334_((level.f_46441_.m_188500_() - 0.5) * 0.1, level.f_46441_.m_188500_() * 0.1, (level.f_46441_.m_188500_() - 0.5) * 0.1);
            torchItemEntity.m_32060_();
            level.m_7967_((Entity)torchItemEntity);
            level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.2f, (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 1.4f + 2.0f);
        }
    }

    private void igniteEntity(Entity entity) {
        if (entity instanceof LivingEntity) {
            Level level;
            entity.m_7311_(100);
            this.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11874_, SoundSource.NEUTRAL, 0.5f, 1.0f);
            if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 5; ++i) {
                    double x = entity.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)entity.m_20205_();
                    double y = entity.m_20186_() + this.f_19796_.m_188500_() * (double)entity.m_20206_();
                    double z = entity.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)entity.m_20205_();
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            SimpleParticleType particleType = ParticleTypes.f_123744_;
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)particleType, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 0.1, this.m_20186_() + 0.1, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 0.1, 0.0, 0.0, 0.0);
            }
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }
}

