/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.client.gui;

import com.leclowndu93150.chisel.Chisel;
import com.leclowndu93150.chisel.api.carving.IChiselMode;
import com.leclowndu93150.chisel.carving.ChiselModeRegistry;
import com.leclowndu93150.chisel.client.gui.ButtonChiselMode;
import com.leclowndu93150.chisel.inventory.ChiselMenu;
import com.leclowndu93150.chisel.inventory.SlotChiselInput;
import com.leclowndu93150.chisel.item.ItemChisel;
import com.leclowndu93150.chisel.network.server.ChiselModePayload;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class ChiselScreen
extends AbstractContainerScreen<ChiselMenu> {
    private static final ResourceLocation TEXTURE = Chisel.id("textures/gui/chisel2gui.png");
    public static final int GUI_WIDTH = 252;
    public static final int GUI_HEIGHT = 202;

    public ChiselScreen(ChiselMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.imageWidth = 252;
        this.imageHeight = 202;
    }

    protected void init() {
        ItemChisel itemChisel;
        super.init();
        ItemStack chisel = ((ChiselMenu)this.menu).getChisel();
        Item item = chisel.getItem();
        if (item instanceof ItemChisel && (itemChisel = (ItemChisel)item).getChiselType().hasModes()) {
            this.addModeButtons();
        }
    }

    private void addModeButtons() {
        Rect2i area = this.getModeButtonArea();
        int buttonsPerRow = area.getWidth() / 20;
        int padding = (area.getWidth() - buttonsPerRow * 20) / Math.max(1, buttonsPerRow);
        int id = 0;
        ItemStack chisel = ((ChiselMenu)this.menu).getChisel();
        IChiselMode currentMode = null;
        Item item = chisel.getItem();
        if (item instanceof ItemChisel) {
            ItemChisel itemChisel = (ItemChisel)item;
            currentMode = itemChisel.getMode(chisel);
        }
        for (IChiselMode mode : ChiselModeRegistry.INSTANCE.getAllModes()) {
            ItemChisel itemChisel;
            Item item2 = chisel.getItem();
            if (item2 instanceof ItemChisel && !(itemChisel = (ItemChisel)item2).supportsMode((Player)this.minecraft.player, chisel, mode)) continue;
            int x = area.getX() + padding / 2 + id % buttonsPerRow * (20 + padding);
            int y = area.getY() + id / buttonsPerRow * (20 + padding);
            IChiselMode finalMode = mode;
            ButtonChiselMode button = new ButtonChiselMode(x, y, 20, 20, mode, b -> {
                this.onModeButtonClick(finalMode);
                b.active = false;
                for (Renderable other : this.renderables) {
                    if (other == b || !(other instanceof ButtonChiselMode)) continue;
                    ButtonChiselMode b2 = (ButtonChiselMode)other;
                    b2.active = true;
                }
            });
            if (mode == currentMode) {
                button.active = false;
            }
            this.addRenderableWidget((GuiEventListener)button);
            ++id;
        }
    }

    protected Rect2i getModeButtonArea() {
        int down = 73;
        int padding = 7;
        return new Rect2i(this.leftPos + padding, this.topPos + down + padding, 50, this.imageHeight - down - padding * 2);
    }

    private void onModeButtonClick(IChiselMode mode) {
        ItemStack chisel = ((ChiselMenu)this.menu).getChisel();
        Item item = chisel.getItem();
        if (item instanceof ItemChisel) {
            ItemChisel itemChisel = (ItemChisel)item;
            itemChisel.setMode(chisel, mode);
            int slot = ((ChiselMenu)this.menu).getHand() == InteractionHand.MAIN_HAND ? this.minecraft.player.getInventory().selected : 40;
            PacketDistributor.sendToServer((CustomPacketPayload)new ChiselModePayload(slot, mode), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        SlotChiselInput inputSlot = ((ChiselMenu)this.menu).getInputSlot();
        if (inputSlot.getItem().isEmpty()) {
            graphics.blit(TEXTURE, this.leftPos + inputSlot.x - 16, this.topPos + inputSlot.y - 16, 0, this.imageHeight, 48, 48);
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        List lines = this.font.split((FormattedText)this.title, 40);
        int y = 60;
        for (FormattedCharSequence s : lines) {
            graphics.drawString(this.font, s, 32 - this.font.width(s) / 2, y, 0x404040, false);
            y += 10;
        }
        this.drawButtonTooltips(graphics, mouseX, mouseY);
    }

    protected void drawButtonTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
        for (Renderable widget : this.renderables) {
            ButtonChiselMode button;
            if (!(widget instanceof ButtonChiselMode) || !(button = (ButtonChiselMode)widget).isHovered()) continue;
            IChiselMode mode = button.getMode();
            List<MutableComponent> ttLines = List.of(mode.getLocalizedName(), mode.getLocalizedDescription().copy().withStyle(ChatFormatting.GRAY));
            graphics.renderComponentTooltip(this.font, ttLines, mouseX - this.leftPos, mouseY - this.topPos);
        }
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        SlotChiselInput inputSlot = ((ChiselMenu)this.menu).getInputSlot();
        if (x == inputSlot.x && y == inputSlot.y && width == 16 && height == 16) {
            return super.isHovering(x - 8, y - 8, 32, 32, mouseX, mouseY);
        }
        return super.isHovering(x, y, width, height, mouseX, mouseY);
    }

    protected void renderSlot(GuiGraphics graphics, Slot slot) {
        if (slot == ((ChiselMenu)this.menu).getInputSlot()) {
            PoseStack poseStack = graphics.pose();
            poseStack.pushPose();
            float centerX = slot.x + 8;
            float centerY = slot.y + 8;
            poseStack.translate(centerX, centerY, 0.0f);
            poseStack.scale(2.0f, 2.0f, 1.0f);
            poseStack.translate(-centerX, -centerY, 0.0f);
            super.renderSlot(graphics, slot);
            poseStack.popPose();
        } else {
            super.renderSlot(graphics, slot);
        }
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderTooltip(graphics, mouseX, mouseY);
    }
}

