/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.data.provider;

import com.leclowndu93150.chisel.Chisel;
import com.leclowndu93150.chisel.block.BlockCarvable;
import com.leclowndu93150.chisel.init.ChiselBlocks;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ChiselWorldGenProvider
extends DatapackBuiltinEntriesProvider {
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_MARBLE = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Chisel.id("ore_marble"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_LIMESTONE = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Chisel.id("ore_limestone"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_DIABASE = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Chisel.id("ore_diabase"));
    public static final ResourceKey<PlacedFeature> ORE_MARBLE_UPPER = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Chisel.id("ore_marble_upper"));
    public static final ResourceKey<PlacedFeature> ORE_MARBLE_LOWER = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Chisel.id("ore_marble_lower"));
    public static final ResourceKey<PlacedFeature> ORE_LIMESTONE_UPPER = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Chisel.id("ore_limestone_upper"));
    public static final ResourceKey<PlacedFeature> ORE_LIMESTONE_LOWER = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Chisel.id("ore_limestone_lower"));
    public static final ResourceKey<PlacedFeature> ORE_DIABASE_PLACED = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Chisel.id("ore_diabase"));
    public static final ResourceKey<BiomeModifier> ADD_MARBLE = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Chisel.id("add_marble"));
    public static final ResourceKey<BiomeModifier> ADD_LIMESTONE = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Chisel.id("add_limestone"));
    public static final ResourceKey<BiomeModifier> ADD_DIABASE = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Chisel.id("add_diabase"));
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.CONFIGURED_FEATURE, context -> {
        TagMatchTest stoneOreReplaceables = new TagMatchTest(BlockTags.BASE_STONE_OVERWORLD);
        if (ChiselBlocks.MARBLE.getBlock("raw") != null) {
            context.register(ORE_MARBLE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((RuleTest)stoneOreReplaceables, ((BlockCarvable)ChiselBlocks.MARBLE.getBlock("raw").get()).defaultBlockState(), 64)));
        }
        if (ChiselBlocks.LIMESTONE.getBlock("raw") != null) {
            context.register(ORE_LIMESTONE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((RuleTest)stoneOreReplaceables, ((BlockCarvable)ChiselBlocks.LIMESTONE.getBlock("raw").get()).defaultBlockState(), 64)));
        }
        if (ChiselBlocks.DIABASE.getBlock("raw") != null) {
            context.register(ORE_DIABASE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((RuleTest)stoneOreReplaceables, ((BlockCarvable)ChiselBlocks.DIABASE.getBlock("raw").get()).defaultBlockState(), 32)));
        }
    }).add(Registries.PLACED_FEATURE, context -> {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        if (ChiselBlocks.MARBLE.getBlock("raw") != null) {
            context.register(ORE_MARBLE_UPPER, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(ORE_MARBLE), ChiselWorldGenProvider.commonOrePlacement(6, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)64), (VerticalAnchor)VerticalAnchor.absolute((int)128)))));
            context.register(ORE_MARBLE_LOWER, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(ORE_MARBLE), ChiselWorldGenProvider.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)60)))));
        }
        if (ChiselBlocks.LIMESTONE.getBlock("raw") != null) {
            context.register(ORE_LIMESTONE_UPPER, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(ORE_LIMESTONE), ChiselWorldGenProvider.commonOrePlacement(6, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)64), (VerticalAnchor)VerticalAnchor.absolute((int)128)))));
            context.register(ORE_LIMESTONE_LOWER, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(ORE_LIMESTONE), ChiselWorldGenProvider.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)60)))));
        }
        if (ChiselBlocks.DIABASE.getBlock("raw") != null) {
            context.register(ORE_DIABASE_PLACED, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(ORE_DIABASE), ChiselWorldGenProvider.commonOrePlacement(8, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)0)))));
        }
    }).add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, context -> {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        HolderSet.Named overworldTag = biomes.getOrThrow(BiomeTags.IS_OVERWORLD);
        if (ChiselBlocks.MARBLE.getBlock("raw") != null) {
            context.register(ADD_MARBLE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldTag, (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ORE_MARBLE_UPPER), placedFeatures.getOrThrow(ORE_MARBLE_LOWER)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        }
        if (ChiselBlocks.LIMESTONE.getBlock("raw") != null) {
            context.register(ADD_LIMESTONE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldTag, (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ORE_LIMESTONE_UPPER), placedFeatures.getOrThrow(ORE_LIMESTONE_LOWER)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        }
        if (ChiselBlocks.DIABASE.getBlock("raw") != null) {
            context.register(ADD_DIABASE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldTag, (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ORE_DIABASE_PLACED)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        }
    });

    public ChiselWorldGenProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, BUILDER, Set.of("chisel"));
    }

    private static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier heightRange) {
        return List.of(CountPlacement.of((int)count), InSquarePlacement.spread(), heightRange, BiomeFilter.biome());
    }

    private static List<PlacementModifier> rareOrePlacement(int chance, PlacementModifier heightRange) {
        return List.of(RarityFilter.onAverageOnceEvery((int)chance), InSquarePlacement.spread(), heightRange, BiomeFilter.biome());
    }

    public String getName() {
        return "Chisel World Generation";
    }
}

