/*
 * Decompiled with CFR 0.152.
 */
package com.florlet.quickalias.gui;

import com.florlet.quickalias.config.AliasNode;
import com.florlet.quickalias.config.ConfigManager;
import com.florlet.quickalias.gui.AliasEditorScreen;
import com.florlet.quickalias.gui.FlatButton;
import com.florlet.quickalias.gui.SettingsScreen;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class AliasScrollList
extends ObjectSelectionList<AliasEntry> {
    private final SettingsScreen parentScreen;
    private final boolean isImportMode;
    private Set<String> conflictNames = Collections.emptySet();
    private String currentFilter = "";
    private static final Pattern CONSTANT_PATTERN = Pattern.compile("(?i)\\{(X|Y|Z|ID|DIM)}");

    public AliasScrollList(Minecraft minecraft, SettingsScreen parentScreen, int width, int height, int top, int bottom, int itemHeight) {
        this(minecraft, parentScreen, width, height, top, bottom, itemHeight, false);
    }

    public AliasScrollList(Minecraft minecraft, SettingsScreen parentScreen, int width, int height, int top, int bottom, int itemHeight, boolean isImportMode) {
        super(minecraft, width, bottom - top, top, itemHeight);
        this.parentScreen = parentScreen;
        this.isImportMode = isImportMode;
        if (!isImportMode) {
            this.refreshList();
        }
    }

    public void setFilter(String query) {
        this.currentFilter = query == null ? "" : query.trim().toLowerCase(Locale.ROOT);
        this.refreshList();
    }

    public void refreshList() {
        this.m_93516_();
        List<AliasNode> aliases = ConfigManager.getInstance().getConfig().aliases;
        for (AliasNode node : aliases) {
            if (!this.currentFilter.isEmpty() && !this.matchesRecursive(node, this.currentFilter)) continue;
            this.m_7085_((AbstractSelectionList.Entry)new AliasEntry(node));
        }
    }

    private boolean matchesRecursive(AliasNode node, String query) {
        if (node.getName().toLowerCase(Locale.ROOT).contains(query)) {
            return true;
        }
        for (String cmd : node.getCommands()) {
            if (!cmd.toLowerCase(Locale.ROOT).contains(query)) continue;
            return true;
        }
        for (AliasNode child : node.getChildren()) {
            if (!this.matchesRecursive(child, query)) continue;
            return true;
        }
        return false;
    }

    public void setImportNodes(List<AliasNode> nodes, Set<String> conflicts) {
        this.m_93516_();
        Set<Object> set = this.conflictNames = conflicts == null ? Collections.emptySet() : conflicts;
        if (nodes != null) {
            for (AliasNode node : nodes) {
                this.m_7085_((AbstractSelectionList.Entry)new AliasEntry(node));
            }
        }
    }

    public int m_5759_() {
        return this.f_93618_ - 20;
    }

    protected int m_5756_() {
        return this.f_93618_ - 10;
    }

    private Component formatCommand(String cmd) {
        MutableComponent root = Component.m_237119_();
        Matcher m = CONSTANT_PATTERN.matcher(cmd);
        int lastEnd = 0;
        while (m.find()) {
            if (m.start() > lastEnd) {
                root.m_7220_((Component)Component.m_237113_((String)cmd.substring(lastEnd, m.start())).m_130948_(Style.f_131099_.m_178520_(0xAAAAAA)));
            }
            root.m_7220_((Component)Component.m_237113_((String)m.group()).m_130948_(Style.f_131099_.m_178520_(0xAA55FF)));
            lastEnd = m.end();
        }
        if (lastEnd < cmd.length()) {
            root.m_7220_((Component)Component.m_237113_((String)cmd.substring(lastEnd)).m_130948_(Style.f_131099_.m_178520_(0xAAAAAA)));
        }
        return root;
    }

    public class AliasEntry
    extends ObjectSelectionList.Entry<AliasEntry> {
        private final AliasNode node;
        private final FlatButton upBtn;
        private final FlatButton downBtn;
        private final FlatButton editBtn;
        private final FlatButton deleteBtn;

        public AliasEntry(AliasNode node) {
            this.node = node;
            if (!AliasScrollList.this.isImportMode) {
                boolean canSort = AliasScrollList.this.currentFilter.isEmpty();
                this.upBtn = new FlatButton(0, 0, 12, 8, (Component)Component.m_237119_(), btn -> this.move(-1));
                this.upBtn.f_93623_ = canSort;
                this.downBtn = new FlatButton(0, 0, 12, 8, (Component)Component.m_237119_(), btn -> this.move(1));
                this.downBtn.f_93623_ = canSort;
                this.editBtn = new FlatButton(0, 0, 30, 16, (Component)Component.m_237115_((String)"quickalias.gui.edit"), btn -> Minecraft.m_91087_().m_91152_((Screen)new AliasEditorScreen(AliasScrollList.this.parentScreen, node, false)));
                this.deleteBtn = new FlatButton(0, 0, 16, 16, (Component)Component.m_237113_((String)"\u00d7").m_130938_(s -> s.m_178520_(0xFF5555)), btn -> {
                    ConfigManager.getInstance().getConfig().aliases.remove(node);
                    ConfigManager.getInstance().save();
                    AliasScrollList.this.refreshList();
                });
            } else {
                this.upBtn = null;
                this.downBtn = null;
                this.editBtn = null;
                this.deleteBtn = null;
            }
        }

        private void move(int dir) {
            if (!AliasScrollList.this.currentFilter.isEmpty()) {
                return;
            }
            List<AliasNode> list = ConfigManager.getInstance().getConfig().aliases;
            int index = list.indexOf(this.node);
            if (index >= 0 && index + dir >= 0 && index + dir < list.size()) {
                Collections.swap(list, index, index + dir);
                ConfigManager.getInstance().save();
                AliasScrollList.this.refreshList();
            }
        }

        public void m_6311_(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isSelected, float partialTick) {
            boolean hasChildren;
            int bgTop = top + 2;
            int bgBottom = top + height - 2;
            guiGraphics.m_280509_(left, bgTop, left + width, bgBottom, 0x15FFFFFF);
            int currentX = left + 4;
            int centerY = bgTop + (bgBottom - bgTop) / 2;
            if (!AliasScrollList.this.isImportMode) {
                int btnHeight = (bgBottom - bgTop) / 2;
                if (AliasScrollList.this.currentFilter.isEmpty()) {
                    this.upBtn.m_252865_(currentX);
                    this.upBtn.m_253211_(bgTop);
                    this.upBtn.m_293384_(btnHeight);
                    this.upBtn.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
                    float scale = 0.7f;
                    guiGraphics.m_280168_().m_85836_();
                    guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
                    guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, "\u25b2", (int)(((float)(currentX + 6) - (float)Minecraft.m_91087_().f_91062_.m_92895_("\u25b2") * scale / 2.0f) / scale), (int)((float)(bgTop + 1) / scale), 0xFFFFFF);
                    guiGraphics.m_280168_().m_85849_();
                    this.downBtn.m_252865_(currentX);
                    this.downBtn.m_253211_(bgTop + btnHeight);
                    this.downBtn.m_293384_(btnHeight);
                    this.downBtn.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
                    guiGraphics.m_280168_().m_85836_();
                    guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
                    guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, "\u25bc", (int)(((float)(currentX + 6) - (float)Minecraft.m_91087_().f_91062_.m_92895_("\u25bc") * scale / 2.0f) / scale), (int)((float)(bgTop + btnHeight * 2 - 7) / scale), 0xFFFFFF);
                    guiGraphics.m_280168_().m_85849_();
                }
                currentX += 16;
            }
            String nameText = "/" + this.node.getName();
            int nameColor = 0xFFFFFF;
            if (AliasScrollList.this.isImportMode && AliasScrollList.this.conflictNames.contains(this.node.getName().toLowerCase())) {
                nameColor = 0xFF5555;
            } else if (this.node.isVariable()) {
                nameColor = 0xFFAA00;
            } else if (this.node.isEndNode()) {
                nameColor = 0xAA55FF;
            }
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, nameText, currentX, centerY - 4, nameColor);
            int nameWidth = Minecraft.m_91087_().f_91062_.m_92895_(nameText);
            int arrowX = currentX + nameWidth + 5;
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, "->", arrowX, centerY - 4, 0x888888);
            int arrowWidth = Minecraft.m_91087_().f_91062_.m_92895_("->");
            int contentX = arrowX + arrowWidth + 5;
            boolean hasCommands = !this.node.getCommands().isEmpty();
            boolean bl = hasChildren = !this.node.getChildren().isEmpty();
            if (hasChildren) {
                Object displayStr;
                if (hasCommands) {
                    displayStr = String.join((CharSequence)", ", this.node.getCommands());
                } else {
                    List<String> childNames = this.node.getChildren().stream().map(AliasNode::getName).toList();
                    displayStr = "[" + String.join((CharSequence)", ", childNames) + "]";
                }
                int buttonsWidth = AliasScrollList.this.isImportMode ? 0 : 55;
                int availableWidth = left + width - contentX - buttonsWidth - 5;
                Object renderedStr = Minecraft.m_91087_().f_91062_.m_92834_((String)displayStr, availableWidth);
                if (((String)renderedStr).length() < ((String)displayStr).length()) {
                    renderedStr = (String)renderedStr + "...";
                }
                guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, (String)renderedStr, contentX, centerY - 4, 0x55AAFF);
            } else {
                String rawCmds = String.join((CharSequence)", ", this.node.getCommands());
                int buttonsWidth = AliasScrollList.this.isImportMode ? 0 : 55;
                int availableWidth = left + width - contentX - buttonsWidth - 5;
                Component formattedCmd = AliasScrollList.this.formatCommand(rawCmds);
                Object truncatedRaw = Minecraft.m_91087_().f_91062_.m_92834_(rawCmds, availableWidth);
                if (((String)truncatedRaw).length() < rawCmds.length()) {
                    truncatedRaw = (String)truncatedRaw + "...";
                }
                Component renderComp = AliasScrollList.this.formatCommand((String)truncatedRaw);
                guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, renderComp, contentX, centerY - 4, 0xFFFFFF);
            }
            if (!AliasScrollList.this.isImportMode) {
                int btnY = centerY - 8;
                this.deleteBtn.m_252865_(left + width - 20);
                this.deleteBtn.m_253211_(btnY);
                this.deleteBtn.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
                this.editBtn.m_252865_(left + width - 55);
                this.editBtn.m_253211_(btnY);
                this.editBtn.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (AliasScrollList.this.isImportMode) {
                return false;
            }
            if (AliasScrollList.this.currentFilter.isEmpty()) {
                if (this.upBtn.m_6375_(mouseX, mouseY, button)) {
                    return true;
                }
                if (this.downBtn.m_6375_(mouseX, mouseY, button)) {
                    return true;
                }
            }
            if (this.editBtn.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            if (this.deleteBtn.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        @NotNull
        public Component m_142172_() {
            return Component.m_237113_((String)this.node.getName());
        }
    }
}

