/*
 * Decompiled with CFR 0.152.
 */
package com.florlet.quickalias.fabric.mixin;

import com.florlet.quickalias.QuickAliasLogger;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.sugar.Local;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1078;
import net.minecraft.class_3300;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1078.class})
public class FabricLanguageMixin {
    @Unique
    private static final Gson quickalias$GSON = new Gson();

    @Inject(method={"loadFrom"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableMap;copyOf(Ljava/util/Map;)Lcom/google/common/collect/ImmutableMap;", remap=false)})
    private static void quickalias$injectMissingTranslations(class_3300 resourceManager, List<String> definitions, boolean p_265725_, CallbackInfoReturnable<class_1078> cir, @Local Map<String, String> map) {
        if (FabricLoader.getInstance().isModLoaded("fabric-api")) {
            return;
        }
        for (String langCode : definitions) {
            String path = String.format("/assets/%s/lang/%s.json", "quickalias", langCode);
            try {
                InputStream stream = FabricLanguageMixin.class.getResourceAsStream(path);
                try {
                    if (stream == null) continue;
                    QuickAliasLogger.info("Manually injecting language file: " + path);
                    try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                        JsonObject json = (JsonObject)quickalias$GSON.fromJson((Reader)reader, JsonObject.class);
                        for (Map.Entry entry : json.entrySet()) {
                            String key = (String)entry.getKey();
                            String value = ((JsonElement)entry.getValue()).getAsString();
                            map.put(key, value);
                        }
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                QuickAliasLogger.error("Failed to inject language file: " + path + "\n" + String.valueOf(e));
            }
        }
    }
}

