/*
 * Decompiled with CFR 0.152.
 */
package com.florlet.quickalias.gui;

import com.florlet.quickalias.config.AliasNode;
import com.florlet.quickalias.config.ConfigManager;
import com.florlet.quickalias.gui.FlatButton;
import com.florlet.quickalias.gui.SettingsScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class AliasEditorScreen
extends class_437 {
    private final class_437 parent;
    private final AliasNode originalNode;
    private final AliasNode workingNode;
    private final boolean isNewNode;
    private final int depth;
    private class_342 aliasInput;
    private FlatButton saveButton;
    private FlatButton addSubChildBtn;
    private FlatButton addEndNodeBtn;
    private int cmdAreaTop;
    private int cmdAreaBottom;
    private int childAreaTop;
    private int childAreaBottom;
    private double commandScrollAmount = 0.0;
    private double childScrollAmount = 0.0;
    private final List<class_339> commandWidgets = new ArrayList<class_339>();
    private final List<class_339> childWidgets = new ArrayList<class_339>();
    private final List<BreadcrumbSeparator> breadcrumbSeparators = new ArrayList<BreadcrumbSeparator>();
    private class_2561 errorMessage = null;
    private boolean saved = false;
    private static final int ITEM_HEIGHT = 20;
    private static final int INPUT_HEIGHT = 14;
    private static final int BUTTON_SIZE = 14;
    private static final int MAX_DEPTH = 10;
    private static final int MAX_COMMANDS = 15;
    private static final Set<String> RESERVED_VARS = Set.of("X", "Y", "Z", "ID", "DIM");
    private static final Pattern VAR_REF_PATTERN = Pattern.compile("(?<!\\\\)\\{([^}]+)}");

    public AliasEditorScreen(class_437 parent, AliasNode node, boolean isNewNode) {
        super((class_2561)class_2561.method_43471((String)"quickalias.editor.title"));
        this.parent = parent;
        this.originalNode = node;
        this.isNewNode = isNewNode;
        this.depth = parent instanceof AliasEditorScreen ? ((AliasEditorScreen)parent).depth + 1 : 1;
        this.workingNode = new AliasNode(node);
        if (this.workingNode.getCommands().isEmpty()) {
            this.workingNode.addCommand("");
        }
    }

    protected void method_25426() {
        int cmdAreaStartY;
        this.method_37067();
        this.commandWidgets.clear();
        this.childWidgets.clear();
        boolean hasChildren = !this.workingNode.getChildren().isEmpty();
        boolean isMacroMode = this.workingNode.getCommands().size() > 1;
        boolean isEndNode = this.workingNode.isEndNode();
        int breadcrumbBottomY = this.initBreadcrumbs();
        int topMargin = 10;
        int nameInputY = breadcrumbBottomY + topMargin;
        int errorAreaY = nameInputY + 14 + 4;
        int errorHeight = 9;
        this.cmdAreaTop = cmdAreaStartY = errorAreaY + errorHeight + 4;
        int footerHeight = 35;
        int contentBottom = this.field_22790 - footerHeight;
        if (isMacroMode || isEndNode) {
            this.cmdAreaBottom = contentBottom;
            this.childAreaTop = contentBottom;
            this.childAreaBottom = contentBottom;
        } else if (hasChildren) {
            int singleCmdHeight = 30;
            this.cmdAreaBottom = this.cmdAreaTop + singleCmdHeight;
            this.childAreaTop = this.cmdAreaBottom + 10;
            this.childAreaBottom = contentBottom;
        } else {
            int cmdRows = Math.min(this.workingNode.getCommands().size() + 1, 5);
            int neededCmdHeight = cmdRows * 20 + 10;
            int availableHeight = contentBottom - this.cmdAreaTop;
            int actualCmdHeight = Math.min(neededCmdHeight, (int)((double)availableHeight * 0.6));
            actualCmdHeight = Math.max(actualCmdHeight, 50);
            this.cmdAreaBottom = this.cmdAreaTop + actualCmdHeight;
            this.childAreaTop = this.cmdAreaBottom + 10;
            this.childAreaBottom = contentBottom;
        }
        int centerX = this.field_22789 / 2;
        int inputWidth = 200;
        int inputX = centerX - 100;
        this.aliasInput = new class_342(this.field_22793, inputX, nameInputY, inputWidth, 16, (class_2561)class_2561.method_43471((String)"quickalias.editor.alias_name"));
        this.aliasInput.method_1880(32);
        this.aliasInput.method_1852(this.workingNode.getName());
        this.aliasInput.method_1890(s -> !s.contains(" "));
        this.updateNameInputColor();
        if (isEndNode) {
            this.aliasInput.method_1888(false);
        }
        this.aliasInput.method_1863(val -> {
            this.workingNode.setName((String)val);
            this.updateNameInputColor();
            this.validate();
        });
        this.method_37063((class_364)this.aliasInput);
        this.buildCommandsList(isMacroMode, hasChildren);
        if (!isMacroMode && !isEndNode) {
            this.buildChildrenList();
        }
        int bottomY = this.field_22790 - 24;
        this.method_37063((class_364)new FlatButton(this.field_22789 - 130, bottomY, 60, 16, (class_2561)class_2561.method_43471((String)"gui.cancel"), btn -> this.method_25419()));
        this.saveButton = new FlatButton(this.field_22789 - 65, bottomY, 60, 16, (class_2561)class_2561.method_43471((String)"gui.done"), btn -> this.saveAndClose());
        this.method_37063((class_364)this.saveButton);
        this.validate();
    }

    private void updateNameInputColor() {
        if (this.workingNode.isEndNode()) {
            this.aliasInput.method_1868(0xAA55FF);
        } else if (this.workingNode.isVariable()) {
            this.aliasInput.method_1868(0xFFAA00);
        } else {
            this.aliasInput.method_1868(0xFFFFFF);
        }
    }

    private int initBreadcrumbs() {
        this.breadcrumbSeparators.clear();
        int startX = 10;
        int startY = 8;
        int x = startX;
        int y = startY;
        int lineHeight = 18;
        int indent = 10;
        int maxWidth = this.field_22789 - 20;
        ArrayList<class_437> chain = new ArrayList<class_437>();
        class_437 p = this.parent;
        while (p instanceof AliasEditorScreen) {
            chain.add(p);
            p = ((AliasEditorScreen)p).parent;
        }
        chain.add(p);
        Collections.reverse(chain);
        for (class_437 s : chain) {
            class_5250 labelComp = s instanceof AliasEditorScreen ? class_2561.method_43470((String)(((AliasEditorScreen)s).originalNode.getName().isEmpty() ? "?" : ((AliasEditorScreen)s).originalNode.getName())) : class_2561.method_43471((String)"quickalias.editor.nav.home");
            int btnWidth = this.field_22793.method_27525((class_5348)labelComp) + 10;
            if (x + btnWidth > maxWidth) {
                x = startX + indent;
                y += lineHeight;
            }
            this.method_37063((class_364)new FlatButton(x, y, btnWidth, 14, (class_2561)labelComp, btn -> {
                this.method_25419();
                this.field_22787.method_1507(s);
            }));
            class_5250 sepText = class_2561.method_43470((String)">");
            int sepWidth = this.field_22793.method_27525((class_5348)sepText);
            if ((x += btnWidth + 2) + sepWidth > maxWidth) {
                x = startX + indent;
                y += lineHeight;
            }
            this.breadcrumbSeparators.add(new BreadcrumbSeparator(x, y + 3, (class_2561)sepText));
            x += sepWidth + 5;
        }
        String currentName = this.workingNode.getName().isEmpty() ? (this.isNewNode ? "[ ]" : "?") : this.workingNode.getName();
        class_5250 currentComp = class_2561.method_43470((String)currentName);
        int curWidth = this.field_22793.method_27525((class_5348)currentComp) + 10;
        if (x + curWidth > maxWidth) {
            x = startX + indent;
            y += lineHeight;
        }
        FlatButton curBtn = new FlatButton(x, y, curWidth, 14, (class_2561)currentComp, btn -> {});
        curBtn.field_22763 = false;
        this.method_37063((class_364)curBtn);
        return y + lineHeight;
    }

    private void rebuildInterface() {
        this.method_25426();
    }

    private void buildCommandsList(boolean isMacroMode, boolean hasChildren) {
        int currentCmdCount = this.workingNode.getCommands().size();
        boolean showAddButton = !hasChildren && currentCmdCount < 15;
        int contentHeight = currentCmdCount * 20 + (showAddButton ? 20 : 0);
        int viewHeight = this.cmdAreaBottom - this.cmdAreaTop;
        double maxScroll = Math.max(0, contentHeight - viewHeight);
        this.commandScrollAmount = class_3532.method_15350((double)this.commandScrollAmount, (double)0.0, (double)maxScroll);
        int startY = (int)((double)this.cmdAreaTop - this.commandScrollAmount);
        int centerX = this.field_22789 / 2;
        for (int i = 0; i < this.workingNode.getCommands().size(); ++i) {
            int itemY = startY + i * 20;
            boolean isVisible = itemY + 20 > this.cmdAreaTop && itemY < this.cmdAreaBottom;
            String cmd = this.workingNode.getCommands().get(i);
            class_342 cmdBox = new class_342(this.field_22793, centerX - 100, itemY + 2, 200, 14, (class_2561)class_2561.method_43470((String)"Cmd"));
            cmdBox.method_1880(256);
            cmdBox.method_1852(cmd);
            cmdBox.field_22764 = isVisible;
            cmdBox.method_1868(0xFFFFFF);
            int idx = i;
            cmdBox.method_1863(val -> {
                if (idx < this.workingNode.getCommands().size()) {
                    this.workingNode.getCommands().set(idx, (String)val);
                    this.validate();
                }
            });
            this.method_25429((class_364)cmdBox);
            this.commandWidgets.add((class_339)cmdBox);
            boolean isLastOne = this.workingNode.getCommands().size() == 1;
            FlatButton delBtn = new FlatButton(centerX + 105, itemY + 2, 14, 14, (class_2561)class_2561.method_43470((String)"\u00d7").method_27694(s -> s.method_36139(0xFF5555)), btn -> {
                if (isLastOne && hasChildren) {
                    this.workingNode.getCommands().set(0, "");
                    cmdBox.method_1852("");
                    this.validate();
                } else if (isLastOne) {
                    this.workingNode.getCommands().set(0, "");
                    cmdBox.method_1852("");
                    this.validate();
                } else {
                    this.workingNode.getCommands().remove(idx);
                    this.rebuildInterface();
                }
            });
            delBtn.field_22764 = isVisible;
            this.method_25429((class_364)delBtn);
            this.commandWidgets.add((class_339)delBtn);
        }
        if (showAddButton) {
            int addButtonY = startY + this.workingNode.getCommands().size() * 20;
            boolean isVisible = addButtonY + 20 > this.cmdAreaTop && addButtonY < this.cmdAreaBottom;
            FlatButton addBtn = new FlatButton(centerX - 100, addButtonY + 2, 200, 16, (class_2561)class_2561.method_43471((String)"quickalias.editor.add_cmd"), btn -> {
                this.workingNode.addCommand("");
                if (contentHeight + 20 > viewHeight) {
                    this.commandScrollAmount = contentHeight + 20 - viewHeight;
                }
                this.rebuildInterface();
            });
            addBtn.field_22764 = isVisible;
            this.method_25429((class_364)addBtn);
            this.commandWidgets.add((class_339)addBtn);
        }
    }

    private class_2561 formatCommandWithVariables(String cmd) {
        class_5250 root = class_2561.method_43473();
        Matcher m = VAR_REF_PATTERN.matcher(cmd);
        int lastEnd = 0;
        while (m.find()) {
            if (m.start() > lastEnd) {
                root.method_10852((class_2561)class_2561.method_43470((String)cmd.substring(lastEnd, m.start())).method_27696(class_2583.field_24360.method_36139(0xFFFFFF)));
            }
            root.method_10852((class_2561)class_2561.method_43470((String)m.group()).method_27696(class_2583.field_24360.method_36139(0xFFAA00)));
            lastEnd = m.end();
        }
        if (lastEnd < cmd.length()) {
            root.method_10852((class_2561)class_2561.method_43470((String)cmd.substring(lastEnd)).method_27696(class_2583.field_24360.method_36139(0xFFFFFF)));
        }
        return root;
    }

    private void buildChildrenList() {
        boolean isVisible;
        int contentHeight = this.workingNode.getChildren().size() * 20 + 20;
        int viewHeight = this.childAreaBottom - this.childAreaTop;
        double maxScroll = Math.max(0, contentHeight - viewHeight);
        this.childScrollAmount = class_3532.method_15350((double)this.childScrollAmount, (double)0.0, (double)maxScroll);
        int startY = (int)((double)this.childAreaTop - this.childScrollAmount);
        int centerX = this.field_22789 / 2;
        boolean hasVariableChild = this.workingNode.getChildren().stream().anyMatch(AliasNode::isVariable);
        boolean hasEndNode = this.workingNode.getChildren().stream().anyMatch(AliasNode::isEndNode);
        for (int i = 0; i < this.workingNode.getChildren().size(); ++i) {
            int itemY = startY + i * 20;
            boolean isVisible2 = itemY + 20 > this.childAreaTop && itemY < this.childAreaBottom;
            AliasNode child = this.workingNode.getChildren().get(i);
            String rawLabel = child.getName() + " -> " + (child.getCommands().isEmpty() ? "..." : child.getCommands().get(0));
            String childName = child.getName();
            String childCmd = child.getCommands().isEmpty() ? "..." : child.getCommands().get(0);
            int nameColor = 0xFFFFFF;
            if (child.isVariable()) {
                nameColor = 0xFFAA00;
            }
            if (child.isEndNode()) {
                nameColor = 0xAA55FF;
            }
            class_2561 cmdComponent = this.formatCommandWithVariables(childCmd);
            class_5250 buttonLabel = class_2561.method_43470((String)childName).method_27696(class_2583.field_24360.method_36139(nameColor)).method_10852((class_2561)class_2561.method_43470((String)" -> ").method_27696(class_2583.field_24360.method_36139(0x888888))).method_10852(cmdComponent);
            FlatButton childBtn = new FlatButton(centerX - 100, itemY + 2, 200, 14, (class_2561)buttonLabel, btn -> this.field_22787.method_1507((class_437)new AliasEditorScreen(this, child, false)));
            childBtn.field_22764 = isVisible2;
            this.method_25429((class_364)childBtn);
            this.childWidgets.add((class_339)childBtn);
            FlatButton delBtn = new FlatButton(centerX + 105, itemY + 2, 14, 14, (class_2561)class_2561.method_43470((String)"\u00d7").method_27694(s -> s.method_36139(0xFF5555)), btn -> {
                this.workingNode.getChildren().remove(child);
                this.rebuildInterface();
            });
            delBtn.field_22764 = isVisible2;
            this.method_25429((class_364)delBtn);
            this.childWidgets.add((class_339)delBtn);
        }
        int addButtonY = startY + this.workingNode.getChildren().size() * 20;
        boolean bl = isVisible = addButtonY + 20 > this.childAreaTop && addButtonY < this.childAreaBottom;
        if (hasVariableChild) {
            if (!hasEndNode) {
                class_5250 endLabel = class_2561.method_43470((String)"+ ").method_10852((class_2561)class_2561.method_43470((String)"END").method_27696(class_2583.field_24360.method_36139(0xAA55FF)));
                this.addEndNodeBtn = new FlatButton(centerX - 100, addButtonY + 2, 200, 16, (class_2561)endLabel, btn -> {
                    AliasNode newChild = new AliasNode("{END}");
                    this.workingNode.addChild(newChild);
                    this.field_22787.method_1507((class_437)new AliasEditorScreen(this, newChild, true));
                });
                this.addEndNodeBtn.field_22764 = isVisible;
                this.method_25429((class_364)this.addEndNodeBtn);
                this.childWidgets.add((class_339)this.addEndNodeBtn);
            }
        } else {
            this.addSubChildBtn = new FlatButton(centerX - 100, addButtonY + 2, 200, 16, (class_2561)class_2561.method_43471((String)"quickalias.editor.add_sub"), btn -> {
                AliasNode newChild = new AliasNode("");
                this.workingNode.addChild(newChild);
                this.field_22787.method_1507((class_437)new AliasEditorScreen(this, newChild, true));
            });
            this.addSubChildBtn.field_22764 = isVisible;
            this.method_25429((class_364)this.addSubChildBtn);
            this.childWidgets.add((class_339)this.addSubChildBtn);
        }
    }

    private void validate() {
        List<AliasNode> siblings;
        this.errorMessage = null;
        boolean valid = true;
        String name = this.aliasInput.method_1882().trim();
        if (name.isEmpty()) {
            valid = false;
        }
        for (String cmd : this.workingNode.getCommands()) {
            if (!cmd.contains("{END}")) continue;
            this.errorMessage = class_2561.method_43471((String)"quickalias.editor.error.reserved");
            valid = false;
            break;
        }
        if (valid && this.isRootNode()) {
            if (this.isVariable(name)) {
                this.errorMessage = class_2561.method_43471((String)"quickalias.editor.error.root_variable");
                valid = false;
            }
            if ("{END}".equals(name)) {
                this.errorMessage = class_2561.method_43471((String)"quickalias.editor.error.root_variable");
                valid = false;
            }
        }
        if (valid) {
            siblings = this.getSiblings();
            boolean isCurrentVar = this.isVariable(name);
            if (isCurrentVar) {
                for (AliasNode s : siblings) {
                    if (s == this.originalNode || s.isEndNode()) continue;
                    this.errorMessage = class_2561.method_43471((String)"quickalias.editor.error.variable_sibling");
                    valid = false;
                    break;
                }
            } else if (!this.workingNode.isEndNode()) {
                for (AliasNode s : siblings) {
                    if (s == this.originalNode || !s.isVariable()) continue;
                    this.errorMessage = class_2561.method_43471((String)"quickalias.editor.error.variable_sibling");
                    valid = false;
                    break;
                }
            }
        }
        if (valid) {
            siblings = this.getSiblings();
            for (AliasNode n : siblings) {
                if (n == this.originalNode || !n.getName().equalsIgnoreCase(name)) continue;
                this.errorMessage = class_2561.method_43471((String)"quickalias.editor.warning.duplicate");
                valid = false;
                break;
            }
        }
        if (valid && RESERVED_VARS.contains(name.toUpperCase())) {
            this.errorMessage = class_2561.method_43471((String)"quickalias.editor.error.reserved");
            valid = false;
        }
        if (valid && this.isVariable(name)) {
            String varName = name.substring(1, name.length() - 1);
            if (this.getParentVariableNames().contains(varName)) {
                this.errorMessage = class_2561.method_43471((String)"quickalias.editor.error.duplicate_var");
                valid = false;
            }
        }
        if (valid) {
            HashSet<String> validVars = new HashSet<String>();
            validVars.addAll(RESERVED_VARS);
            validVars.addAll(this.getParentVariableNames());
            if (this.isVariable(name)) {
                validVars.add(name.substring(1, name.length() - 1));
            }
            for (String cmd : this.workingNode.getCommands()) {
                Matcher m = VAR_REF_PATTERN.matcher(cmd);
                while (m.find()) {
                    String ref = m.group(1);
                    if (validVars.contains(ref)) continue;
                    this.errorMessage = class_2561.method_43469((String)"quickalias.editor.error.unknown_var", (Object[])new Object[]{ref});
                    valid = false;
                    break;
                }
                if (valid) continue;
                break;
            }
        }
        if (this.saveButton != null) {
            this.saveButton.field_22763 = valid;
        }
        if (this.addSubChildBtn != null) {
            boolean isEnd = this.workingNode.isEndNode();
            long cmdCount = this.workingNode.getCommands().size();
            boolean isMacroMode = cmdCount > 1L;
            boolean hasVariableChild = this.workingNode.getChildren().stream().anyMatch(AliasNode::isVariable);
            boolean bl = this.addSubChildBtn.field_22763 = valid && !isEnd && this.depth < 10 && !isMacroMode && !hasVariableChild;
        }
        if (this.addEndNodeBtn != null) {
            boolean isEnd = this.workingNode.isEndNode();
            long cmdCount = this.workingNode.getCommands().size();
            boolean isMacroMode = cmdCount > 1L;
            this.addEndNodeBtn.field_22763 = valid && !isEnd && this.depth < 10 && !isMacroMode;
        }
    }

    private boolean isRootNode() {
        return this.depth == 1;
    }

    private boolean isVariable(String s) {
        return s.startsWith("{") && s.endsWith("}") && s.length() > 2 && !"{END}".equals(s);
    }

    private List<AliasNode> getSiblings() {
        if (this.isRootNode()) {
            return ConfigManager.getInstance().getConfig().aliases;
        }
        if (this.parent instanceof AliasEditorScreen) {
            return ((AliasEditorScreen)this.parent).workingNode.getChildren();
        }
        return Collections.emptyList();
    }

    private Set<String> getParentVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        class_437 p = this.parent;
        while (p instanceof AliasEditorScreen) {
            AliasNode n = ((AliasEditorScreen)p).workingNode;
            if (n.isVariable()) {
                vars.add(n.getVariableName());
            }
            p = ((AliasEditorScreen)p).parent;
        }
        return vars;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY == 0.0) {
            return false;
        }
        double scrollSpeed = 15.0;
        int centerX = this.field_22789 / 2;
        int areaLeft = centerX - 120;
        int areaRight = centerX + 120;
        if (mouseX >= (double)areaLeft && mouseX <= (double)areaRight) {
            if (mouseY >= (double)this.cmdAreaTop && mouseY <= (double)this.cmdAreaBottom) {
                this.commandScrollAmount -= scrollY * scrollSpeed;
                this.rebuildInterface();
                return true;
            }
            if (mouseY >= (double)this.childAreaTop && mouseY <= (double)this.childAreaBottom) {
                this.childScrollAmount -= scrollY * scrollSpeed;
                this.rebuildInterface();
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    private void saveAndClose() {
        if (!this.saveButton.field_22763) {
            return;
        }
        this.saved = true;
        this.workingNode.setName(this.aliasInput.method_1882().trim());
        this.workingNode.getCommands().removeIf(String::isEmpty);
        if (this.isNewNode && this.isRootNode()) {
            ConfigManager.getInstance().getConfig().aliases.add(this.workingNode);
        } else {
            this.copyNodeData(this.workingNode, this.originalNode);
        }
        ConfigManager.getInstance().save();
        if (this.parent instanceof SettingsScreen) {
            ((SettingsScreen)this.parent).refreshList();
        }
        if (this.parent instanceof AliasEditorScreen) {
            ((AliasEditorScreen)this.parent).rebuildInterface();
        }
        this.field_22787.method_1507(this.parent);
    }

    private void copyNodeData(AliasNode source, AliasNode target) {
        target.setName(source.getName());
        target.setCommands(new ArrayList<String>(source.getCommands()));
        target.setChildren(new ArrayList<AliasNode>(source.getChildren()));
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        for (BreadcrumbSeparator sep : this.breadcrumbSeparators) {
            guiGraphics.method_27535(this.field_22793, sep.text, sep.x, sep.y, 0xAAAAAA);
        }
        guiGraphics.method_44379(0, this.cmdAreaTop, this.field_22789, this.cmdAreaBottom);
        for (class_339 widget : this.commandWidgets) {
            widget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        guiGraphics.method_44380();
        boolean isMacroMode = this.workingNode.getCommands().size() > 1;
        boolean isEndNode = this.workingNode.isEndNode();
        if (!isMacroMode && !isEndNode) {
            guiGraphics.method_44379(0, this.childAreaTop, this.field_22789, this.childAreaBottom);
            for (class_339 widget : this.childWidgets) {
                widget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }
            guiGraphics.method_44380();
        }
        int centerX = this.field_22789 / 2;
        int inputLeftX = centerX - 100;
        int labelAnchorX = inputLeftX - 15;
        if (this.isRootNode()) {
            guiGraphics.method_51448().method_22903();
            float scale = 1.5f;
            guiGraphics.method_51448().method_46416((float)(labelAnchorX + 4), (float)(this.aliasInput.method_46427() + 2), 0.0f);
            guiGraphics.method_51448().method_22905(scale, scale, 1.0f);
            guiGraphics.method_25303(this.field_22793, "/", 0, 0, 0xAAAAAA);
            guiGraphics.method_51448().method_22909();
        }
        class_5250 aliasLabel = class_2561.method_43471((String)"quickalias.editor.label.alias");
        guiGraphics.method_27535(this.field_22793, (class_2561)aliasLabel, labelAnchorX - this.field_22793.method_27525((class_5348)aliasLabel), this.aliasInput.method_46427() + 4, 0xAAAAAA);
        class_5250 cmdLabel = class_2561.method_43471((String)"quickalias.editor.label.cmd");
        guiGraphics.method_27535(this.field_22793, (class_2561)cmdLabel, labelAnchorX - this.field_22793.method_27525((class_5348)cmdLabel), this.cmdAreaTop + 4, 0xAAAAAA);
        if (!isMacroMode && !isEndNode) {
            class_5250 subLabel = class_2561.method_43471((String)"quickalias.editor.label.sub_options");
            guiGraphics.method_27535(this.field_22793, (class_2561)subLabel, labelAnchorX - this.field_22793.method_27525((class_5348)subLabel), this.childAreaTop + 4, 0xAAAAAA);
        }
        if (this.errorMessage != null) {
            int errorY = this.aliasInput.method_46427() + 14 + 6;
            guiGraphics.method_27535(this.field_22793, this.errorMessage, centerX - 100, errorY, 0xFF5555);
        }
    }

    public void method_25419() {
        class_437 class_4372;
        if (!this.saved && this.isNewNode && (class_4372 = this.parent) instanceof AliasEditorScreen) {
            AliasEditorScreen pEditor = (AliasEditorScreen)class_4372;
            pEditor.workingNode.getChildren().remove(this.originalNode);
            pEditor.rebuildInterface();
        }
        this.field_22787.method_1507(this.parent);
    }

    private record BreadcrumbSeparator(int x, int y, class_2561 text) {
    }
}

