/*
 * Decompiled with CFR 0.152.
 */
package com.florlet.quickalias.gui;

import com.florlet.quickalias.config.AliasNode;
import com.florlet.quickalias.config.ConfigManager;
import com.florlet.quickalias.gui.AliasEditorScreen;
import com.florlet.quickalias.gui.FlatButton;
import com.florlet.quickalias.gui.SettingsScreen;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class AliasScrollList
extends class_4280<AliasEntry> {
    private final SettingsScreen parentScreen;
    private final boolean isImportMode;
    private Set<String> conflictNames = Collections.emptySet();
    private String currentFilter = "";
    private static final Pattern CONSTANT_PATTERN = Pattern.compile("(?i)\\{(X|Y|Z|ID|DIM)}");

    public AliasScrollList(class_310 minecraft, SettingsScreen parentScreen, int width, int height, int top, int bottom, int itemHeight) {
        this(minecraft, parentScreen, width, height, top, bottom, itemHeight, false);
    }

    public AliasScrollList(class_310 minecraft, SettingsScreen parentScreen, int width, int height, int top, int bottom, int itemHeight, boolean isImportMode) {
        super(minecraft, width, bottom - top, top, itemHeight);
        this.parentScreen = parentScreen;
        this.isImportMode = isImportMode;
        if (!isImportMode) {
            this.refreshList();
        }
    }

    public void setFilter(String query) {
        this.currentFilter = query == null ? "" : query.trim().toLowerCase(Locale.ROOT);
        this.refreshList();
    }

    public void refreshList() {
        this.method_25339();
        List<AliasNode> aliases = ConfigManager.getInstance().getConfig().aliases;
        for (AliasNode node : aliases) {
            if (!this.currentFilter.isEmpty() && !this.matchesRecursive(node, this.currentFilter)) continue;
            this.method_25321((class_350.class_351)new AliasEntry(node));
        }
    }

    private boolean matchesRecursive(AliasNode node, String query) {
        if (node.getName().toLowerCase(Locale.ROOT).contains(query)) {
            return true;
        }
        for (String cmd : node.getCommands()) {
            if (!cmd.toLowerCase(Locale.ROOT).contains(query)) continue;
            return true;
        }
        for (AliasNode child : node.getChildren()) {
            if (!this.matchesRecursive(child, query)) continue;
            return true;
        }
        return false;
    }

    public void setImportNodes(List<AliasNode> nodes, Set<String> conflicts) {
        this.method_25339();
        Set<Object> set = this.conflictNames = conflicts == null ? Collections.emptySet() : conflicts;
        if (nodes != null) {
            for (AliasNode node : nodes) {
                this.method_25321((class_350.class_351)new AliasEntry(node));
            }
        }
    }

    public int method_25322() {
        return this.field_22758 - 20;
    }

    protected int method_25329() {
        return this.field_22758 - 10;
    }

    private class_2561 formatCommand(String cmd) {
        class_5250 root = class_2561.method_43473();
        Matcher m = CONSTANT_PATTERN.matcher(cmd);
        int lastEnd = 0;
        while (m.find()) {
            if (m.start() > lastEnd) {
                root.method_10852((class_2561)class_2561.method_43470((String)cmd.substring(lastEnd, m.start())).method_27696(class_2583.field_24360.method_36139(0xAAAAAA)));
            }
            root.method_10852((class_2561)class_2561.method_43470((String)m.group()).method_27696(class_2583.field_24360.method_36139(0xAA55FF)));
            lastEnd = m.end();
        }
        if (lastEnd < cmd.length()) {
            root.method_10852((class_2561)class_2561.method_43470((String)cmd.substring(lastEnd)).method_27696(class_2583.field_24360.method_36139(0xAAAAAA)));
        }
        return root;
    }

    public class AliasEntry
    extends class_4280.class_4281<AliasEntry> {
        private final AliasNode node;
        private final FlatButton upBtn;
        private final FlatButton downBtn;
        private final FlatButton editBtn;
        private final FlatButton deleteBtn;

        public AliasEntry(AliasNode node) {
            this.node = node;
            if (!AliasScrollList.this.isImportMode) {
                boolean canSort = AliasScrollList.this.currentFilter.isEmpty();
                this.upBtn = new FlatButton(0, 0, 12, 8, (class_2561)class_2561.method_43473(), btn -> this.move(-1));
                this.upBtn.field_22763 = canSort;
                this.downBtn = new FlatButton(0, 0, 12, 8, (class_2561)class_2561.method_43473(), btn -> this.move(1));
                this.downBtn.field_22763 = canSort;
                this.editBtn = new FlatButton(0, 0, 30, 16, (class_2561)class_2561.method_43471((String)"quickalias.gui.edit"), btn -> class_310.method_1551().method_1507((class_437)new AliasEditorScreen(AliasScrollList.this.parentScreen, node, false)));
                this.deleteBtn = new FlatButton(0, 0, 16, 16, (class_2561)class_2561.method_43470((String)"\u00d7").method_27694(s -> s.method_36139(0xFF5555)), btn -> {
                    ConfigManager.getInstance().getConfig().aliases.remove(node);
                    ConfigManager.getInstance().save();
                    AliasScrollList.this.refreshList();
                });
            } else {
                this.upBtn = null;
                this.downBtn = null;
                this.editBtn = null;
                this.deleteBtn = null;
            }
        }

        private void move(int dir) {
            if (!AliasScrollList.this.currentFilter.isEmpty()) {
                return;
            }
            List<AliasNode> list = ConfigManager.getInstance().getConfig().aliases;
            int index = list.indexOf(this.node);
            if (index >= 0 && index + dir >= 0 && index + dir < list.size()) {
                Collections.swap(list, index, index + dir);
                ConfigManager.getInstance().save();
                AliasScrollList.this.refreshList();
            }
        }

        public void method_25343(@NotNull class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isSelected, float partialTick) {
            boolean hasChildren;
            int bgTop = top + 2;
            int bgBottom = top + height - 2;
            guiGraphics.method_25294(left, bgTop, left + width, bgBottom, 0x15FFFFFF);
            int currentX = left + 4;
            int centerY = bgTop + (bgBottom - bgTop) / 2;
            if (!AliasScrollList.this.isImportMode) {
                int btnHeight = (bgBottom - bgTop) / 2;
                if (AliasScrollList.this.currentFilter.isEmpty()) {
                    this.upBtn.method_46421(currentX);
                    this.upBtn.method_46419(bgTop);
                    this.upBtn.method_53533(btnHeight);
                    this.upBtn.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                    float scale = 0.7f;
                    guiGraphics.method_51448().method_22903();
                    guiGraphics.method_51448().method_22905(scale, scale, 1.0f);
                    guiGraphics.method_25303(class_310.method_1551().field_1772, "\u25b2", (int)(((float)(currentX + 6) - (float)class_310.method_1551().field_1772.method_1727("\u25b2") * scale / 2.0f) / scale), (int)((float)(bgTop + 1) / scale), 0xFFFFFF);
                    guiGraphics.method_51448().method_22909();
                    this.downBtn.method_46421(currentX);
                    this.downBtn.method_46419(bgTop + btnHeight);
                    this.downBtn.method_53533(btnHeight);
                    this.downBtn.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                    guiGraphics.method_51448().method_22903();
                    guiGraphics.method_51448().method_22905(scale, scale, 1.0f);
                    guiGraphics.method_25303(class_310.method_1551().field_1772, "\u25bc", (int)(((float)(currentX + 6) - (float)class_310.method_1551().field_1772.method_1727("\u25bc") * scale / 2.0f) / scale), (int)((float)(bgTop + btnHeight * 2 - 7) / scale), 0xFFFFFF);
                    guiGraphics.method_51448().method_22909();
                }
                currentX += 16;
            }
            String nameText = "/" + this.node.getName();
            int nameColor = 0xFFFFFF;
            if (AliasScrollList.this.isImportMode && AliasScrollList.this.conflictNames.contains(this.node.getName().toLowerCase())) {
                nameColor = 0xFF5555;
            } else if (this.node.isVariable()) {
                nameColor = 0xFFAA00;
            } else if (this.node.isEndNode()) {
                nameColor = 0xAA55FF;
            }
            guiGraphics.method_25303(class_310.method_1551().field_1772, nameText, currentX, centerY - 4, nameColor);
            int nameWidth = class_310.method_1551().field_1772.method_1727(nameText);
            int arrowX = currentX + nameWidth + 5;
            guiGraphics.method_25303(class_310.method_1551().field_1772, "->", arrowX, centerY - 4, 0x888888);
            int arrowWidth = class_310.method_1551().field_1772.method_1727("->");
            int contentX = arrowX + arrowWidth + 5;
            boolean hasCommands = !this.node.getCommands().isEmpty();
            boolean bl = hasChildren = !this.node.getChildren().isEmpty();
            if (hasChildren) {
                Object displayStr;
                if (hasCommands) {
                    displayStr = String.join((CharSequence)", ", this.node.getCommands());
                } else {
                    List<String> childNames = this.node.getChildren().stream().map(AliasNode::getName).toList();
                    displayStr = "[" + String.join((CharSequence)", ", childNames) + "]";
                }
                int buttonsWidth = AliasScrollList.this.isImportMode ? 0 : 55;
                int availableWidth = left + width - contentX - buttonsWidth - 5;
                Object renderedStr = class_310.method_1551().field_1772.method_27523((String)displayStr, availableWidth);
                if (((String)renderedStr).length() < ((String)displayStr).length()) {
                    renderedStr = (String)renderedStr + "...";
                }
                guiGraphics.method_25303(class_310.method_1551().field_1772, (String)renderedStr, contentX, centerY - 4, 0x55AAFF);
            } else {
                String rawCmds = String.join((CharSequence)", ", this.node.getCommands());
                int buttonsWidth = AliasScrollList.this.isImportMode ? 0 : 55;
                int availableWidth = left + width - contentX - buttonsWidth - 5;
                class_2561 formattedCmd = AliasScrollList.this.formatCommand(rawCmds);
                Object truncatedRaw = class_310.method_1551().field_1772.method_27523(rawCmds, availableWidth);
                if (((String)truncatedRaw).length() < rawCmds.length()) {
                    truncatedRaw = (String)truncatedRaw + "...";
                }
                class_2561 renderComp = AliasScrollList.this.formatCommand((String)truncatedRaw);
                guiGraphics.method_27535(class_310.method_1551().field_1772, renderComp, contentX, centerY - 4, 0xFFFFFF);
            }
            if (!AliasScrollList.this.isImportMode) {
                int btnY = centerY - 8;
                this.deleteBtn.method_46421(left + width - 20);
                this.deleteBtn.method_46419(btnY);
                this.deleteBtn.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                this.editBtn.method_46421(left + width - 55);
                this.editBtn.method_46419(btnY);
                this.editBtn.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (AliasScrollList.this.isImportMode) {
                return false;
            }
            if (AliasScrollList.this.currentFilter.isEmpty()) {
                if (this.upBtn.method_25402(mouseX, mouseY, button)) {
                    return true;
                }
                if (this.downBtn.method_25402(mouseX, mouseY, button)) {
                    return true;
                }
            }
            if (this.editBtn.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            if (this.deleteBtn.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        @NotNull
        public class_2561 method_37006() {
            return class_2561.method_43470((String)this.node.getName());
        }
    }
}

