/*
 * Decompiled with CFR 0.152.
 */
package com.florlet.quickalias.gui;

import com.florlet.quickalias.QuickAliasLogger;
import com.florlet.quickalias.config.AliasNode;
import com.florlet.quickalias.config.ConfigManager;
import com.florlet.quickalias.gui.AliasScrollList;
import com.florlet.quickalias.gui.FlatButton;
import com.florlet.quickalias.gui.SettingsScreen;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class ImportConfigScreen
extends class_437 {
    private static final Gson GSON = new Gson();
    private final class_437 parent;
    private AliasScrollList previewList;
    private ConfigManager.AliasConfig importedConfig;
    private class_2561 statusMessage;
    private int statusColor = 0xFFFFFF;
    private boolean isPreviewVisible = false;
    private boolean showConfirmation = false;
    private int pendingImportMode = -1;
    private class_4185 confirmBtn;
    private class_4185 cancelConfirmBtn;
    private class_4185 replaceBtn;
    private class_4185 skipBtn;
    private class_4185 overwriteBtn;
    private class_4185 fileBtn;
    private class_4185 closeBtn;

    public ImportConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)""));
        this.parent = parent;
        this.statusMessage = class_2561.method_43471((String)"quickalias.import.select_file");
    }

    protected void method_25426() {
        int contentTop = 40;
        int contentBottom = this.field_22790 - 40;
        this.fileBtn = new FlatButton(10, 10, 100, 16, (class_2561)class_2561.method_43471((String)"quickalias.import.select_file"), btn -> this.openFilePicker());
        this.method_37063((class_364)this.fileBtn);
        this.previewList = new AliasScrollList(this.field_22787, null, this.field_22789, this.field_22790, contentTop, contentBottom, 24, true);
        if (this.importedConfig != null && this.isPreviewVisible) {
            this.previewList.setImportNodes(this.importedConfig.aliases, this.getConflicts());
        }
        this.method_25429((class_364)this.previewList);
        int bottomY = this.field_22790 - 24;
        int btnWidth = 100;
        int gap = 10;
        int startX = (this.field_22789 - (btnWidth * 3 + gap * 2)) / 2;
        this.replaceBtn = new FlatButton(startX, bottomY, btnWidth, 16, (class_2561)class_2561.method_43471((String)"quickalias.import.mode.replace"), btn -> this.triggerConfirmation(0));
        this.overwriteBtn = new FlatButton(startX + btnWidth + gap, bottomY, btnWidth, 16, (class_2561)class_2561.method_43471((String)"quickalias.import.mode.merge_overwrite"), btn -> this.triggerConfirmation(2));
        this.skipBtn = new FlatButton(startX + (btnWidth + gap) * 2, bottomY, btnWidth, 16, (class_2561)class_2561.method_43471((String)"quickalias.import.mode.merge_skip"), btn -> this.triggerConfirmation(1));
        this.updateMainButtonsState();
        this.method_37063((class_364)this.replaceBtn);
        this.method_37063((class_364)this.skipBtn);
        this.method_37063((class_364)this.overwriteBtn);
        this.closeBtn = new FlatButton(this.field_22789 - 70, 10, 60, 16, (class_2561)class_2561.method_43471((String)"gui.cancel"), btn -> this.field_22787.method_1507(this.parent));
        this.method_37063((class_364)this.closeBtn);
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        this.confirmBtn = new FlatButton(centerX - 105, centerY + 10, 100, 20, (class_2561)class_2561.method_43471((String)"gui.continue"), btn -> {
            this.executeImport(this.pendingImportMode);
            this.showConfirmation = false;
        });
        this.cancelConfirmBtn = new FlatButton(centerX + 5, centerY + 10, 100, 20, (class_2561)class_2561.method_43471((String)"gui.cancel"), btn -> {
            this.showConfirmation = false;
            this.pendingImportMode = -1;
            this.updateMainButtonsState();
        });
        this.method_25429((class_364)this.confirmBtn);
        this.method_25429((class_364)this.cancelConfirmBtn);
    }

    private void updateMainButtonsState() {
        boolean active;
        boolean bl = active = this.isPreviewVisible && !this.showConfirmation;
        if (this.replaceBtn != null) {
            this.replaceBtn.field_22763 = active;
        }
        if (this.skipBtn != null) {
            this.skipBtn.field_22763 = active;
        }
        if (this.overwriteBtn != null) {
            this.overwriteBtn.field_22763 = active;
        }
        if (this.fileBtn != null) {
            boolean bl2 = this.fileBtn.field_22763 = !this.showConfirmation;
        }
        if (this.closeBtn != null) {
            this.closeBtn.field_22763 = !this.showConfirmation;
        }
    }

    private void triggerConfirmation(int mode) {
        this.pendingImportMode = mode;
        this.showConfirmation = true;
        this.updateMainButtonsState();
    }

    private void openFilePicker() {
        if (this.showConfirmation) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            PointerBuffer filters = MemoryUtil.memAllocPointer((int)1);
            try {
                filters.put(MemoryUtil.memASCII((CharSequence)"*.json"));
                filters.flip();
                String result = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)class_2561.method_43471((String)"quickalias.import.select_file").getString(), (CharSequence)"", (PointerBuffer)filters, (CharSequence)"JSON Files", (boolean)false);
                if (result != null) {
                    this.field_22787.execute(() -> this.loadFile(new File(result)));
                }
            }
            finally {
                MemoryUtil.memFree((CustomBuffer)filters);
            }
        });
    }

    private void loadFile(File file) {
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            ConfigManager.AliasConfig loaded = (ConfigManager.AliasConfig)GSON.fromJson((Reader)reader, ConfigManager.AliasConfig.class);
            this.handleLoadedConfig(loaded);
        }
        catch (Exception e) {
            QuickAliasLogger.error("Failed to load file", e);
            this.statusMessage = class_2561.method_43471((String)"quickalias.import.error.io_error");
            this.statusColor = 0xFF5555;
            this.isPreviewVisible = false;
            this.method_41843();
        }
    }

    private void handleLoadedConfig(ConfigManager.AliasConfig loaded) {
        this.importedConfig = loaded;
        if (loaded == null || loaded.aliases == null) {
            this.statusMessage = class_2561.method_43471((String)"quickalias.import.error.invalid_json");
            this.statusColor = 0xFF5555;
            this.isPreviewVisible = false;
        } else if (loaded.aliases.isEmpty()) {
            this.statusMessage = class_2561.method_43471((String)"quickalias.import.status.valid_zero");
            this.statusColor = 0xFFFF55;
            this.isPreviewVisible = false;
        } else {
            this.statusMessage = class_2561.method_43473();
            this.isPreviewVisible = true;
            this.previewList.setImportNodes(loaded.aliases, this.getConflicts());
            this.previewList.method_25307(0.0);
        }
        this.updateMainButtonsState();
    }

    private Set<String> getConflicts() {
        if (this.importedConfig == null) {
            return Collections.emptySet();
        }
        HashSet<String> localNames = new HashSet<String>();
        for (AliasNode node : ConfigManager.getInstance().getConfig().aliases) {
            localNames.add(node.getName().toLowerCase());
        }
        return localNames;
    }

    private void executeImport(int mode) {
        if (this.importedConfig == null) {
            return;
        }
        ConfigManager.AliasConfig currentConfig = ConfigManager.getInstance().getConfig();
        if (mode == 0) {
            currentConfig.aliases.clear();
            currentConfig.aliases.addAll(this.importedConfig.aliases);
        } else {
            for (AliasNode imported : this.importedConfig.aliases) {
                boolean exists = currentConfig.aliases.stream().anyMatch(n -> n.getName().equalsIgnoreCase(imported.getName()));
                if (exists) {
                    if (mode != 2) continue;
                    currentConfig.aliases.removeIf(n -> n.getName().equalsIgnoreCase(imported.getName()));
                    currentConfig.aliases.add(imported);
                    continue;
                }
                currentConfig.aliases.add(imported);
            }
        }
        ConfigManager.getInstance().save();
        this.field_22787.method_1507(this.parent);
        if (this.parent instanceof SettingsScreen) {
            ((SettingsScreen)this.parent).refreshList();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.showConfirmation) {
            if (this.confirmBtn.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            if (this.cancelConfirmBtn.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private class_2561 getModeComponent(int mode) {
        return switch (mode) {
            case 0 -> class_2561.method_43471((String)"quickalias.import.mode.replace");
            case 1 -> class_2561.method_43471((String)"quickalias.import.mode.merge_skip");
            case 2 -> class_2561.method_43471((String)"quickalias.import.mode.merge_overwrite");
            default -> class_2561.method_43470((String)"?");
        };
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.isPreviewVisible) {
            this.method_25434(guiGraphics);
            this.previewList.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        } else {
            guiGraphics.method_27534(this.field_22793, this.statusMessage, this.field_22789 / 2, this.field_22790 / 2, this.statusColor);
        }
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        if (this.showConfirmation) {
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 500.0f);
            guiGraphics.method_25294(0, 0, this.field_22789, this.field_22790, Integer.MIN_VALUE);
            int centerX = this.field_22789 / 2;
            int centerY = this.field_22790 / 2;
            int boxW = 240;
            int boxH = 80;
            int boxX = centerX - boxW / 2;
            int boxY = centerY - boxH / 2;
            guiGraphics.method_25294(boxX, boxY, boxX + boxW, boxY + boxH, -14540254);
            guiGraphics.method_25294(boxX, boxY, boxX + boxW, boxY + 1, -1);
            guiGraphics.method_25294(boxX, boxY + boxH - 1, boxX + boxW, boxY + boxH, -1);
            guiGraphics.method_25294(boxX, boxY, boxX + 1, boxY + boxH, -1);
            guiGraphics.method_25294(boxX + boxW - 1, boxY, boxX + boxW, boxY + boxH, -1);
            guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"quickalias.import.confirm.title"), centerX, boxY + 10, 0xFFFFFF);
            class_2561 modeText = this.getModeComponent(this.pendingImportMode);
            class_5250 msg = class_2561.method_43469((String)"quickalias.import.confirm.message", (Object[])new Object[]{modeText});
            List confirmLines = this.field_22793.method_1728((class_5348)msg, boxW - 10);
            int textY = boxY + 23;
            for (class_5481 line : confirmLines) {
                guiGraphics.method_35719(this.field_22793, line, centerX, textY, 0xAAAAAA);
                textY += 12;
            }
            this.confirmBtn.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            this.cancelConfirmBtn.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }
}

