/*
 * Decompiled with CFR 0.152.
 */
package com.florlet.quickalias.gui;

import com.florlet.quickalias.config.AliasNode;
import com.florlet.quickalias.config.ConfigManager;
import com.florlet.quickalias.core.VariableResolver;
import com.florlet.quickalias.mixin.ChatScreenAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_408;

public class ShortcutOverlay {
    private static final int MAX_LEVELS = 5;
    private static final int MAX_VISIBLE_ROWS = 8;
    private static final Pattern ANY_VAR_PATTERN = Pattern.compile("\\{([^}]+)}");
    private static final Set<String> SYSTEM_CONSTANTS = Set.of("X", "Y", "Z", "ID", "DIM");
    private final int screenWidth;
    private final int screenHeight;
    private final List<AliasNode> activePath = new ArrayList<AliasNode>();
    private final int[] levelYCache = new int[6];
    private boolean visible = false;
    private int scrollOffsetL1 = 0;

    public ShortcutOverlay(int width, int height) {
        this.screenWidth = width;
        this.screenHeight = height;
    }

    public void toggle() {
        boolean bl = this.visible = !this.visible;
        if (!this.visible) {
            this.activePath.clear();
            this.scrollOffsetL1 = 0;
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.visible) {
            return false;
        }
        List<AliasNode> roots = ConfigManager.getInstance().getConfig().aliases;
        if (roots.size() <= 8) {
            return false;
        }
        if (scrollY < 0.0) {
            if (this.scrollOffsetL1 < roots.size() - 8) {
                ++this.scrollOffsetL1;
                return true;
            }
        } else if (scrollY > 0.0 && this.scrollOffsetL1 > 0) {
            --this.scrollOffsetL1;
            return true;
        }
        return false;
    }

    public void render(class_332 graphics, int mouseX, int mouseY, int anchorX, int anchorY) {
        AliasNode hoveredL1;
        if (!this.visible) {
            return;
        }
        List<AliasNode> roots = ConfigManager.getInstance().getConfig().aliases;
        int itemHeight = 16;
        int menuWidth = 80;
        int startYBase = anchorY;
        int visibleCount = Math.min(roots.size(), 8);
        int l1Height = visibleCount * itemHeight;
        int l1X = anchorX;
        int l1Y = startYBase - l1Height;
        boolean anyHovered = false;
        List<AliasNode> visibleRoots = roots;
        if (roots.size() > 8) {
            visibleRoots = roots.subList(this.scrollOffsetL1, this.scrollOffsetL1 + visibleCount);
        }
        this.renderMenuLevel(graphics, visibleRoots, l1X, l1Y, menuWidth, itemHeight, mouseX, mouseY);
        if (roots.size() > 8) {
            this.renderScrollBar(graphics, l1X + menuWidth - 2, l1Y, l1Height, roots.size(), visibleCount, this.scrollOffsetL1);
        }
        if ((hoveredL1 = this.getHoveredNode(visibleRoots, l1X, l1Y, menuWidth, itemHeight, mouseX, mouseY)) != null) {
            this.updateActivePath(0, hoveredL1);
            anyHovered = true;
        } else if (this.isMouseInRect(mouseX, mouseY, l1X, l1Y, menuWidth, l1Height)) {
            anyHovered = true;
        }
        for (int i = 0; i < this.activePath.size() && i < 4; ++i) {
            int prevY;
            int prevX;
            AliasNode parentNode;
            List<AliasNode> children;
            AliasNode currentNode = this.activePath.get(i);
            if (currentNode == null || currentNode.isLeaf() || (children = currentNode.getChildren()).isEmpty()) continue;
            List<Object> parentList = i == 0 ? roots : ((parentNode = this.activePath.get(i - 1)) == null ? Collections.emptyList() : parentNode.getChildren());
            int indexInParent = parentList.indexOf(currentNode);
            if (i == 0 && roots.size() > 8) {
                indexInParent -= this.scrollOffsetL1;
            }
            if (i == 0) {
                prevX = l1X;
                prevY = l1Y;
            } else {
                prevX = l1X + i * menuWidth;
                prevY = this.getStoredY(i);
            }
            int currentMenuX = prevX + menuWidth;
            int currentMenuHeight = children.size() * itemHeight;
            int currentMenuY = prevY + indexInParent * itemHeight;
            if (currentMenuY + currentMenuHeight > this.screenHeight) {
                currentMenuY = this.screenHeight - currentMenuHeight;
            }
            if (currentMenuY < 0) {
                currentMenuY = 0;
            }
            this.storeY(i + 1, currentMenuY);
            this.renderMenuLevel(graphics, children, currentMenuX, currentMenuY, menuWidth, itemHeight, mouseX, mouseY);
            AliasNode hoveredChild = this.getHoveredNode(children, currentMenuX, currentMenuY, menuWidth, itemHeight, mouseX, mouseY);
            if (hoveredChild != null) {
                this.updateActivePath(i + 1, hoveredChild);
                anyHovered = true;
                continue;
            }
            if (!this.isMouseInRect(mouseX, mouseY, currentMenuX, currentMenuY, menuWidth, currentMenuHeight)) continue;
            anyHovered = true;
        }
        if (!anyHovered) {
            this.activePath.clear();
        }
    }

    private void renderScrollBar(class_332 graphics, int x, int y, int height, int total, int visible, int offset) {
        int barHeight = (int)((float)visible / (float)total * (float)height);
        if (barHeight < 2) {
            barHeight = 2;
        }
        int barY = y + (int)((float)offset / (float)total * (float)height);
        graphics.method_25294(x, barY, x + 1, barY + barHeight, -1);
    }

    private void storeY(int levelIndex, int y) {
        this.levelYCache[levelIndex] = y;
    }

    private int getStoredY(int levelIndex) {
        return this.levelYCache[levelIndex];
    }

    private void updateActivePath(int levelIndex, AliasNode node) {
        while (this.activePath.size() <= levelIndex) {
            this.activePath.add(null);
        }
        this.activePath.set(levelIndex, node);
        if (this.activePath.size() > levelIndex + 1) {
            this.activePath.subList(levelIndex + 1, this.activePath.size()).clear();
        }
    }

    private boolean isMouseInRect(int mx, int my, int x, int y, int w, int h) {
        return mx >= x && mx < x + w && my >= y && my < y + h;
    }

    private void renderMenuLevel(class_332 graphics, List<AliasNode> nodes, int x, int y, int w, int h, int mx, int my) {
        if (nodes == ConfigManager.getInstance().getConfig().aliases && nodes.size() <= 8) {
            this.storeY(0, y);
        } else if (nodes == ConfigManager.getInstance().getConfig().aliases) {
            this.storeY(0, y);
        }
        int totalH = nodes.size() * h;
        int bgColor = -267386864;
        graphics.method_25296(x, y, x + w, y + totalH, bgColor, bgColor);
        int borderColor = -1;
        graphics.method_25294(x, y, x + w, y + 1, borderColor);
        graphics.method_25294(x, y + totalH - 1, x + w, y + totalH, borderColor);
        graphics.method_25294(x, y, x + 1, y + totalH, borderColor);
        graphics.method_25294(x + w - 1, y, x + w, y + totalH, borderColor);
        for (int i = 0; i < nodes.size(); ++i) {
            int color;
            AliasNode node = nodes.get(i);
            int itemY = y + i * h;
            boolean isHovered = mx >= x && mx < x + w && my >= itemY && my < itemY + h;
            boolean isActive = this.activePath.contains(node);
            if (isHovered || isActive) {
                graphics.method_25294(x + 1, itemY, x + w - 1, itemY + h, -2130706433);
            }
            int n = color = node.isLeaf() ? 0xFFFFFF : 0x66AAFF;
            if (node.isVariable()) {
                color = 0xFFAA00;
            }
            if (node.isEndNode()) {
                color = 0xAA55FF;
            }
            Object text = node.getName();
            if (!node.isLeaf()) {
                text = (String)text + " >";
            }
            graphics.method_25303(class_310.method_1551().field_1772, (String)text, x + 4, itemY + (h - 8) / 2, color);
        }
    }

    private AliasNode getHoveredNode(List<AliasNode> nodes, int x, int y, int w, int h, int mx, int my) {
        if (mx < x || mx >= x + w) {
            return null;
        }
        if (my < y || my >= y + nodes.size() * h) {
            return null;
        }
        int index = (my - y) / h;
        if (index >= 0 && index < nodes.size()) {
            return nodes.get(index);
        }
        return null;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        AliasNode last;
        if (!this.activePath.isEmpty() && (last = this.activePath.get(this.activePath.size() - 1)) != null && (last.isLeaf() || last.isEndNode() || last.isVariable())) {
            this.executeNode();
            return true;
        }
        if (this.visible) {
            this.visible = false;
            this.activePath.clear();
            return false;
        }
        return false;
    }

    private void executeNode() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        if (this.activePath.isEmpty()) {
            return;
        }
        AliasNode target = this.activePath.get(this.activePath.size() - 1);
        List<String> targetCommands = target.getCommands();
        boolean pathHasVariable = this.activePath.stream().anyMatch(AliasNode::isVariable);
        boolean commandNeedsArgs = false;
        ArrayList<String> allPendingCommands = new ArrayList<String>();
        for (AliasNode aliasNode : this.activePath) {
            if (aliasNode.getCommands() == null) continue;
            allPendingCommands.addAll(aliasNode.getCommands());
        }
        if (!allPendingCommands.isEmpty()) {
            for (String string : allPendingCommands) {
                Matcher m = ANY_VAR_PATTERN.matcher(string);
                while (m.find()) {
                    String varName = m.group(1);
                    if (SYSTEM_CONSTANTS.contains(varName.toUpperCase())) continue;
                    commandNeedsArgs = true;
                    break;
                }
                if (!commandNeedsArgs) continue;
                break;
            }
        }
        if (pathHasVariable || commandNeedsArgs) {
            if (mc.field_1755 instanceof class_408) {
                ArrayList<String> prefixParts = new ArrayList<String>();
                for (AliasNode n : this.activePath) {
                    if (n.isVariable()) break;
                    if (n.isEndNode()) continue;
                    prefixParts.add(n.getName());
                }
                String string = "/" + String.join((CharSequence)" ", prefixParts) + " ";
                ((ChatScreenAccessor)mc.field_1755).getInput().method_1852(string);
                ((ChatScreenAccessor)mc.field_1755).getInput().method_1872(false);
            }
            this.visible = false;
            this.activePath.clear();
        } else {
            ArrayList<String> accumulatedCommands = new ArrayList<String>();
            for (AliasNode node : this.activePath) {
                List<String> nodeCmds;
                if (node.isEndNode() || (nodeCmds = node.getCommands()) == null || nodeCmds.isEmpty()) continue;
                if (accumulatedCommands.isEmpty()) {
                    accumulatedCommands.addAll(nodeCmds);
                    continue;
                }
                ArrayList<Object> nextStage = new ArrayList<Object>();
                for (String base : accumulatedCommands) {
                    for (String append : nodeCmds) {
                        if (append.isEmpty()) {
                            nextStage.add(base);
                            continue;
                        }
                        nextStage.add(base + " " + append);
                    }
                }
                accumulatedCommands = nextStage;
            }
            if (accumulatedCommands.isEmpty()) {
                return;
            }
            for (String cmd : accumulatedCommands) {
                String finalCmd = VariableResolver.resolve(cmd, Collections.emptyMap());
                if (finalCmd.trim().isEmpty()) continue;
                if (finalCmd.startsWith("/")) {
                    mc.field_1724.field_3944.method_45730(finalCmd.substring(1));
                    continue;
                }
                mc.field_1724.field_3944.method_45729(finalCmd);
            }
            this.visible = false;
            this.activePath.clear();
            mc.method_1507(null);
        }
    }
}

