/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.CustomPortalBlock;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.mixin.client.PortalManagerAccessor;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.PortalProcessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={Gui.class})
public class InGameHudMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private int lastColor = -1;

    @Redirect(method={"renderPortalOverlay"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;setColor(FFFF)V", ordinal=0))
    public void changeColor(GuiGraphics instance, float red, float green, float blue, float alpha) {
        this.isCustomPortal(this.minecraft.player);
        if (this.lastColor >= 0) {
            FastColor.ABGR32.color((int)FastColor.as8BitChannel((float)alpha), (int)this.lastColor);
        } else {
            RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
        }
    }

    @Redirect(method={"renderPortalOverlay"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/block/BlockModelShaper;getParticleIcon(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;"))
    public TextureAtlasSprite renderCustomPortalOverlay(BlockModelShaper blockModels, BlockState blockState) {
        if (this.lastColor >= 0) {
            return this.minecraft.getBlockRenderer().getBlockModelShaper().getParticleIcon(CustomPortalsMod.portalBlock.get().defaultBlockState());
        }
        return this.minecraft.getBlockRenderer().getBlockModelShaper().getParticleIcon(Blocks.NETHER_PORTAL.defaultBlockState());
    }

    @Unique
    private void isCustomPortal(LocalPlayer player) {
        CustomPortalBlock customportalblock;
        PortalLink link;
        BlockPos portalPos;
        PortalProcessor portalManager = player.portalProcess;
        Portal portalBlock = portalManager != null && portalManager.isInsidePortalThisTick() ? ((PortalManagerAccessor)portalManager).getPortal() : null;
        BlockPos blockPos = portalPos = portalManager != null && portalManager.isInsidePortalThisTick() ? ((PortalManagerAccessor)portalManager).getEntryPosition() : null;
        if (portalBlock == null) {
            return;
        }
        if (portalBlock instanceof CustomPortalBlock && (link = CustomPortalApiRegistry.getPortalLinkFromBase((customportalblock = (CustomPortalBlock)portalBlock).getPortalBase((Level)player.clientLevel, portalPos))) != null) {
            this.lastColor = link.colorID;
            return;
        }
        this.lastColor = -1;
    }
}

