/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.util;

import java.util.Optional;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.portal.PortalPlacer;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.portal.linking.DimensionalBlockPos;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.kyrptonaught.customportalapi.util.SHOULDTP;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public class CustomTeleporter {
    private CustomTeleporter() {
    }

    public static DimensionTransition createTeleportTarget(Level world, Entity entity, Block portalBase, BlockPos portalPos) {
        PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(portalBase);
        if (link == null) {
            return null;
        }
        if (link.getBeforeTPEvent().execute(entity) == SHOULDTP.CANCEL_TP) {
            return null;
        }
        ResourceKey<Level> destKey = world.dimension() == CustomPortalsMod.dims.get(link.dimID) ? CustomPortalsMod.dims.get(link.returnDimID) : CustomPortalsMod.dims.get(link.dimID);
        ServerLevel destination = ((ServerLevel)world).getServer().getLevel(destKey);
        if (destination == null) {
            return null;
        }
        if (!entity.canUsePortal(false)) {
            return null;
        }
        return CustomTeleporter.customTPTarget(destination, entity, portalPos, portalBase, link.getFrameTester());
    }

    private static DimensionTransition customTPTarget(ServerLevel destinationWorld, Entity entity, BlockPos enteredPortalPos, Block frameBlock, PortalFrameTester.PortalFrameTesterFactory portalFrameTesterFactory) {
        PortalFrameTester portalFrameTester;
        Direction.Axis portalAxis = CustomPortalHelper.getAxisFrom(entity.level().getBlockState(enteredPortalPos));
        BlockUtil.FoundRectangle fromPortalRectangle = portalFrameTesterFactory.createInstanceOfPortalFrameTester().init((LevelAccessor)entity.level(), enteredPortalPos, portalAxis, frameBlock).getRectangle();
        DimensionalBlockPos destinationPos = CustomPortalsMod.portalLinkingStorage.getDestination(fromPortalRectangle.minCorner, (ResourceKey<Level>)entity.level().dimension());
        if (destinationPos != null && destinationPos.dimensionType.equals((Object)destinationWorld.dimension().location()) && (portalFrameTester = portalFrameTesterFactory.createInstanceOfPortalFrameTester().init((LevelAccessor)destinationWorld, destinationPos.pos, portalAxis, frameBlock)).isValidFrame()) {
            if (!portalFrameTester.isAlreadyLitPortalFrame()) {
                portalFrameTester.lightPortal(frameBlock);
            }
            PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(frameBlock);
            return portalFrameTester.getTPTargetInPortal(destinationWorld, portalFrameTester.getRectangle(), portalAxis, portalFrameTester.getEntityOffsetInPortal(fromPortalRectangle, entity, portalAxis), entity, link);
        }
        return CustomTeleporter.createDestinationPortal(destinationWorld, entity, portalAxis, fromPortalRectangle, frameBlock.defaultBlockState());
    }

    public static DimensionTransition createDestinationPortal(ServerLevel destination, Entity entity, Direction.Axis axis, BlockUtil.FoundRectangle portalFramePos, BlockState frameBlock) {
        WorldBorder worldBorder = destination.getWorldBorder();
        double xMin = Math.max(-2.9999872E7, worldBorder.getMinX() + 16.0);
        double zMin = Math.max(-2.9999872E7, worldBorder.getMinZ() + 16.0);
        double xMax = Math.min(2.9999872E7, worldBorder.getMaxX() - 16.0);
        double zMax = Math.min(2.9999872E7, worldBorder.getMaxZ() - 16.0);
        double scaleFactor = DimensionType.getTeleportationScale((DimensionType)entity.level().dimensionType(), (DimensionType)destination.dimensionType());
        BlockPos blockPos3 = BlockPos.containing((double)Mth.clamp((double)(entity.getX() * scaleFactor), (double)xMin, (double)xMax), (double)entity.getY(), (double)Mth.clamp((double)(entity.getZ() * scaleFactor), (double)zMin, (double)zMax));
        Optional<BlockUtil.FoundRectangle> portal = PortalPlacer.createDestinationPortal(destination, blockPos3, frameBlock, axis);
        if (portal.isPresent()) {
            PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(frameBlock.getBlock());
            PortalFrameTester portalFrameTester = link.getFrameTester().createInstanceOfPortalFrameTester();
            CustomPortalsMod.portalLinkingStorage.createLink(portalFramePos.minCorner, (ResourceKey<Level>)entity.level().dimension(), portal.get().minCorner, (ResourceKey<Level>)destination.dimension());
            return portalFrameTester.getTPTargetInPortal(destination, portal.get(), axis, portalFrameTester.getEntityOffsetInPortal(portalFramePos, entity, axis), entity, link);
        }
        return CustomTeleporter.idkWhereToPutYou(destination, entity, blockPos3);
    }

    protected static DimensionTransition idkWhereToPutYou(ServerLevel world, Entity entity, BlockPos pos) {
        CustomPortalsMod.logError("Unable to find tp location, forced to place on top of world");
        BlockPos destinationPos = world.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, pos);
        return new DimensionTransition(world, new Vec3((double)destinationPos.getX() + 0.5, (double)destinationPos.getY(), (double)destinationPos.getZ() + 0.5), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), DimensionTransition.DO_NOTHING);
    }
}

