/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.block.custom.grass;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.xstarlotte.snsnf.block.SNSBlock;

public class CinnamonGrassBlock
extends SnowyDirtBlock
implements BonemealableBlock {
    public CinnamonGrassBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!CinnamonGrassBlock.isValidPlacement(state, (BlockGetter)level, pos)) {
            level.setBlockAndUpdate(pos, ((Block)SNSBlock.CINNAMON_DIRT_BLOCK.get()).defaultBlockState());
        } else if (level.getMaxLocalRawBrightness(pos.above()) >= 9) {
            for (int i = 0; i < 4; ++i) {
                BlockPos spreadPos = pos.offset(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                BlockState dirtState = level.getBlockState(spreadPos);
                if (!dirtState.is((Block)SNSBlock.CINNAMON_DIRT_BLOCK.get()) || !CinnamonGrassBlock.isValidPlacement(state, (BlockGetter)level, spreadPos)) continue;
                level.setBlockAndUpdate(spreadPos, this.defaultBlockState());
            }
        }
    }

    private static boolean isValidPlacement(BlockState state, BlockGetter world, BlockPos pos) {
        BlockPos above = pos.above();
        BlockState aboveState = world.getBlockState(above);
        return !aboveState.isSolid() || aboveState.getFluidState().isEmpty();
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos above = pos.above();
        for (int i = 0; i < 24; ++i) {
            BlockState below;
            BlockState ground;
            BlockPos target = above;
            for (int j = 0; j < i / 16 && (ground = level.getBlockState((target = target.offset(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).below())).is((Block)this) && ground.isFaceSturdy((BlockGetter)level, target.below(), Direction.UP) && !level.getBlockState(target).isCollisionShapeFullBlock((BlockGetter)level, target); ++j) {
            }
            if (!level.getBlockState(target).isAir() || !level.getBlockState(target.below()).is((Block)SNSBlock.CINNAMON_GRASS_BLOCK.get()) || !level.getBlockState(target.above()).isAir() || this.isCinnamonPlant(below = level.getBlockState(target.below()))) continue;
            if (random.nextInt(4) == 0) {
                switch (random.nextInt(6)) {
                    case 0: {
                        level.setBlockAndUpdate(target, ((Block)SNSBlock.CINNAMON_FLOWER.get()).defaultBlockState());
                        break;
                    }
                    case 1: {
                        level.setBlockAndUpdate(target, ((Block)SNSBlock.CINNAMON_FLOWER_2.get()).defaultBlockState());
                    }
                }
                continue;
            }
            if (random.nextBoolean()) {
                level.setBlockAndUpdate(target, ((Block)SNSBlock.CINNAMON_GRASS.get()).defaultBlockState());
                continue;
            }
            level.setBlockAndUpdate(target, ((Block)SNSBlock.CINNAMON_GRASS_LONG.get()).defaultBlockState());
        }
    }

    private boolean isCinnamonPlant(BlockState state) {
        return state.is((Block)SNSBlock.CINNAMON_FLOWER.get()) || state.is((Block)SNSBlock.CINNAMON_FLOWER_2.get()) || state.is((Block)SNSBlock.CINNAMON_GRASS.get()) || state.is((Block)SNSBlock.CINNAMON_GRASS_LONG.get());
    }
}

