/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.datagen;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.xstarlotte.snsnf.block.SNSBlock;
import net.xstarlotte.snsnf.fluid.SNSFluid;

public class SNSBlockStateProvider
extends BlockStateProvider {
    public SNSBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "snsnf", exFileHelper);
    }

    protected void registerStatesAndModels() {
        ModelBuilder bourbonCarpetModel = ((BlockModelBuilder)this.models().withExistingParent("bourbon_carpet", this.mcLoc("block/carpet"))).texture("wool", this.modLoc("block/bourbon"));
        this.simpleBlock((Block)SNSBlock.BOURBON_CARPET.get(), (ModelFile)bourbonCarpetModel);
        ModelBuilder custardCarpetModel = ((BlockModelBuilder)this.models().withExistingParent("custard_cream_carpet", this.mcLoc("block/carpet"))).texture("wool", this.modLoc("block/custard_cream"));
        this.simpleBlock((Block)SNSBlock.CUSTARD_CREAM_CARPET.get(), (ModelFile)custardCarpetModel);
        ModelBuilder peppermintSwirlCarpetModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("peppermint_swirl_carpet", this.mcLoc("block/carpet"))).texture("wool", this.modLoc("block/peppermint_swirl"))).renderType("minecraft:cutout");
        this.simpleBlock((Block)SNSBlock.PEPPERMINT_SWIRL_CARPET.get(), (ModelFile)peppermintSwirlCarpetModel);
        this.simpleCross(SNSBlock.APPLE_FRUIT_ROLL_BUSH);
        this.simpleCross(SNSBlock.BANANA_FRUIT_ROLL_BUSH);
        this.simpleCross(SNSBlock.BLACKBERRY_ROLL_BUSH);
        this.simpleCross(SNSBlock.BLUEBERRY_ROLL_BUSH);
        this.simpleCross(SNSBlock.RASPBERRY_ROLL_BUSH);
        this.simpleCross(SNSBlock.STRAWBERRY_ROLL_BUSH);
        this.simpleCross(SNSBlock.CANDYFLOSS_BUSH);
        this.simpleCross(SNSBlock.CANDYFLOSS_COSMOS);
        this.simpleCross(SNSBlock.CANDYFLOSS_COSMOS_2);
        this.simpleCross(SNSBlock.CANDYFLOSS_COSMOS_3);
        this.simpleCross(SNSBlock.CANDYFLOSS_COSMOS_4);
        this.simpleCross(SNSBlock.CANDYFLOSS_COSMOS_5);
        this.simpleCross(SNSBlock.CANDYFLOSS_GRASS);
        this.simpleCross(SNSBlock.CANDYFLOSS_GRASS_SHORT);
        this.simpleCross(SNSBlock.CANDY_CANE_BUSH);
        this.simpleCross(SNSBlock.CANDY_CANE_CARNATION);
        this.simpleCross(SNSBlock.CANDY_CANE_FLOWER);
        this.simpleCross(SNSBlock.CANDY_CANE_FLOWER_2);
        this.simpleCross(SNSBlock.CANDY_CANE_FLOWER_3);
        this.simpleCross(SNSBlock.CANDY_CANE_FLOWER_4);
        this.simpleCross(SNSBlock.CANDY_CANE_GRASS);
        this.simpleCross(SNSBlock.CANDY_CANE_GRASS_LONG);
        this.simpleCross(SNSBlock.MINT_BUSH);
        this.simpleCross(SNSBlock.MINT_FLOWER);
        this.simpleCross(SNSBlock.MINT_FLOWER_2);
        this.simpleCross(SNSBlock.MINT_FLOWER_3);
        this.simpleCross(SNSBlock.MINT_GRASS);
        this.simpleCross(SNSBlock.MINT_GRASS_LONG);
        this.simpleCross(SNSBlock.CHOCOLATE_GRASS);
        this.simpleCross(SNSBlock.CINNAMON_FLOWER);
        this.simpleCross(SNSBlock.CINNAMON_FLOWER_2);
        this.simpleCross(SNSBlock.CINNAMON_GRASS);
        this.simpleCross(SNSBlock.CINNAMON_GRASS_LONG);
        this.simpleCross(SNSBlock.RAINBOW_STRIP_FLOWER);
        this.simpleCross(SNSBlock.RAINBOW_STRIP_FLOWER_2);
        this.simpleCross(SNSBlock.RAINBOW_STRIP_GRASS);
        this.simpleCross(SNSBlock.RAINBOW_STRIP_GRASS_LONG);
        this.leavesBlock(SNSBlock.CANDY_CANE_LEAVES);
        this.saplingBlock(SNSBlock.CANDY_CANE_SAPLING);
        this.leavesBlock(SNSBlock.CHOCOLATE_LEAVES);
        this.saplingBlock(SNSBlock.CHOCOLATE_SAPLING);
        this.leavesBlock(SNSBlock.CINNAMON_LEAVES);
        this.saplingBlock(SNSBlock.CINNAMON_SAPLING);
        this.leavesBlock(SNSBlock.CANDYFLOSS_LEAVES);
        this.leavesBlock(SNSBlock.CANDYFLOSS_BLUE_RASPBERRY_LEAVES);
        this.leavesBlock(SNSBlock.CANDYFLOSS_LEMON_LEAVES);
        this.leavesBlock(SNSBlock.CANDYFLOSS_STRAWBERRY_LEAVES);
        this.leavesBlock(SNSBlock.CANDYFLOSS_VANILLA_LEAVES);
        this.saplingBlock(SNSBlock.CANDYFLOSS_SAPLING);
        this.leavesBlock(SNSBlock.RAINBOW_STRIP_LEAVES);
        this.saplingBlock(SNSBlock.RAINBOW_STRIP_SAPLING);
        this.rotatedPillarBlockWithTopBottom((Block)SNSBlock.CANDY_CANE_LOG.get(), this.modLoc("block/candy_cane_log_side"), this.modLoc("block/candy_cane_log_top"), this.modLoc("block/candy_cane_log_bottom"));
        this.rotatedPillarBlockWithTopBottom((Block)SNSBlock.STRIPPED_CANDY_CANE_LOG.get(), this.modLoc("block/stripped_candy_cane_log_side"), this.modLoc("block/stripped_candy_cane_log_top"), this.modLoc("block/stripped_candy_cane_log_bottom"));
        this.axisBlock((RotatedPillarBlock)SNSBlock.CANDY_CANE_WOOD.get());
        this.axisBlock((RotatedPillarBlock)SNSBlock.STRIPPED_CANDY_CANE_WOOD.get());
        this.blockItem(SNSBlock.CANDY_CANE_LOG);
        this.blockItem(SNSBlock.CANDY_CANE_WOOD);
        this.blockItem(SNSBlock.STRIPPED_CANDY_CANE_LOG);
        this.blockItem(SNSBlock.STRIPPED_CANDY_CANE_WOOD);
        this.rotatedPillarBlockWithTopBottom((Block)SNSBlock.CHOCOLATE_LOG.get(), this.modLoc("block/chocolate_log_side"), this.modLoc("block/chocolate_log_top"), this.modLoc("block/chocolate_log_bottom"));
        this.rotatedPillarBlockWithTopBottom((Block)SNSBlock.STRIPPED_CHOCOLATE_LOG.get(), this.modLoc("block/stripped_chocolate_log_side"), this.modLoc("block/stripped_chocolate_log_top"), this.modLoc("block/stripped_chocolate_log_bottom"));
        this.axisBlock((RotatedPillarBlock)SNSBlock.CHOCOLATE_WOOD.get());
        this.axisBlock((RotatedPillarBlock)SNSBlock.STRIPPED_CHOCOLATE_WOOD.get());
        this.blockItem(SNSBlock.CHOCOLATE_LOG);
        this.blockItem(SNSBlock.CHOCOLATE_WOOD);
        this.blockItem(SNSBlock.STRIPPED_CHOCOLATE_LOG);
        this.blockItem(SNSBlock.STRIPPED_CHOCOLATE_WOOD);
        this.rotatedPillarBlockWithTopBottom((Block)SNSBlock.CINNAMON_LOG.get(), this.modLoc("block/cinnamon_log_side"), this.modLoc("block/cinnamon_log_top"), this.modLoc("block/cinnamon_log_bottom"));
        this.rotatedPillarBlockWithTopBottom((Block)SNSBlock.STRIPPED_CINNAMON_LOG.get(), this.modLoc("block/stripped_cinnamon_log_side"), this.modLoc("block/stripped_cinnamon_log_top"), this.modLoc("block/stripped_cinnamon_log_bottom"));
        this.axisBlock((RotatedPillarBlock)SNSBlock.CINNAMON_WOOD.get());
        this.axisBlock((RotatedPillarBlock)SNSBlock.STRIPPED_CINNAMON_WOOD.get());
        this.blockItem(SNSBlock.CINNAMON_LOG);
        this.blockItem(SNSBlock.CINNAMON_WOOD);
        this.blockItem(SNSBlock.STRIPPED_CINNAMON_LOG);
        this.blockItem(SNSBlock.STRIPPED_CINNAMON_WOOD);
        this.rotatedPillarBlockWithTopBottom((Block)SNSBlock.CRYSTALISED_SUGAR_LOG.get(), this.modLoc("block/crystalised_sugar_log_side"), this.modLoc("block/crystalised_sugar_log_top"), this.modLoc("block/crystalised_sugar_log_bottom"));
        this.rotatedPillarBlockWithTopBottom((Block)SNSBlock.STRIPPED_CRYSTALISED_SUGAR_LOG.get(), this.modLoc("block/stripped_crystalised_sugar_log_side"), this.modLoc("block/stripped_crystalised_sugar_log_top"), this.modLoc("block/stripped_crystalised_sugar_log_bottom"));
        this.axisBlock((RotatedPillarBlock)SNSBlock.CRYSTALISED_SUGAR_WOOD.get());
        this.axisBlock((RotatedPillarBlock)SNSBlock.STRIPPED_CRYSTALISED_SUGAR_WOOD.get());
        this.blockItem(SNSBlock.CRYSTALISED_SUGAR_LOG);
        this.blockItem(SNSBlock.CRYSTALISED_SUGAR_WOOD);
        this.blockItem(SNSBlock.STRIPPED_CRYSTALISED_SUGAR_LOG);
        this.blockItem(SNSBlock.STRIPPED_CRYSTALISED_SUGAR_WOOD);
        this.rotatedPillarBlockWithTopBottom((Block)SNSBlock.LICORICE_LOG.get(), this.modLoc("block/licorice_log_side"), this.modLoc("block/licorice_log_top"), this.modLoc("block/licorice_log_bottom"));
        this.rotatedPillarBlockWithTopBottom((Block)SNSBlock.STRIPPED_LICORICE_LOG.get(), this.modLoc("block/stripped_licorice_log_side"), this.modLoc("block/stripped_licorice_log_top"), this.modLoc("block/stripped_licorice_log_bottom"));
        this.axisBlock((RotatedPillarBlock)SNSBlock.LICORICE_WOOD.get());
        this.axisBlock((RotatedPillarBlock)SNSBlock.STRIPPED_LICORICE_WOOD.get());
        this.blockItem(SNSBlock.LICORICE_LOG);
        this.blockItem(SNSBlock.LICORICE_WOOD);
        this.blockItem(SNSBlock.STRIPPED_LICORICE_LOG);
        this.blockItem(SNSBlock.STRIPPED_LICORICE_WOOD);
        this.rotatedPillarBlockWithTopBottom((Block)SNSBlock.RAINBOW_STRIP_LOG.get(), this.modLoc("block/rainbow_strip_log_side"), this.modLoc("block/rainbow_strip_log_top"), this.modLoc("block/rainbow_strip_log_bottom"));
        this.rotatedPillarBlockWithTopBottom((Block)SNSBlock.STRIPPED_RAINBOW_STRIP_LOG.get(), this.modLoc("block/stripped_rainbow_strip_log_side"), this.modLoc("block/stripped_rainbow_strip_log_top"), this.modLoc("block/stripped_rainbow_strip_log_bottom"));
        this.axisBlock((RotatedPillarBlock)SNSBlock.RAINBOW_STRIP_WOOD.get());
        this.axisBlock((RotatedPillarBlock)SNSBlock.STRIPPED_RAINBOW_STRIP_WOOD.get());
        this.blockItem(SNSBlock.RAINBOW_STRIP_LOG);
        this.blockItem(SNSBlock.RAINBOW_STRIP_WOOD);
        this.blockItem(SNSBlock.STRIPPED_RAINBOW_STRIP_LOG);
        this.blockItem(SNSBlock.STRIPPED_RAINBOW_STRIP_WOOD);
        this.furnaceBlock((Block)SNSBlock.CANDY_CANE_FURNACE.get(), this.modLoc("block/candy_cane_furnace_side"), this.modLoc("block/candy_cane_furnace_top"), this.modLoc("block/candy_cane_furnace_front"), this.modLoc("block/candy_cane_furnace_front_lit"));
        this.furnaceBlock((Block)SNSBlock.CHOCOLATE_FURNACE.get(), this.modLoc("block/chocolate_furnace_side"), this.modLoc("block/chocolate_furnace_top"), this.modLoc("block/chocolate_furnace_front"), this.modLoc("block/chocolate_furnace_front_lit"));
        this.furnaceBlock((Block)SNSBlock.CRYSTALISED_SUGAR_FURNACE.get(), this.modLoc("block/crystalised_sugar_furnace_side"), this.modLoc("block/crystalised_sugar_furnace_top"), this.modLoc("block/crystalised_sugar_furnace_front"), this.modLoc("block/crystalised_sugar_furnace_front_lit"));
        this.glassBlock(SNSBlock.CRYSTALISED_SUGAR_GLASS, "crystalised_sugar_glass");
        this.ladderBlock(SNSBlock.CANDY_CANE_LADDER, "candy_cane_ladder");
        this.ladderBlock(SNSBlock.CHOCOLATE_LADDER, "chocolate_ladder");
        this.ladderBlock(SNSBlock.CINNAMON_LADDER, "cinnamon_ladder");
        this.ladderBlock(SNSBlock.RAINBOW_STRIP_LADDER, "rainbow_strip_ladder");
        this.ladderBlock(SNSBlock.WAFFLE_LADDER, "waffle_ladder");
        this.teddyBlock(SNSBlock.CANDY_CANE_CAT_TEDDY, "candy_cane_cat_teddy");
        this.teddyBlock(SNSBlock.CINNADILE_TEDDY, "cinnadile_teddy");
        this.teddyBlock(SNSBlock.MINT_MINK_TEDDY, "mint_mink_teddy");
        this.teddyBlock(SNSBlock.MYNX_TEDDY, "mynx_teddy");
        this.chestWithParticle((Block)SNSBlock.WAFFLE_CHEST.get(), this.modLoc("block/waffle_block"));
        this.fluidBlock((LiquidBlock)SNSFluid.CHOCOLATE_BLOCK.get());
        this.fluidBlock((LiquidBlock)SNSFluid.CREAM_BLOCK.get());
        this.fluidBlock((LiquidBlock)SNSFluid.MINT_WATER_BLOCK.get());
        this.torchWithWall("candy_cane_torch", (TorchBlock)SNSBlock.CANDY_CANE_TORCH.get(), (WallTorchBlock)SNSBlock.CANDY_CANE_WALL_TORCH.get(), "candy_cane_torch");
        this.torchWithWall("chocolate_torch", (TorchBlock)SNSBlock.CHOCOLATE_TORCH.get(), (WallTorchBlock)SNSBlock.CHOCOLATE_WALL_TORCH.get(), "chocolate_torch");
        this.torchWithWall("cinnamon_torch", (TorchBlock)SNSBlock.CINNAMON_TORCH.get(), (WallTorchBlock)SNSBlock.CINNAMON_WALL_TORCH.get(), "cinnamon_torch");
        this.torchWithWall("crystalised_sugar_torch", (TorchBlock)SNSBlock.CRYSTALISED_SUGAR_TORCH.get(), (WallTorchBlock)SNSBlock.CRYSTALISED_SUGAR_WALL_TORCH.get(), "crystalised_sugar_torch");
        this.torchWithWall("rainbow_strip_torch", (TorchBlock)SNSBlock.RAINBOW_STRIP_TORCH.get(), (WallTorchBlock)SNSBlock.RAINBOW_STRIP_WALL_TORCH.get(), "rainbow_strip_torch");
        this.torchWithWall("waffle_torch", (TorchBlock)SNSBlock.WAFFLE_TORCH.get(), (WallTorchBlock)SNSBlock.WAFFLE_WALL_TORCH.get(), "waffle_torch");
        this.blockWithItem(SNSBlock.CINNAMON_DIRT_BLOCK);
        this.blockWithItem(SNSBlock.COCOA_DIRT_BLOCK);
        this.blockWithItem(SNSBlock.COCOA_DARK_DIRT_BLOCK);
        this.blockWithItem(SNSBlock.COCOA_WHITE_DIRT_BLOCK);
        this.blockWithItem(SNSBlock.MINT_DIRT_BLOCK);
        this.blockWithItem(SNSBlock.SUGAR_DIRT_BLOCK);
        this.blockWithItem(SNSBlock.SPRINKLES_SAND_PINK);
        this.blockWithItem(SNSBlock.SPRINKLES_SAND_ORANGE);
        this.blockWithItem(SNSBlock.BLACKBERRY_SORBET_SAND);
        this.blockWithItem(SNSBlock.BLUEBERRY_SORBET_SAND);
        this.blockWithItem(SNSBlock.LEMON_SORBET_SAND);
        this.blockWithItem(SNSBlock.ORANGE_SORBET_SAND);
        this.blockWithItem(SNSBlock.PINEAPPLE_SORBET_SAND);
        this.blockWithItem(SNSBlock.RASPBERRY_SORBET_SAND);
        this.blockWithItem(SNSBlock.STRAWBERRY_SORBET_SAND);
        this.blockWithItemSideBotTop(SNSBlock.APPLE_FRUIT_ROLL_GRASS_BLOCK);
        this.blockWithItemSideBotTop(SNSBlock.BANANA_FRUIT_ROLL_GRASS_BLOCK);
        this.blockWithItemSideBotTop(SNSBlock.BLACKBERRY_ROLL_GRASS_BLOCK);
        this.blockWithItemSideBotTop(SNSBlock.BLUEBERRY_ROLL_GRASS_BLOCK);
        this.blockWithItemSideBotTop(SNSBlock.RASPBERRY_ROLL_GRASS_BLOCK);
        this.blockWithItemSideBotTop(SNSBlock.STRAWBERRY_ROLL_GRASS_BLOCK);
        this.blockWithItemSideBotTop(SNSBlock.CINNAMON_GRASS_BLOCK);
        this.blockWithItemSideBotTop(SNSBlock.CANDY_CANE_GRASS_BLOCK);
        this.blockWithItemSideBotTop(SNSBlock.MINT_GRASS_BLOCK);
        this.blockWithItemSideBotTop(SNSBlock.RAINBOW_STRIP_GRASS_BLOCK);
        this.blockWithItem(SNSBlock.PEPPERMINT_SWIRL_STONE_COAL_ORE);
        this.blockWithItemSideBotTop(SNSBlock.CARROT_CAKE_BLOCK);
        ResourceLocation SIDE7 = this.modLoc("block/carrot_cake_block_side");
        ResourceLocation BOTTOM7 = this.modLoc("block/carrot_cake_block_bottom");
        ResourceLocation TOP7 = this.modLoc("block/carrot_cake_block_top");
        this.cakeStairs((StairBlock)SNSBlock.byId("carrot_cake_stairs").get(), SIDE7, BOTTOM7, TOP7);
        this.cakeSlab((SlabBlock)SNSBlock.byId("carrot_cake_slab").get(), () -> (Block)SNSBlock.CARROT_CAKE_BLOCK.get(), SIDE7, BOTTOM7, TOP7);
        this.cakeFence((FenceBlock)SNSBlock.byId("carrot_cake_fence").get(), SIDE7);
        this.cakeFenceGate((FenceGateBlock)SNSBlock.byId("carrot_cake_fence_gate").get(), SIDE7);
        this.cakeWall((WallBlock)SNSBlock.byId("carrot_cake_wall").get(), SIDE7);
        this.cakeButton((ButtonBlock)SNSBlock.byId("carrot_cake_button").get(), SIDE7);
        this.cakePressurePlate((PressurePlateBlock)SNSBlock.byId("carrot_cake_pressure_plate").get(), SIDE7);
        this.blockWithItemSideBotTop(SNSBlock.CHOCOLATE_CHERRY_CAKE_BLOCK);
        ResourceLocation SIDE4 = this.modLoc("block/chocolate_cherry_cake_block_side");
        ResourceLocation BOTTOM4 = this.modLoc("block/chocolate_cherry_cake_block_bottom");
        ResourceLocation TOP4 = this.modLoc("block/chocolate_cherry_cake_block_top");
        this.cakeStairs((StairBlock)SNSBlock.byId("chocolate_cherry_cake_stairs").get(), SIDE4, BOTTOM4, TOP4);
        this.cakeSlab((SlabBlock)SNSBlock.byId("chocolate_cherry_cake_slab").get(), () -> (Block)SNSBlock.CHOCOLATE_CHERRY_CAKE_BLOCK.get(), SIDE4, BOTTOM4, TOP4);
        this.cakeFence((FenceBlock)SNSBlock.byId("chocolate_cherry_cake_fence").get(), SIDE4);
        this.cakeFenceGate((FenceGateBlock)SNSBlock.byId("chocolate_cherry_cake_fence_gate").get(), SIDE4);
        this.cakeWall((WallBlock)SNSBlock.byId("chocolate_cherry_cake_wall").get(), SIDE4);
        this.cakeButton((ButtonBlock)SNSBlock.byId("chocolate_cherry_cake_button").get(), SIDE4);
        this.cakePressurePlate((PressurePlateBlock)SNSBlock.byId("chocolate_cherry_cake_pressure_plate").get(), SIDE4);
        this.blockWithItemSideBotTop(SNSBlock.CHOCOLATE_MINT_CAKE_BLOCK);
        ResourceLocation SIDE5 = this.modLoc("block/chocolate_mint_cake_block_side");
        ResourceLocation BOTTOM5 = this.modLoc("block/chocolate_mint_cake_block_bottom");
        ResourceLocation TOP5 = this.modLoc("block/chocolate_mint_cake_block_top");
        this.cakeStairs((StairBlock)SNSBlock.byId("chocolate_mint_cake_stairs").get(), SIDE5, BOTTOM5, TOP5);
        this.cakeSlab((SlabBlock)SNSBlock.byId("chocolate_mint_cake_slab").get(), () -> (Block)SNSBlock.CHOCOLATE_MINT_CAKE_BLOCK.get(), SIDE5, BOTTOM5, TOP5);
        this.cakeFence((FenceBlock)SNSBlock.byId("chocolate_mint_cake_fence").get(), SIDE5);
        this.cakeFenceGate((FenceGateBlock)SNSBlock.byId("chocolate_mint_cake_fence_gate").get(), SIDE5);
        this.cakeWall((WallBlock)SNSBlock.byId("chocolate_mint_cake_wall").get(), SIDE5);
        this.cakeButton((ButtonBlock)SNSBlock.byId("chocolate_mint_cake_button").get(), SIDE5);
        this.cakePressurePlate((PressurePlateBlock)SNSBlock.byId("chocolate_mint_cake_pressure_plate").get(), SIDE5);
        this.blockWithItemSideBotTop(SNSBlock.CHOCOLATE_ORANGE_CAKE_BLOCK);
        ResourceLocation SIDE6 = this.modLoc("block/chocolate_orange_cake_block_side");
        ResourceLocation BOTTOM6 = this.modLoc("block/chocolate_orange_cake_block_bottom");
        ResourceLocation TOP6 = this.modLoc("block/chocolate_orange_cake_block_top");
        this.cakeStairs((StairBlock)SNSBlock.byId("chocolate_orange_cake_stairs").get(), SIDE6, BOTTOM6, TOP6);
        this.cakeSlab((SlabBlock)SNSBlock.byId("chocolate_orange_cake_slab").get(), () -> (Block)SNSBlock.CHOCOLATE_ORANGE_CAKE_BLOCK.get(), SIDE6, BOTTOM6, TOP6);
        this.cakeFence((FenceBlock)SNSBlock.byId("chocolate_orange_cake_fence").get(), SIDE6);
        this.cakeFenceGate((FenceGateBlock)SNSBlock.byId("chocolate_orange_cake_fence_gate").get(), SIDE6);
        this.cakeWall((WallBlock)SNSBlock.byId("chocolate_orange_cake_wall").get(), SIDE6);
        this.cakeButton((ButtonBlock)SNSBlock.byId("chocolate_orange_cake_button").get(), SIDE6);
        this.cakePressurePlate((PressurePlateBlock)SNSBlock.byId("chocolate_orange_cake_pressure_plate").get(), SIDE6);
        this.blockWithItemSideBotTop(SNSBlock.LEMON_CURD_CAKE_BLOCK);
        ResourceLocation SIDE2 = this.modLoc("block/lemon_curd_cake_block_side");
        ResourceLocation BOTTOM2 = this.modLoc("block/lemon_curd_cake_block_bottom");
        ResourceLocation TOP2 = this.modLoc("block/lemon_curd_cake_block_top");
        this.cakeStairs((StairBlock)SNSBlock.byId("lemon_curd_cake_stairs").get(), SIDE2, BOTTOM2, TOP2);
        this.cakeSlab((SlabBlock)SNSBlock.byId("lemon_curd_cake_slab").get(), () -> (Block)SNSBlock.LEMON_CURD_CAKE_BLOCK.get(), SIDE2, BOTTOM2, TOP2);
        this.cakeFence((FenceBlock)SNSBlock.byId("lemon_curd_cake_fence").get(), SIDE2);
        this.cakeFenceGate((FenceGateBlock)SNSBlock.byId("lemon_curd_cake_fence_gate").get(), SIDE2);
        this.cakeWall((WallBlock)SNSBlock.byId("lemon_curd_cake_wall").get(), SIDE2);
        this.cakeButton((ButtonBlock)SNSBlock.byId("lemon_curd_cake_button").get(), SIDE2);
        this.cakePressurePlate((PressurePlateBlock)SNSBlock.byId("lemon_curd_cake_pressure_plate").get(), SIDE2);
        this.blockWithItemSideBotTop(SNSBlock.RASPBERRY_CAKE_BLOCK);
        ResourceLocation SIDE3 = this.modLoc("block/raspberry_cake_block_side");
        ResourceLocation BOTTOM3 = this.modLoc("block/raspberry_cake_block_bottom");
        ResourceLocation TOP3 = this.modLoc("block/raspberry_cake_block_top");
        this.cakeStairs((StairBlock)SNSBlock.byId("raspberry_cake_stairs").get(), SIDE3, BOTTOM3, TOP3);
        this.cakeSlab((SlabBlock)SNSBlock.byId("raspberry_cake_slab").get(), () -> (Block)SNSBlock.RASPBERRY_CAKE_BLOCK.get(), SIDE3, BOTTOM3, TOP3);
        this.cakeFence((FenceBlock)SNSBlock.byId("raspberry_cake_fence").get(), SIDE3);
        this.cakeFenceGate((FenceGateBlock)SNSBlock.byId("raspberry_cake_fence_gate").get(), SIDE3);
        this.cakeWall((WallBlock)SNSBlock.byId("raspberry_cake_wall").get(), SIDE3);
        this.cakeButton((ButtonBlock)SNSBlock.byId("raspberry_cake_button").get(), SIDE3);
        this.cakePressurePlate((PressurePlateBlock)SNSBlock.byId("raspberry_cake_pressure_plate").get(), SIDE3);
        this.blockWithItemSideBotTop(SNSBlock.STRAWBERRY_CAKE_BLOCK);
        ResourceLocation SIDE1 = this.modLoc("block/strawberry_cake_block_side");
        ResourceLocation BOTTOM1 = this.modLoc("block/strawberry_cake_block_bottom");
        ResourceLocation TOP1 = this.modLoc("block/strawberry_cake_block_top");
        this.cakeStairs((StairBlock)SNSBlock.byId("strawberry_cake_stairs").get(), SIDE1, BOTTOM1, TOP1);
        this.cakeSlab((SlabBlock)SNSBlock.byId("strawberry_cake_slab").get(), () -> (Block)SNSBlock.STRAWBERRY_CAKE_BLOCK.get(), SIDE1, BOTTOM1, TOP1);
        this.cakeFence((FenceBlock)SNSBlock.byId("strawberry_cake_fence").get(), SIDE1);
        this.cakeFenceGate((FenceGateBlock)SNSBlock.byId("strawberry_cake_fence_gate").get(), SIDE1);
        this.cakeWall((WallBlock)SNSBlock.byId("strawberry_cake_wall").get(), SIDE1);
        this.cakeButton((ButtonBlock)SNSBlock.byId("strawberry_cake_button").get(), SIDE1);
        this.cakePressurePlate((PressurePlateBlock)SNSBlock.byId("strawberry_cake_pressure_plate").get(), SIDE1);
        this.blockWithItemSideBotTop(SNSBlock.VICTORIA_SPONGE_CAKE_BLOCK);
        ResourceLocation SIDE = this.modLoc("block/victoria_sponge_cake_block_side");
        ResourceLocation BOTTOM = this.modLoc("block/victoria_sponge_cake_block_bottom");
        ResourceLocation TOP = this.modLoc("block/victoria_sponge_cake_block_top");
        this.cakeStairs((StairBlock)SNSBlock.byId("victoria_sponge_cake_stairs").get(), SIDE, BOTTOM, TOP);
        this.cakeSlab((SlabBlock)SNSBlock.byId("victoria_sponge_cake_slab").get(), () -> (Block)SNSBlock.VICTORIA_SPONGE_CAKE_BLOCK.get(), SIDE, BOTTOM, TOP);
        this.cakeFence((FenceBlock)SNSBlock.byId("victoria_sponge_cake_fence").get(), SIDE);
        this.cakeFenceGate((FenceGateBlock)SNSBlock.byId("victoria_sponge_cake_fence_gate").get(), SIDE);
        this.cakeWall((WallBlock)SNSBlock.byId("victoria_sponge_cake_wall").get(), SIDE);
        this.cakeButton((ButtonBlock)SNSBlock.byId("victoria_sponge_cake_button").get(), SIDE);
        this.cakePressurePlate((PressurePlateBlock)SNSBlock.byId("victoria_sponge_cake_pressure_plate").get(), SIDE);
        this.family("candyfloss", "candyfloss_block");
        this.family("candyfloss_blue_raspberry", "candyfloss_blue_raspberry_block");
        this.family("candyfloss_lemon", "candyfloss_lemon_block");
        this.family("candyfloss_strawberry", "candyfloss_strawberry_block");
        this.family("candyfloss_vanilla", "candyfloss_vanilla_block");
        this.family("chocolate", "chocolate_block");
        this.family("chocolate_dark", "chocolate_dark_block");
        this.family("chocolate_white", "chocolate_white_block");
        this.family("chocolate_brick", "chocolate_bricks");
        this.family("chocolate_dark_brick", "chocolate_dark_bricks");
        this.family("chocolate_white_brick", "chocolate_white_bricks");
        this.family("mint_brick", "mint_brick");
        this.family("waffle_brick", "waffle_bricks");
        this.family("humbug_brick", "humbug_brick");
        this.family("peppermint_swirl_brick", "peppermint_swirl_brick");
        this.family("rhubarb_custard_brick", "rhubarb_custard_brick");
        this.family("strawberry_cream_brick", "strawberry_cream_brick");
        this.family("peppermint_swirl_stone", "peppermint_swirl_stone");
        this.family("rhubarb_custard_stone", "rhubarb_custard_stone");
        this.family("strawberry_cream_stone", "strawberry_cream_stone");
        this.family("mint", "mint_block");
        this.family("candy_cane_plank", "candy_cane_planks");
        this.family("chocolate_plank", "chocolate_planks");
        this.family("cinnamon_plank", "cinnamon_planks");
        this.family("crystalised_sugar_plank", "crystalised_sugar_planks");
        this.family("licorice_plank", "licorice_planks");
        this.family("rainbow_strip_plank", "rainbow_strip_planks");
        this.family("waffle", "waffle_block");
        this.family("white_chocolate_coated_waffle", "white_chocolate_coated_waffle_block");
        this.family("chocolate_coated_waffle", "chocolate_coated_waffle_block");
        this.family("dark_chocolate_coated_waffle", "dark_chocolate_coated_waffle_block");
        this.family("strawberry_chocolate_coated_waffle", "strawberry_chocolate_coated_waffle_block");
        this.family("gummy_apple", "gummy_apple_block");
        this.family("gummy_banana", "gummy_banana_block");
        this.family("gummy_blackberry", "gummy_blackberry_block");
        this.family("gummy_blueberry", "gummy_blueberry_block");
        this.family("gummy_raspberry", "gummy_raspberry_block");
        this.family("gummy_strawberry", "gummy_strawberry_block");
        this.family("pretzel", "pretzel_block");
        this.potted("potted_apple_fruit_roll_bush", SNSBlock.POTTED_APPLE_FRUIT_ROLL_BUSH, "apple_fruit_roll_bush");
        this.potted("potted_banana_fruit_roll_bush", SNSBlock.POTTED_BANANA_FRUIT_ROLL_BUSH, "banana_fruit_roll_bush");
        this.potted("potted_blackberry_roll_bush", SNSBlock.POTTED_BLACKBERRY_ROLL_BUSH, "blackberry_roll_bush");
        this.potted("potted_blueberry_roll_bush", SNSBlock.POTTED_BLUEBERRY_ROLL_BUSH, "blueberry_roll_bush");
        this.potted("potted_raspberry_roll_bush", SNSBlock.POTTED_RASPBERRY_ROLL_BUSH, "raspberry_roll_bush");
        this.potted("potted_strawberry_roll_bush", SNSBlock.POTTED_STRAWBERRY_ROLL_BUSH, "strawberry_roll_bush");
        this.potted("potted_candyfloss_bush", SNSBlock.POTTED_CANDYFLOSS_BUSH, "candyfloss_bush");
        this.potted("potted_candyfloss_cosmos", SNSBlock.POTTED_CANDYFLOSS_COSMOS, "candyfloss_cosmos");
        this.potted("potted_candyfloss_cosmos_2", SNSBlock.POTTED_CANDYFLOSS_COSMOS_2, "candyfloss_cosmos_2");
        this.potted("potted_candyfloss_cosmos_3", SNSBlock.POTTED_CANDYFLOSS_COSMOS_3, "candyfloss_cosmos_3");
        this.potted("potted_candyfloss_cosmos_4", SNSBlock.POTTED_CANDYFLOSS_COSMOS_4, "candyfloss_cosmos_4");
        this.potted("potted_candyfloss_cosmos_5", SNSBlock.POTTED_CANDYFLOSS_COSMOS_5, "candyfloss_cosmos_5");
        this.potted("potted_candyfloss_grass", SNSBlock.POTTED_CANDYFLOSS_GRASS, "candyfloss_grass");
        this.potted("potted_candyfloss_grass_short", SNSBlock.POTTED_CANDYFLOSS_GRASS_SHORT, "candyfloss_grass_short");
        this.potted("potted_candyfloss_sapling", SNSBlock.POTTED_CANDYFLOSS_SAPLING, "candyfloss_sapling");
        this.potted("potted_candy_cane_bush", SNSBlock.POTTED_CANDY_CANE_BUSH, "candy_cane_bush");
        this.potted("potted_candy_cane_carnation", SNSBlock.POTTED_CANDY_CANE_CARNATION, "candy_cane_carnation");
        this.potted("potted_candy_cane_flower", SNSBlock.POTTED_CANDY_CANE_FLOWER, "candy_cane_flower");
        this.potted("potted_candy_cane_flower_2", SNSBlock.POTTED_CANDY_CANE_FLOWER_2, "candy_cane_flower_2");
        this.potted("potted_candy_cane_flower_3", SNSBlock.POTTED_CANDY_CANE_FLOWER_3, "candy_cane_flower_3");
        this.potted("potted_candy_cane_flower_4", SNSBlock.POTTED_CANDY_CANE_FLOWER_4, "candy_cane_flower_4");
        this.potted("potted_candy_cane_grass", SNSBlock.POTTED_CANDY_CANE_GRASS, "candy_cane_grass");
        this.potted("potted_candy_cane_grass_long", SNSBlock.POTTED_CANDY_CANE_GRASS_LONG, "candy_cane_grass_long");
        this.potted("potted_candy_cane_sapling", SNSBlock.POTTED_CANDY_CANE_SAPLING, "candy_cane_sapling");
        this.potted("potted_chocolate_grass", SNSBlock.POTTED_CHOCOLATE_GRASS, "chocolate_grass");
        this.potted("potted_chocolate_sapling", SNSBlock.POTTED_CHOCOLATE_SAPLING, "chocolate_sapling");
        this.potted("potted_cinnamon_flower", SNSBlock.POTTED_CINNAMON_FLOWER, "cinnamon_flower");
        this.potted("potted_cinnamon_flower_2", SNSBlock.POTTED_CINNAMON_FLOWER_2, "cinnamon_flower_2");
        this.potted("potted_cinnamon_grass", SNSBlock.POTTED_CINNAMON_GRASS, "cinnamon_grass");
        this.potted("potted_cinnamon_grass_long", SNSBlock.POTTED_CINNAMON_GRASS_LONG, "cinnamon_grass_long");
        this.potted("potted_cinnamon_sapling", SNSBlock.POTTED_CINNAMON_SAPLING, "cinnamon_sapling");
        this.potted("potted_rainbow_strip_flower", SNSBlock.POTTED_RAINBOW_STRIP_FLOWER, "rainbow_strip_flower");
        this.potted("potted_rainbow_strip_flower_2", SNSBlock.POTTED_RAINBOW_STRIP_FLOWER_2, "rainbow_strip_flower_2");
        this.potted("potted_rainbow_strip_grass", SNSBlock.POTTED_RAINBOW_STRIP_GRASS, "rainbow_strip_grass");
        this.potted("potted_rainbow_strip_grass_long", SNSBlock.POTTED_RAINBOW_STRIP_GRASS_LONG, "rainbow_strip_grass_long");
        this.potted("potted_rainbow_strip_sapling", SNSBlock.POTTED_RAINBOW_STRIP_SAPLING, "rainbow_strip_sapling");
        this.potted("potted_mint_bush", SNSBlock.POTTED_MINT_BUSH, "mint_bush");
        this.potted("potted_mint_flower", SNSBlock.POTTED_MINT_FLOWER, "mint_flower");
        this.potted("potted_mint_flower_2", SNSBlock.POTTED_MINT_FLOWER_2, "mint_flower_2");
        this.potted("potted_mint_flower_3", SNSBlock.POTTED_MINT_FLOWER_3, "mint_flower_3");
        this.potted("potted_mint_grass", SNSBlock.POTTED_MINT_GRASS, "mint_grass");
        this.potted("potted_mint_grass_long", SNSBlock.POTTED_MINT_GRASS_LONG, "mint_grass_long");
    }

    private void family(String id, String baseId) {
        Block base = (Block)SNSBlock.byId(baseId).get();
        boolean isCandyCanePlanks = baseId.equals("candy_cane_planks");
        if (isCandyCanePlanks) {
            this.blockWithItemSideBotTop(SNSBlock.byId(baseId));
        } else if (!baseId.endsWith("_grass_block") && !baseId.endsWith("_cake_block")) {
            this.blockWithItem(SNSBlock.byId(baseId));
        }
        this.ifExists(id + "_button", b -> {
            this.buttonBlock((ButtonBlock)b, this.blockTexture(base));
            this.itemFromBlockModel(SNSBlockStateProvider.nameOf(b));
        });
        this.ifExists(id + "_door", b -> {
            String bottom = id + "_door_bottom";
            String top = id + "_door_top";
            this.doorBlockWithRenderType((DoorBlock)b, this.modLoc("block/" + bottom), this.modLoc("block/" + top), "translucent");
        });
        this.ifExists(id + "_fence", b -> this.fenceBlock((FenceBlock)b, this.blockTexture(base)));
        this.ifExists(id + "_fence_gate", b -> {
            this.fenceGateBlock((FenceGateBlock)b, this.blockTexture(base));
            this.blockItem(SNSBlock.byId(id + "_fence_gate"));
        });
        this.ifExists(id + "_pressure_plate", b -> {
            this.pressurePlateBlock((PressurePlateBlock)b, this.blockTexture(base));
            this.blockItem(SNSBlock.byId(id + "_pressure_plate"));
        });
        this.ifExists(id + "_slab", b -> {
            this.slabBlock((SlabBlock)b, this.blockTexture(base), this.blockTexture(base));
            this.blockItem(SNSBlock.byId(id + "_slab"));
        });
        this.ifExists(id + "_stairs", b -> {
            this.stairsBlock((StairBlock)b, this.blockTexture(base));
            this.blockItem(SNSBlock.byId(id + "_stairs"));
        });
        this.ifExists(id + "_trapdoor", b -> {
            this.trapdoorBlockWithRenderType((TrapDoorBlock)b, this.modLoc("block/" + id + "_trapdoor"), true, "translucent");
            this.blockItem(SNSBlock.byId(id + "_trapdoor"), "_bottom");
        });
        this.ifExists(id + "_wall", b -> this.wallBlock((WallBlock)b, this.blockTexture(base)));
    }

    private void ifExists(String id, Consumer<Block> fn) {
        try {
            Block b = (Block)SNSBlock.byId(id).get();
            fn.accept(b);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected static String nameOf(Block b) {
        return Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)b), "Unregistered block").getPath();
    }

    protected static String nameOf(Supplier<? extends Block> s) {
        return SNSBlockStateProvider.nameOf(s.get());
    }

    protected void itemFromBlockModel(String modelName) {
        ((ItemModelBuilder)this.itemModels().getBuilder(modelName)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + modelName)));
    }

    private void blockItem(DeferredBlock<Block> deferredBlock) {
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)new ModelFile.UncheckedModelFile("snsnf:block/" + deferredBlock.getId().getPath()));
    }

    private void blockItem(DeferredBlock<Block> deferredBlock, String appendix) {
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)new ModelFile.UncheckedModelFile("snsnf:block/" + deferredBlock.getId().getPath() + appendix));
    }

    private void blockWithItem(DeferredBlock<Block> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), this.cubeAll((Block)deferredBlock.get()));
    }

    private void blockWithItemSideBotTop(DeferredBlock<Block> deferredBlock) {
        ModelBuilder model = this.models().cubeBottomTop(deferredBlock.getId().getPath(), this.modLoc("block/" + deferredBlock.getId().getPath() + "_side"), this.modLoc("block/" + deferredBlock.getId().getPath() + "_bottom"), this.modLoc("block/" + deferredBlock.getId().getPath() + "_top"));
        this.simpleBlock((Block)deferredBlock.get(), (ModelFile)model);
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)model);
    }

    private void simpleCross(DeferredBlock<? extends Block> entry) {
        this.simpleBlock((Block)entry.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture((Block)entry.get()).getPath(), this.blockTexture((Block)entry.get()))).renderType("cutout"));
    }

    private void ladderBlock(DeferredBlock<? extends Block> entry, String textureName) {
        Block block = (Block)entry.get();
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.blockName(block), this.mcLoc("block/ladder"))).texture("texture", this.modLoc("block/" + textureName))).renderType("cutout");
        this.horizontalBlock(block, (ModelFile)model);
        this.simpleBlockItem(block, (ModelFile)model);
    }

    private void potted(String modelName, DeferredBlock<? extends Block> potted, String plantId) {
        this.simpleBlock((Block)potted.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture(modelName, ResourceLocation.parse((String)"flower_pot_cross"), "plant", this.modLoc("block/" + plantId))).renderType("cutout"));
    }

    public void rotatedPillarBlockWithTopBottom(Block block, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        ModelBuilder yModel = this.models().cubeBottomTop(this.blockName(block), side, bottom, top);
        ModelBuilder xzModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.blockName(block) + "_horizontal", this.mcLoc("block/cube_column_horizontal"))).texture("end", top)).texture("side", side);
        this.getVariantBuilder(block).forAllStates(arg_0 -> SNSBlockStateProvider.lambda$rotatedPillarBlockWithTopBottom$17((ModelFile)yModel, (ModelFile)xzModel, arg_0));
    }

    private void leavesBlock(DeferredBlock<Block> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture(BuiltInRegistries.BLOCK.getKey((Object)((Block)deferredBlock.get())).getPath(), ResourceLocation.parse((String)"minecraft:block/leaves"), "all", this.blockTexture((Block)deferredBlock.get()))).renderType("cutout"));
    }

    private void saplingBlock(DeferredBlock<Block> deferredBlock) {
        this.simpleBlock((Block)deferredBlock.get(), (ModelFile)((BlockModelBuilder)this.models().cross(BuiltInRegistries.BLOCK.getKey((Object)((Block)deferredBlock.get())).getPath(), this.blockTexture((Block)deferredBlock.get()))).renderType("cutout"));
    }

    private void teddyBlock(DeferredBlock<? extends Block> block, String modelName) {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/" + modelName));
        this.horizontalBlock((Block)block.get(), (ModelFile)model);
        this.simpleBlockItem((Block)block.get(), (ModelFile)model);
    }

    private void torchWithWall(String baseName, TorchBlock torch, WallTorchBlock wall, String textureName) {
        ModelBuilder torchModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName, this.mcLoc("block/template_torch"))).texture("torch", this.modLoc("block/" + textureName))).renderType("cutout");
        ModelBuilder wallModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_wall", this.mcLoc("block/template_torch_wall"))).texture("torch", this.modLoc("block/" + textureName))).renderType("cutout");
        this.simpleBlock((Block)torch, (ModelFile)torchModel);
        this.getVariantBuilder((Block)wall).forAllStates(arg_0 -> SNSBlockStateProvider.lambda$torchWithWall$18((ModelFile)wallModel, arg_0));
        this.simpleBlockItem((Block)torch, (ModelFile)torchModel);
    }

    private void glassBlock(DeferredBlock<? extends Block> block, String textureName) {
        String id = SNSBlockStateProvider.idPath((Block)block.get());
        ModelBuilder model = ((BlockModelBuilder)this.models().cubeAll(id, this.modLoc("block/" + textureName))).renderType("translucent");
        this.simpleBlock((Block)block.get(), (ModelFile)model);
        this.simpleBlockItem((Block)block.get(), (ModelFile)model);
    }

    private static String idPath(Block b) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)b);
        return Objects.requireNonNull(id, "Unregistered block").getPath();
    }

    private String blockName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }

    private void chestWithParticle(Block block, ResourceLocation particle) {
        String name = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelFile.UncheckedModelFile parent = new ModelFile.UncheckedModelFile("builtin/entity");
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).parent((ModelFile)parent)).texture("particle", particle);
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
    }

    private void fluidBlock(LiquidBlock block) {
        ModelFile.ExistingModelFile fluidModel = this.models().getExistingFile(this.modLoc("block/fluid"));
        this.getVariantBuilder((Block)block).forAllStates(arg_0 -> SNSBlockStateProvider.lambda$fluidBlock$19((ModelFile)fluidModel, arg_0));
    }

    protected void cakeStairs(StairBlock stairs, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        String n = SNSBlockStateProvider.nameOf((Block)stairs);
        ModelBuilder base = this.models().stairs(n, side, bottom, top);
        ModelBuilder inner = this.models().stairsInner(n + "_inner", side, bottom, top);
        ModelBuilder outer = this.models().stairsOuter(n + "_outer", side, bottom, top);
        this.stairsBlock(stairs, (ModelFile)base, (ModelFile)inner, (ModelFile)outer);
        this.itemFromBlockModel(n);
    }

    protected void cakeSlab(SlabBlock slab, Supplier<? extends Block> fullBlock, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        String n = SNSBlockStateProvider.nameOf((Block)slab);
        ModelBuilder slabM = this.models().slab(n, side, bottom, top);
        ModelBuilder slabTop = this.models().slabTop(n + "_top", side, bottom, top);
        String fullName = SNSBlockStateProvider.nameOf(fullBlock);
        ModelFile.ExistingModelFile full = this.models().getExistingFile(this.modLoc("block/" + fullName));
        this.slabBlock(slab, (ModelFile)slabM, (ModelFile)slabTop, (ModelFile)full);
        this.itemFromBlockModel(n);
    }

    protected void cakeFence(FenceBlock fence, ResourceLocation texture) {
        this.fenceBlock(fence, texture);
        String n = SNSBlockStateProvider.nameOf((Block)fence);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(n)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("block/fence_inventory")))).texture("texture", texture);
    }

    protected void cakeFenceGate(FenceGateBlock gate, ResourceLocation texture) {
        this.fenceGateBlock(gate, texture);
        this.itemFromBlockModel(SNSBlockStateProvider.nameOf((Block)gate));
    }

    protected void cakeWall(WallBlock wall, ResourceLocation texture) {
        this.wallBlock(wall, texture);
        String n = SNSBlockStateProvider.nameOf((Block)wall);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(n)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("block/wall_inventory")))).texture("wall", texture);
    }

    protected void cakeButton(ButtonBlock button, ResourceLocation texture) {
        this.buttonBlock(button, texture);
        this.itemFromBlockModel(SNSBlockStateProvider.nameOf((Block)button));
    }

    protected void cakePressurePlate(PressurePlateBlock plate, ResourceLocation texture) {
        this.pressurePlateBlock(plate, texture);
        this.itemFromBlockModel(SNSBlockStateProvider.nameOf((Block)plate));
    }

    private void furnaceBlock(Block block, ResourceLocation side, ResourceLocation top, ResourceLocation front, ResourceLocation frontLit) {
        String name = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder off = this.models().orientable(name, side, front, top);
        ModelBuilder on = this.models().orientable(name + "_lit", side, frontLit, top);
        this.getVariantBuilder(block).forAllStates(arg_0 -> SNSBlockStateProvider.lambda$furnaceBlock$20((ModelFile)on, (ModelFile)off, arg_0));
        this.simpleBlockItem(block, (ModelFile)off);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$furnaceBlock$20(ModelFile on, ModelFile off, BlockState state) {
        Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        boolean lit = (Boolean)state.getValue((Property)BlockStateProperties.LIT);
        int yRot = ((int)dir.toYRot() + 180) % 360;
        return ConfiguredModel.builder().modelFile(lit ? on : off).rotationY(yRot).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$fluidBlock$19(ModelFile fluidModel, BlockState state) {
        return ConfiguredModel.builder().modelFile(fluidModel).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$torchWithWall$18(ModelFile wallModel, BlockState state) {
        Direction f = (Direction)state.getValue((Property)WallTorchBlock.FACING);
        int y = switch (f) {
            case Direction.SOUTH -> 0;
            case Direction.WEST -> 90;
            case Direction.NORTH -> 180;
            case Direction.EAST -> 270;
            default -> 0;
        };
        y = (y + 90) % 360;
        return ConfiguredModel.builder().modelFile(wallModel).rotationY(y).uvLock(true).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$rotatedPillarBlockWithTopBottom$17(ModelFile yModel, ModelFile xzModel, BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS);
        if (axis == Direction.Axis.Y) {
            return ConfiguredModel.builder().modelFile(yModel).build();
        }
        return ConfiguredModel.builder().modelFile(xzModel).rotationX(90).rotationY(axis == Direction.Axis.X ? 90 : 0).build();
    }
}

