/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.xstarlotte.snsnf.block.SNSBlock;
import net.xstarlotte.snsnf.entity.SNSEntity;
import net.xstarlotte.snsnf.item.SNSItem;
import net.xstarlotte.snsnf.item.custom.SNSFishBuckets;

public class SNSLangEn
extends LanguageProvider {
    public SNSLangEn(PackOutput output) {
        super(output, "snsnf", "en_us");
    }

    private boolean exists(String id) {
        try {
            SNSBlock.byId(id);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void addBlockIfExists(String id, String name) {
        if (this.exists(id)) {
            this.addBlock(id, name);
        }
    }

    private void addBlock(String path, String displayName) {
        try {
            this.add((Block)SNSBlock.byId(path).get(), displayName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void addFamily(String partsBase, String baseBlockPath, String displayBase, String blockDisplay, Parts p) {
        this.addBlockIfExists(baseBlockPath, blockDisplay);
        if (p.stairs) {
            this.addBlockIfExists(partsBase + "_stairs", displayBase + " Stairs");
        }
        if (p.slab) {
            this.addBlockIfExists(partsBase + "_slab", displayBase + " Slab");
        }
        if (p.wall) {
            this.addBlockIfExists(partsBase + "_wall", displayBase + " Wall");
        }
        if (p.fence) {
            this.addBlockIfExists(partsBase + "_fence", displayBase + " Fence");
        }
        if (p.fenceGate) {
            this.addBlockIfExists(partsBase + "_fence_gate", displayBase + " Fence Gate");
        }
        if (p.door) {
            this.addBlockIfExists(partsBase + "_door", displayBase + " Door");
        }
        if (p.trapdoor) {
            this.addBlockIfExists(partsBase + "_trapdoor", displayBase + " Trapdoor");
        }
        if (p.button) {
            this.addBlockIfExists(partsBase + "_button", displayBase + " Button");
        }
        if (p.pressurePlate) {
            this.addBlockIfExists(partsBase + "_pressure_plate", displayBase + " Pressure Plate");
        }
    }

    private void addFamily(String partsBase, String displayBase, Parts p) {
        this.addFamily(partsBase, partsBase + "_block", displayBase, displayBase + " Block", p);
    }

    protected void addTranslations() {
        this.addFamily("candyfloss", "Candyfloss", Parts.woodLike());
        this.addFamily("candyfloss_blue_raspberry", "Blue Raspberry Candyfloss", Parts.woodLike());
        this.addFamily("candyfloss_lemon", "Lemon Candyfloss", Parts.woodLike());
        this.addFamily("candyfloss_strawberry", "Strawberry Candyfloss", Parts.woodLike());
        this.addFamily("candyfloss_vanilla", "Vanilla Candyfloss", Parts.woodLike());
        this.addFamily("chocolate", "Chocolate", Parts.stoneLike());
        this.addFamily("chocolate_dark", "Dark Chocolate", Parts.stoneLike());
        this.addFamily("chocolate_white", "White Chocolate", Parts.stoneLike());
        this.addFamily("mint", "mint_block", "Mint", "Mint Block", Parts.stoneLike());
        this.addFamily("chocolate_brick", "chocolate_bricks", "Chocolate Brick", "Chocolate Bricks", Parts.stoneLike());
        this.addFamily("chocolate_dark_brick", "chocolate_dark_bricks", "Dark Chocolate Brick", "Dark Chocolate Bricks", Parts.stoneLike());
        this.addFamily("chocolate_white_brick", "chocolate_white_bricks", "White Chocolate Brick", "White Chocolate Bricks", Parts.stoneLike());
        this.addFamily("waffle_brick", "waffle_bricks", "Waffle Brick", "Waffle Bricks", Parts.stoneLike());
        this.addFamily("mint_brick", "mint_brick", "Mint Brick", "Mint Bricks", Parts.stoneLike());
        this.addFamily("humbug_brick", "humbug_brick", "Humbug Brick", "Humbug Bricks", Parts.stoneLike());
        this.addFamily("peppermint_swirl_brick", "peppermint_swirl_brick", "Peppermint Swirl Brick", "Peppermint Swirl Bricks", Parts.stoneLike());
        this.addFamily("rhubarb_custard_brick", "rhubarb_custard_brick", "Rhubarb Custard Brick", "Rhubarb Custard Bricks", Parts.stoneLike());
        this.addFamily("strawberry_cream_brick", "strawberry_cream_brick", "Strawberry Cream Brick", "Strawberry Cream Bricks", Parts.stoneLike());
        this.addFamily("peppermint_swirl_stone", "peppermint_swirl_stone", "Peppermint Swirl Stone", "Peppermint Swirl Stone", Parts.stoneLike());
        this.addFamily("rhubarb_custard_stone", "rhubarb_custard_stone", "Rhubarb & Custard Stone", "Rhubarb & Custard Stone", Parts.stoneLike());
        this.addFamily("strawberry_cream_stone", "strawberry_cream_stone", "Strawberry & Cream Stone", "Strawberry & Cream Stone", Parts.stoneLike());
        this.addFamily("candy_cane_plank", "candy_cane_planks", "Candy Cane Plank", "Candy Cane Planks", Parts.woodLike());
        this.addFamily("chocolate_plank", "chocolate_planks", "Chocolate Plank", "Chocolate Planks", Parts.woodLike());
        this.addFamily("cinnamon_plank", "cinnamon_planks", "Cinnamon Plank", "Cinnamon Planks", Parts.woodLike());
        this.addFamily("crystalised_sugar_plank", "crystalised_sugar_planks", "Crystalised Sugar Plank", "Crystalised Sugar Planks", Parts.woodLike());
        this.addFamily("licorice_plank", "licorice_planks", "Licorice Plank", "Licorice Planks", Parts.woodLike());
        this.addFamily("rainbow_strip_plank", "rainbow_strip_planks", "Rainbow Strip Plank", "Rainbow Strip Planks", Parts.woodLike());
        this.addFamily("waffle", "waffle_block", "Waffle", "Waffle Block", Parts.woodLike());
        this.addFamily("white_chocolate_coated_waffle", "white_chocolate_coated_waffle_block", "White Chocolate Coated Waffle", "White Chocolate Coated Waffle Block", Parts.woodLike());
        this.addFamily("chocolate_coated_waffle", "chocolate_coated_waffle_block", "Milk Chocolate Coated Waffle", "Milk Chocolate Coated Waffle Block", Parts.woodLike());
        this.addFamily("dark_chocolate_coated_waffle", "dark_chocolate_coated_waffle_block", "Dark Chocolate Coated Waffle", "Dark Chocolate Coated Waffle Block", Parts.woodLike());
        this.addFamily("strawberry_chocolate_coated_waffle", "strawberry_chocolate_coated_waffle_block", "Strawberry Coated Waffle", "Strawberry Coated Waffle Block", Parts.woodLike());
        this.addFamily("gummy_apple", "Gummy Apple", Parts.woodLike());
        this.addFamily("gummy_banana", "Gummy Banana", Parts.woodLike());
        this.addFamily("gummy_blackberry", "Gummy Blackberry", Parts.woodLike());
        this.addFamily("gummy_blueberry", "Gummy Blueberry", Parts.woodLike());
        this.addFamily("gummy_raspberry", "Gummy Raspberry", Parts.woodLike());
        this.addFamily("gummy_strawberry", "Gummy Strawberry", Parts.woodLike());
        this.addFamily("carrot_cake", "carrot_cake_block", "Carrot Cake", "Carrot Cake Block", Parts.victoria());
        this.addFamily("chocolate_cherry_cake", "chocolate_cherry_cake_block", "Chocolate Cherry Cake", "Chocolate Cherry Cake Block", Parts.victoria());
        this.addFamily("chocolate_mint_cake", "chocolate_mint_cake_block", "Chocolate Mint Cake", "Chocolate Mint Cake Block", Parts.victoria());
        this.addFamily("chocolate_orange_cake", "chocolate_orange_cake_block", "Chocolate Orange Cake", "Chocolate Orange Cake Block", Parts.victoria());
        this.addFamily("lemon_curd_cake", "lemon_curd_cake_block", "Lemon Curd Cake", "Lemon Curd Cake Block", Parts.victoria());
        this.addFamily("raspberry_cake", "raspberry_cake_block", "Raspberry Cake", "Raspberry Cake Block", Parts.victoria());
        this.addFamily("strawberry_cake", "strawberry_cake_block", "Strawberry Cake", "Strawberry Cake Block", Parts.victoria());
        this.addFamily("victoria_sponge_cake", "victoria_sponge_cake_block", "Victoria Sponge Cake", "Victoria Sponge Cake Block", Parts.victoria());
        this.addFamily("pretzel", "pretzel_block", "Pretzel", "Pretzel Block", Parts.stoneLike());
        this.add((Block)SNSBlock.BOURBON_CARPET.get(), "Bourbon Carpet");
        this.add((Block)SNSBlock.CUSTARD_CREAM_CARPET.get(), "Custard Cream Carpet");
        this.add((Block)SNSBlock.PEPPERMINT_SWIRL_CARPET.get(), "Peppermint Swirl Carpet");
        this.add((Block)SNSBlock.BLACKBERRY_SORBET_SAND.get(), "Blackberry Sorbet Sand");
        this.add((Block)SNSBlock.BLUEBERRY_SORBET_SAND.get(), "Blueberry Sorbet Sand");
        this.add((Block)SNSBlock.LEMON_SORBET_SAND.get(), "Lemon Sorbet Sand");
        this.add((Block)SNSBlock.ORANGE_SORBET_SAND.get(), "Orange Sorbet Sand");
        this.add((Block)SNSBlock.PINEAPPLE_SORBET_SAND.get(), "Pineapple Sorbet Sand");
        this.add((Block)SNSBlock.RASPBERRY_SORBET_SAND.get(), "Raspberry Sorbet Sand");
        this.add((Block)SNSBlock.STRAWBERRY_SORBET_SAND.get(), "Strawberry Sorbet Sand");
        this.add((Block)SNSBlock.SPRINKLES_SAND_PINK.get(), "Pink Sprinkle Sand");
        this.add((Block)SNSBlock.SPRINKLES_SAND_ORANGE.get(), "Orange Sprinkle Sand");
        this.add((Block)SNSBlock.CRYSTALISED_SUGAR_GLASS.get(), "Crystalised Sugar Glass");
        this.add((Block)SNSBlock.CANDY_CANE_LOG.get(), "Candy Cane Log");
        this.add((Block)SNSBlock.CANDY_CANE_WOOD.get(), "Candy Cane Wood");
        this.add((Block)SNSBlock.STRIPPED_CANDY_CANE_LOG.get(), "Stripped Candy Cane Log");
        this.add((Block)SNSBlock.STRIPPED_CANDY_CANE_WOOD.get(), "Stripped Candy Cane Wood");
        this.add((Block)SNSBlock.CHOCOLATE_LOG.get(), "Chocolate Log");
        this.add((Block)SNSBlock.CHOCOLATE_WOOD.get(), "Chocolate Wood");
        this.add((Block)SNSBlock.STRIPPED_CHOCOLATE_LOG.get(), "Stripped Chocolate Log");
        this.add((Block)SNSBlock.STRIPPED_CHOCOLATE_WOOD.get(), "Stripped Chocolate Wood");
        this.add((Block)SNSBlock.CINNAMON_LOG.get(), "Cinnamon Log");
        this.add((Block)SNSBlock.CINNAMON_WOOD.get(), "Cinnamon Wood");
        this.add((Block)SNSBlock.STRIPPED_CINNAMON_LOG.get(), "Stripped Cinnamon Log");
        this.add((Block)SNSBlock.STRIPPED_CINNAMON_WOOD.get(), "Stripped Cinnamon Wood");
        this.add((Block)SNSBlock.LICORICE_LOG.get(), "Licorice Log");
        this.add((Block)SNSBlock.LICORICE_WOOD.get(), "Licorice Wood");
        this.add((Block)SNSBlock.STRIPPED_LICORICE_LOG.get(), "Stripped Licorice Log");
        this.add((Block)SNSBlock.STRIPPED_LICORICE_WOOD.get(), "Stripped Licorice Wood");
        this.add((Block)SNSBlock.CRYSTALISED_SUGAR_LOG.get(), "Crystalised Sugar Log");
        this.add((Block)SNSBlock.CRYSTALISED_SUGAR_WOOD.get(), "Crystalised Sugar Wood");
        this.add((Block)SNSBlock.STRIPPED_CRYSTALISED_SUGAR_LOG.get(), "Stripped Crystalised Sugar Log");
        this.add((Block)SNSBlock.STRIPPED_CRYSTALISED_SUGAR_WOOD.get(), "Stripped Crystalised Sugar Wood");
        this.add((Block)SNSBlock.RAINBOW_STRIP_LOG.get(), "Rainbow Strip Log");
        this.add((Block)SNSBlock.RAINBOW_STRIP_WOOD.get(), "Rainbow Strip Wood");
        this.add((Block)SNSBlock.STRIPPED_RAINBOW_STRIP_LOG.get(), "Stripped Rainbow Strip Log");
        this.add((Block)SNSBlock.STRIPPED_RAINBOW_STRIP_WOOD.get(), "Stripped Rainbow Strip Wood");
        this.add((Block)SNSBlock.CANDY_CANE_LEAVES.get(), "Candy Cane Leaves");
        this.add((Block)SNSBlock.CANDYFLOSS_LEAVES.get(), "Candyfloss Leaves");
        this.add((Block)SNSBlock.CANDYFLOSS_BLUE_RASPBERRY_LEAVES.get(), "Blue Raspberry Candyfloss Leaves");
        this.add((Block)SNSBlock.CANDYFLOSS_LEMON_LEAVES.get(), "Lemon Candyfloss Leaves");
        this.add((Block)SNSBlock.CANDYFLOSS_STRAWBERRY_LEAVES.get(), "Strawberry Candyfloss Leaves");
        this.add((Block)SNSBlock.CANDYFLOSS_VANILLA_LEAVES.get(), "Vanilla Candyfloss Leaves");
        this.add((Block)SNSBlock.CHOCOLATE_LEAVES.get(), "Chocolate Leaves");
        this.add((Block)SNSBlock.CINNAMON_LEAVES.get(), "Cinnamon Leaves");
        this.add((Block)SNSBlock.RAINBOW_STRIP_LEAVES.get(), "Rainbow Strip Leaves");
        this.add((Block)SNSBlock.CANDY_CANE_GRASS_BLOCK.get(), "Candy Cane Grass Block");
        this.add((Block)SNSBlock.SUGAR_DIRT_BLOCK.get(), "Sugar Dirt");
        this.add((Block)SNSBlock.CINNAMON_DIRT_BLOCK.get(), "Cinnamon Dirt");
        this.add((Block)SNSBlock.CINNAMON_GRASS_BLOCK.get(), "Cinnamon Grass Block");
        this.add((Block)SNSBlock.COCOA_DIRT_BLOCK.get(), "Cocoa Dirt");
        this.add((Block)SNSBlock.COCOA_DARK_DIRT_BLOCK.get(), "Dark Cocoa Dirt");
        this.add((Block)SNSBlock.COCOA_WHITE_DIRT_BLOCK.get(), "White Cocoa Dirt");
        this.add((Block)SNSBlock.MINT_DIRT_BLOCK.get(), "Mint Dirt");
        this.add((Block)SNSBlock.MINT_GRASS_BLOCK.get(), "Mint Grass Block");
        this.add((Block)SNSBlock.RAINBOW_STRIP_GRASS_BLOCK.get(), "Rainbow Strip Grass Block");
        this.add((Block)SNSBlock.APPLE_FRUIT_ROLL_GRASS_BLOCK.get(), "Apple Fruit Roll Grass Block");
        this.add((Block)SNSBlock.BANANA_FRUIT_ROLL_GRASS_BLOCK.get(), "Banana Fruit Roll Grass Block");
        this.add((Block)SNSBlock.BLACKBERRY_ROLL_GRASS_BLOCK.get(), "Blackberry Roll Grass Block");
        this.add((Block)SNSBlock.BLUEBERRY_ROLL_GRASS_BLOCK.get(), "Blueberry Roll Grass Block");
        this.add((Block)SNSBlock.RASPBERRY_ROLL_GRASS_BLOCK.get(), "Raspberry Roll Grass Block");
        this.add((Block)SNSBlock.STRAWBERRY_ROLL_GRASS_BLOCK.get(), "Strawberry Roll Grass Block");
        this.add((Block)SNSBlock.PEPPERMINT_SWIRL_STONE_COAL_ORE.get(), "Peppermint Swirl Stone Coal Ore");
        this.add((Block)SNSBlock.CANDY_CANE_FURNACE.get(), "Candy Cane Furnace");
        this.add((Block)SNSBlock.CHOCOLATE_FURNACE.get(), "Chocolate Furnace");
        this.add((Block)SNSBlock.CRYSTALISED_SUGAR_FURNACE.get(), "Crystalised Sugar Furnace");
        this.add("container.snsnf.candy_cane_furnace", "Candy Cane Furnace");
        this.add("container.snsnf.chocolate_furnace", "Chocolate Furnace");
        this.add("container.snsnf.crystalised_sugar_furnace", "Crystalised Sugar Furnace");
        this.add((Block)SNSBlock.CANDY_CANE_LADDER.get(), "Candy Cane Ladder");
        this.add((Block)SNSBlock.CHOCOLATE_LADDER.get(), "Chocolate Ladder");
        this.add((Block)SNSBlock.CINNAMON_LADDER.get(), "Cinnamon Ladder");
        this.add((Block)SNSBlock.RAINBOW_STRIP_LADDER.get(), "Rainbow Strip Ladder");
        this.add((Block)SNSBlock.WAFFLE_LADDER.get(), "Waffle Ladder");
        this.add((Block)SNSBlock.BLACKBERRY_LANTERN.get(), "Blackberry Lantern");
        this.add((Block)SNSBlock.BLUEBERRY_LANTERN.get(), "Blueberry Lantern");
        this.add((Block)SNSBlock.RASPBERRY_LANTERN.get(), "Raspberry Lantern");
        this.add((Block)SNSBlock.STRAWBERRY_LANTERN.get(), "Strawberry Lantern");
        this.add((Block)SNSBlock.CANDYFLOSS_LANTERN.get(), "Candyfloss Lantern");
        this.add((Block)SNSBlock.CANDY_CANE_LANTERN.get(), "Candy Cane Lantern");
        this.add((Block)SNSBlock.BLACKBERRY_LOLLIPOP_LANTERN.get(), "Blackberry Lollipop Lantern");
        this.add((Block)SNSBlock.BLUEBERRY_LOLLIPOP_LANTERN.get(), "Blueberry Lollipop Lantern");
        this.add((Block)SNSBlock.RASPBERRY_LOLLIPOP_LANTERN.get(), "Raspberry Lollipop Lantern");
        this.add((Block)SNSBlock.STRAWBERRY_LOLLIPOP_LANTERN.get(), "Strawberry Lollipop Lantern");
        this.add((Block)SNSBlock.ICE_CREAM_LANTERN.get(), "Ice Cream Lantern");
        this.add((Block)SNSBlock.CANDY_CANE_BED.get(), "Candy Cane Bed");
        this.add((Block)SNSBlock.CHOCOLATE_BED.get(), "Chocolate Bed");
        this.add((Block)SNSBlock.WAFFLE_BED.get(), "Waffle Bed");
        this.add((Block)SNSBlock.WAFFLE_CHEST.get(), "Waffle Chest");
        this.add("container.snsnf.waffle_chest", "Waffle Chest");
        this.add((Block)SNSBlock.CANDY_CANE_CAT_TEDDY.get(), "Candy Cane Cat Teddy");
        this.add((Block)SNSBlock.CINNADILE_TEDDY.get(), "Cinnadile Teddy");
        this.add((Block)SNSBlock.MINT_MINK_TEDDY.get(), "Mink Teddy");
        this.add((Block)SNSBlock.MYNX_TEDDY.get(), "Mynx Teddy");
        this.add((Block)SNSBlock.CANDY_CANE_TORCH.get(), "Candy Cane Torch");
        this.add((Block)SNSBlock.CHOCOLATE_TORCH.get(), "Chocolate Torch");
        this.add((Block)SNSBlock.CINNAMON_TORCH.get(), "Cinnamon Torch");
        this.add((Block)SNSBlock.RAINBOW_STRIP_TORCH.get(), "Rainbow Strip Torch");
        this.add((Block)SNSBlock.CRYSTALISED_SUGAR_TORCH.get(), "Crystalised Sugar Torch");
        this.add((Block)SNSBlock.WAFFLE_TORCH.get(), "Waffle Torch");
        this.add((Block)SNSBlock.APPLE_FRUIT_ROLL_BUSH.get(), "Apple Fruit Roll Bush");
        this.add((Block)SNSBlock.BANANA_FRUIT_ROLL_BUSH.get(), "Banana Fruit Roll Bush");
        this.add((Block)SNSBlock.BLACKBERRY_ROLL_BUSH.get(), "Blackberry Roll Bush");
        this.add((Block)SNSBlock.BLUEBERRY_ROLL_BUSH.get(), "Blueberry Roll Bush");
        this.add((Block)SNSBlock.RASPBERRY_ROLL_BUSH.get(), "Raspberry Roll Bush");
        this.add((Block)SNSBlock.STRAWBERRY_ROLL_BUSH.get(), "Strawberry Roll Bush");
        this.add((Block)SNSBlock.CANDYFLOSS_BUSH.get(), "Candyfloss Bush");
        this.add((Block)SNSBlock.CANDYFLOSS_COSMOS.get(), "Candyfloss Cosmos");
        this.add((Block)SNSBlock.CANDYFLOSS_COSMOS_2.get(), "Blue Raspberry Candyfloss Cosmos");
        this.add((Block)SNSBlock.CANDYFLOSS_COSMOS_3.get(), "Vanilla Candyfloss Cosmos");
        this.add((Block)SNSBlock.CANDYFLOSS_COSMOS_4.get(), "Strawberry Candyfloss Cosmos");
        this.add((Block)SNSBlock.CANDYFLOSS_COSMOS_5.get(), "Lemon Candyfloss Cosmos");
        this.add((Block)SNSBlock.CANDYFLOSS_GRASS.get(), "Candyfloss Grass");
        this.add((Block)SNSBlock.CANDYFLOSS_GRASS_SHORT.get(), "Short Candyfloss Grass");
        this.add((Block)SNSBlock.CANDYFLOSS_SAPLING.get(), "Candyfloss Sapling");
        this.add((Block)SNSBlock.CANDY_CANE_BUSH.get(), "Candy Cane Bush");
        this.add((Block)SNSBlock.CANDY_CANE_CARNATION.get(), "Candy Cane Carnation");
        this.add((Block)SNSBlock.CANDY_CANE_FLOWER.get(), "Candy Cane Flower");
        this.add((Block)SNSBlock.CANDY_CANE_FLOWER_2.get(), "Candy Cane Flower");
        this.add((Block)SNSBlock.CANDY_CANE_FLOWER_3.get(), "Candy Cane Flower");
        this.add((Block)SNSBlock.CANDY_CANE_FLOWER_4.get(), "Candy Cane Flower");
        this.add((Block)SNSBlock.CANDY_CANE_GRASS.get(), "Candy Cane Grass");
        this.add((Block)SNSBlock.CANDY_CANE_GRASS_LONG.get(), "Long Candy Cane Grass");
        this.add((Block)SNSBlock.CANDY_CANE_SAPLING.get(), "Candy Cane Sapling");
        this.add((Block)SNSBlock.CHOCOLATE_GRASS.get(), "Chocolate Grass");
        this.add((Block)SNSBlock.CHOCOLATE_SAPLING.get(), "Chocolate Sapling");
        this.add((Block)SNSBlock.CINNAMON_FLOWER.get(), "Cinnamon Flower");
        this.add((Block)SNSBlock.CINNAMON_FLOWER_2.get(), "Cinnamon Flower");
        this.add((Block)SNSBlock.CINNAMON_GRASS.get(), "Cinnamon Grass");
        this.add((Block)SNSBlock.CINNAMON_GRASS_LONG.get(), "Long Cinnamon Grass");
        this.add((Block)SNSBlock.CINNAMON_SAPLING.get(), "Cinnamon Sapling");
        this.add((Block)SNSBlock.MINT_BUSH.get(), "Mint Bush");
        this.add((Block)SNSBlock.MINT_FLOWER.get(), "Mint Flower");
        this.add((Block)SNSBlock.MINT_FLOWER_2.get(), "Mint Tulip");
        this.add((Block)SNSBlock.MINT_FLOWER_3.get(), "Mint Peony");
        this.add((Block)SNSBlock.MINT_GRASS.get(), "Mint Grass");
        this.add((Block)SNSBlock.MINT_GRASS_LONG.get(), "Long Mint Grass");
        this.add((Block)SNSBlock.RAINBOW_STRIP_FLOWER.get(), "Rainbow Strip Flower");
        this.add((Block)SNSBlock.RAINBOW_STRIP_FLOWER_2.get(), "Rainbow Strip Flower");
        this.add((Block)SNSBlock.RAINBOW_STRIP_GRASS.get(), "Rainbow Strip Grass");
        this.add((Block)SNSBlock.RAINBOW_STRIP_GRASS_LONG.get(), "Long Rainbow Strip Grass");
        this.add((Block)SNSBlock.RAINBOW_STRIP_SAPLING.get(), "Rainbow Strip Sapling");
        this.add(SNSEntity.BLACKBOARRY.get(), "Blackboarry");
        this.add((Item)SNSItem.BLACKBOARRY_SPAWN_EGG.get(), "Blackboarry Egg");
        this.add(SNSEntity.BLUEBOARRY.get(), "Blueboarry");
        this.add((Item)SNSItem.BLUEBOARRY_SPAWN_EGG.get(), "Blueboarry Egg");
        this.add(SNSEntity.JAMSTER.get(), "Jamster");
        this.add((Item)SNSItem.JAMSTER_SPAWN_EGG.get(), "Jamster Egg");
        this.add(SNSEntity.RASPBOARRY.get(), "Raspboarry");
        this.add((Item)SNSItem.RASPBOARRY_SPAWN_EGG.get(), "Raspboarry Egg");
        this.add(SNSEntity.STRAWBOARRY.get(), "Strawboarry");
        this.add((Item)SNSItem.STRAWBOARRY_SPAWN_EGG.get(), "Strawboarry Egg");
        this.add(SNSEntity.ANGEL_CAKE_FISH.get(), "Angel Cake Fish");
        this.add((Item)SNSItem.ANGEL_CAKE_FISH_SPAWN_EGG.get(), "Angel Cake Fish Egg");
        this.add(SNSEntity.CAKE_RABBIT.get(), "Cake Rabbit");
        this.add((Item)SNSItem.CAKE_RABBIT_SPAWN_EGG.get(), "Cake Rabbit Egg");
        this.add(SNSEntity.CHEESECAKE_MOUSE.get(), "Cheesecake Mouse");
        this.add((Item)SNSItem.CHEESECAKE_MOUSE_SPAWN_EGG.get(), "Cheesecake Mouse Egg");
        this.add(SNSEntity.ECLAIR_DOG.get(), "Eclair Dog");
        this.add((Item)SNSItem.ECLAIR_DOG_SPAWN_EGG.get(), "Eclair Dog Egg");
        this.add(SNSEntity.PRETZELFLY.get(), "Pretzelfly");
        this.add((Item)SNSItem.PRETZELFLY_SPAWN_EGG.get(), "Pretzelfly Egg");
        this.add(SNSEntity.SQUIRROLL.get(), "Squirroll");
        this.add((Item)SNSItem.SQUIRROLL_SPAWN_EGG.get(), "Squirroll Egg");
        this.add(SNSEntity.BUNANA.get(), "Bunana");
        this.add((Item)SNSItem.BUNANA_SPAWN_EGG.get(), "Bunana Egg");
        this.add(SNSEntity.DUCKANA.get(), "Duckana");
        this.add((Item)SNSItem.DUCKANA_SPAWN_EGG.get(), "Duckana Egg");
        this.add(SNSEntity.FRUIT_ELF.get(), "Fruit Elf");
        this.add((Item)SNSItem.FRUIT_ELF_SPAWN_EGG.get(), "Fruit Elf Egg");
        this.add(SNSEntity.FRUIT_PUG.get(), "Fruit Pug");
        this.add((Item)SNSItem.FRUIT_PUG_SPAWN_EGG.get(), "Fruit Pug Egg");
        this.add(SNSEntity.HAPPLE.get(), "Happle");
        this.add((Item)SNSItem.HAPPLE_SPAWN_EGG.get(), "Happle Egg");
        this.add(SNSEntity.SNAPPLE.get(), "Snapple");
        this.add((Item)SNSItem.SNAPPLE_SPAWN_EGG.get(), "Snapple Egg");
        this.add(SNSEntity.CANDY_CANE_CAT.get(), "Candy Cane Cat");
        this.add((Item)SNSItem.CANDY_CANE_CAT_SPAWN_EGG.get(), "Candy Cane Cat Egg");
        this.add(SNSEntity.CANDY_CANE_CERBERUS.get(), "Candy Cane Cerberus");
        this.add((Item)SNSItem.CANDY_CANE_CERBERUS_SPAWN_EGG.get(), "Candy Cane Cerberus Egg");
        this.add(SNSEntity.CANDY_CANE_CROOK.get(), "Candy Cane Crook");
        this.add((Item)SNSItem.CANDY_CANE_CROOK_SPAWN_EGG.get(), "Candy Cane Crook Egg");
        this.add(SNSEntity.CANDY_CANE_FLY.get(), "Candy Cane Fly");
        this.add((Item)SNSItem.CANDY_CANE_FLY_SPAWN_EGG.get(), "Candy Cane Fly Egg");
        this.add(SNSEntity.CANDY_CANE_TIGER.get(), "Candy Cane Tiger");
        this.add((Item)SNSItem.CANDY_CANE_TIGER_SPAWN_EGG.get(), "Candy Cane Tiger Egg");
        this.add(SNSEntity.CANDY_CANE_ZEBRA.get(), "Candy Cane Zebra");
        this.add((Item)SNSItem.CANDY_CANE_ZEBRA_SPAWN_EGG.get(), "Candy Cane Zebra Egg");
        this.add(SNSEntity.CINNABUN.get(), "Cinnabun");
        this.add((Item)SNSItem.CINNABUN_SPAWN_EGG.get(), "Cinnabun Egg");
        this.add(SNSEntity.CINNADILE.get(), "Cinnadile");
        this.add((Item)SNSItem.CINNADILE_SPAWN_EGG.get(), "Cinnadile Egg");
        this.add(SNSEntity.CINNAFFIN.get(), "Cinnaffin");
        this.add((Item)SNSItem.CINNAFFIN_SPAWN_EGG.get(), "Cinnaffin Egg");
        this.add(SNSEntity.CINNAMANTA_RAY.get(), "Cinnamanta Ray");
        this.add((Item)SNSItem.CINNAMANTA_RAY_SPAWN_EGG.get(), "Cinnamanta Ray Egg");
        this.add(SNSEntity.CINNAMOTH.get(), "Cinnamoth");
        this.add((Item)SNSItem.CINNAMOTH_SPAWN_EGG.get(), "Cinnamoth Egg");
        this.add(SNSEntity.GINGERBREAD_MAN.get(), "Gingerbread Man");
        this.add((Item)SNSItem.GINGERBREAD_MAN_SPAWN_EGG.get(), "Gingerbread Man Egg");
        this.add(SNSEntity.HUMBUG.get(), "Humbug");
        this.add((Item)SNSItem.HUMBUG_SPAWN_EGG.get(), "Humbug Egg");
        this.add(SNSEntity.HUMBULL.get(), "Humbull");
        this.add((Item)SNSItem.HUMBULL_SPAWN_EGG.get(), "Humbull Egg");
        this.add(SNSEntity.HUMFLY.get(), "Humfly");
        this.add((Item)SNSItem.HUMFLY_SPAWN_EGG.get(), "Humfly Egg");
        this.add(SNSEntity.HUMPUG.get(), "Humpug");
        this.add((Item)SNSItem.HUMPUG_SPAWN_EGG.get(), "Humpug Egg");
        this.add(SNSEntity.MINT_MINK.get(), "Mink");
        this.add((Item)SNSItem.MINT_MINK_SPAWN_EGG.get(), "Mink Egg");
        this.add(SNSEntity.MINTOW.get(), "Mintow");
        this.add((Item)SNSItem.MINTOW_SPAWN_EGG.get(), "Mintow Egg");
        this.add(SNSEntity.MINTMUNK.get(), "Mintmunk");
        this.add((Item)SNSItem.MINTMUNK_SPAWN_EGG.get(), "Mintmunk Egg");
        this.add(SNSEntity.MINT_IMPERIAL.get(), "Mint Imperial");
        this.add((Item)SNSItem.MINT_IMPERIAL_SPAWN_EGG.get(), "Mint Imperial Egg");
        this.add(SNSEntity.MARSHMALLOW_SHEEP.get(), "Marshmallow Sheep");
        this.add((Item)SNSItem.MARSHMALLOW_SHEEP_SPAWN_EGG.get(), "Marshmallow Sheep Egg");
        this.add(SNSEntity.MYNX.get(), "Mynx");
        this.add((Item)SNSItem.MYNX_SPAWN_EGG.get(), "Mynx Egg");
        this.add(SNSEntity.PEPPERMINT_CHURL.get(), "Peppermint Churl");
        this.add((Item)SNSItem.PEPPERMINT_CHURL_SPAWN_EGG.get(), "Peppermint Churl Egg");
        this.add(SNSEntity.PEPPERMINT_TWIRL.get(), "Peppermint Twirl");
        this.add((Item)SNSItem.PEPPERMINT_TWIRL_SPAWN_EGG.get(), "Peppermint Twirl Egg");
        this.add(SNSEntity.ICE_CREAM_COW.get(), "Ice Cream Cow");
        this.add((Item)SNSItem.ICE_CREAM_COW_SPAWN_EGG.get(), "Ice Cream Cow Egg");
        this.add(SNSEntity.ICE_CREAM_FISH.get(), "Ice Cream Fish");
        this.add((Item)SNSItem.ICE_CREAM_FISH_SPAWN_EGG.get(), "Ice Cream Fish Egg");
        this.add(SNSEntity.PARFAIT_PIXIE.get(), "Parfait Pixie");
        this.add((Item)SNSItem.PARFAIT_PIXIE_SPAWN_EGG.get(), "Parfait Pixie Egg");
        this.add(SNSEntity.WAFER_WHALE.get(), "Wafer Whale");
        this.add((Item)SNSItem.WAFER_WHALE_SPAWN_EGG.get(), "Wafer Whale Egg");
        this.add(SNSEntity.WAFER_WITCH.get(), "Wafer Witch");
        this.add((Item)SNSItem.WAFER_WITCH_SPAWN_EGG.get(), "Wafer Witch Egg");
        this.add(SNSEntity.WAFFLE_FISH.get(), "Waffle Fish");
        this.add((Item)SNSItem.WAFFLE_FISH_SPAWN_EGG.get(), "Waffle Fish Egg");
        this.add(SNSEntity.WAFFLE_FISH_MINI.get(), "Mini Waffle Fish");
        this.add((Item)SNSItem.WAFFLE_FISH_MINI_SPAWN_EGG.get(), "Mini Waffle Fish Egg");
        this.add(SNSEntity.BONBONBINI.get(), "Bonbonbini");
        this.add((Item)SNSItem.BONBONBINI_SPAWN_EGG.get(), "Bonbonbini Egg");
        this.add(SNSEntity.CANDYFLOSS_LION.get(), "Candyfloss Lion");
        this.add((Item)SNSItem.CANDYFLOSS_LION_SPAWN_EGG.get(), "Candyfloss Lion Egg");
        this.add(SNSEntity.CANDYFLOSS_SHEEP.get(), "Candyfloss Sheep");
        this.add((Item)SNSItem.CANDYFLOSS_SHEEP_SPAWN_EGG.get(), "Candyfloss Sheep Egg");
        this.add(SNSEntity.CHOCCOON.get(), "Chocolate Raccoon");
        this.add((Item)SNSItem.CHOCCOON_SPAWN_EGG.get(), "Chocolate Raccoon Egg");
        this.add(SNSEntity.CHOCOLATE_CHICKEN.get(), "Chocolate Chicken");
        this.add((Item)SNSItem.CHOCOLATE_CHICKEN_SPAWN_EGG.get(), "Chocolate Chicken Egg");
        this.add(SNSEntity.CHOCOLATE_PENGUIN.get(), "Chocolate Penguin");
        this.add((Item)SNSItem.CHOCOLATE_PENGUIN_SPAWN_EGG.get(), "Chocolate Penguin Egg");
        this.add(SNSEntity.CHOCOLATE_PIGEON.get(), "Chocolate Pigeon");
        this.add((Item)SNSItem.CHOCOLATE_PIGEON_SPAWN_EGG.get(), "Chocolate Pigeon Egg");
        this.add(SNSEntity.CHOCOLATE_REINDEER.get(), "Chocolate Reindeer");
        this.add((Item)SNSItem.CHOCOLATE_REINDEER_SPAWN_EGG.get(), "Chocolate Reindeer Egg");
        this.add(SNSEntity.COLA_BOTTLENOSE_DOLPHIN.get(), "Cola Bottle-Nose Dolphin");
        this.add((Item)SNSItem.COLA_BOTTLENOSE_DOLPHIN_SPAWN_EGG.get(), "Cola Bottle-Nose Dolphin Egg");
        this.add(SNSEntity.GUMMY_BEAR.get(), "Gummy Bear");
        this.add((Item)SNSItem.GUMMY_BEAR_SPAWN_EGG.get(), "Gummy Bear Egg");
        this.add(SNSEntity.GUMMY_FISH.get(), "Gummy Fish");
        this.add((Item)SNSItem.GUMMY_FISH_SPAWN_EGG.get(), "Gummy Fish Egg");
        this.add(SNSEntity.JELLY_BABY.get(), "Jelly Baby");
        this.add((Item)SNSItem.JELLY_BABY_SPAWN_EGG.get(), "Jelly Baby Egg");
        this.add(SNSEntity.LACE_SNAKE.get(), "Lace Snake");
        this.add((Item)SNSItem.LACE_SNAKE_SPAWN_EGG.get(), "Lace Snake Egg");
        this.add(SNSEntity.LACE_SPIDER.get(), "Lace Spider");
        this.add((Item)SNSItem.LACE_SPIDER_SPAWN_EGG.get(), "Lace Spider Egg");
        this.add(SNSEntity.RAINBOW_STRIP_JELLYFISH.get(), "Rainbow Strip Jellyfish");
        this.add((Item)SNSItem.RAINBOW_STRIP_JELLYFISH_SPAWN_EGG.get(), "Rainbow Strip Jellyfish Egg");
        this.add(SNSEntity.RAINBOW_STRIP_PEGASUS.get(), "Rainbow Strip Pegasus");
        this.add((Item)SNSItem.RAINBOW_STRIP_PEGASUS_SPAWN_EGG.get(), "Rainbow Strip Pegasus Egg");
        this.add(SNSEntity.RAINBOW_STRIP_PHOENIX.get(), "Rainbow Strip Phoenix");
        this.add((Item)SNSItem.RAINBOW_STRIP_PHOENIX_SPAWN_EGG.get(), "Rainbow Strip Phoenix Egg");
        this.add(SNSEntity.RAINBOW_STRIP_UNICORN.get(), "Rainbow Strip Unicorn");
        this.add((Item)SNSItem.RAINBOW_STRIP_UNICORN_SPAWN_EGG.get(), "Rainbow Strip Unicorn Egg");
        this.add(SNSEntity.SUGARGLIDER.get(), "Sugarglider");
        this.add((Item)SNSItem.SUGARGLIDER_SPAWN_EGG.get(), "Sugarglider Egg");
        this.add(SNSEntity.SUGAR_WRAPPED_MUMMY.get(), "Sugar Wrapped Mummy");
        this.add((Item)SNSItem.SUGAR_WRAPPED_MUMMY_SPAWN_EGG.get(), "Sugar Wrapped Mummy Egg");
        this.add(SNSEntity.TREAT_TOAD.get(), "Treat Toad");
        this.add((Item)SNSItem.TREAT_TOAD_SPAWN_EGG.get(), "Treat Toad Egg");
        this.add((Item)SNSItem.CANDY_CANE_HELMET.get(), "Candy Cane Helmet");
        this.add((Item)SNSItem.CANDY_CANE_CHESTPLATE.get(), "Candy Cane Chestplate");
        this.add((Item)SNSItem.CANDY_CANE_LEGGINGS.get(), "Candy Cane Leggings");
        this.add((Item)SNSItem.CANDY_CANE_BOOTS.get(), "Candy Cane Boots");
        this.add((Item)SNSItem.ANGEL_CAKE.get(), "Angel Cake");
        this.add((Item)SNSItem.BLACKBERRY_LOLLIPOP.get(), "Blackberry Lollipop");
        this.add((Item)SNSItem.BLUEBERRY_LOLLIPOP.get(), "Blueberry Lollipop");
        this.add((Item)SNSItem.RASPBERRY_LOLLIPOP.get(), "Raspberry Lollipop");
        this.add((Item)SNSItem.STRAWBERRY_LOLLIPOP.get(), "Strawberry Lollipop");
        this.add((Item)SNSItem.LEMON_LOLLIPOP.get(), "Lemon Lollipop");
        this.add((Item)SNSItem.ORANGE_LOLLIPOP.get(), "Orange Lollipop");
        this.add((Item)SNSItem.CANDYFLOSS.get(), "Candyfloss");
        this.add((Item)SNSItem.CANDYFLOSS_BLUE_RASPBERRY.get(), "Blue Raspberry Candyfloss");
        this.add((Item)SNSItem.CANDYFLOSS_LEMON.get(), "Lemon Candyfloss");
        this.add((Item)SNSItem.CANDYFLOSS_STRAWBERRY.get(), "Strawberry Candyfloss");
        this.add((Item)SNSItem.CANDYFLOSS_VANILLA.get(), "Vanilla Candyfloss");
        this.add((Item)SNSItem.CANDY_CANE.get(), "Candy Cane");
        this.add((Item)SNSItem.CANDY_CANE_ESSENCE_SHARD.get(), "Candy Cane Essence Shard");
        this.add((Item)SNSItem.CANDY_CANE_SUGAR.get(), "Candy Cane Sugar");
        this.add((Item)SNSItem.CANDY_CANE_SUGAR_CANE.get(), "Candy Cane Sugar Cane");
        this.add((Item)SNSItem.CANDY_CANE_SWORD.get(), "Candy Cane Sword");
        this.add((Item)SNSItem.CHOCOLATE_EGG.get(), "Milk Chocolate Egg");
        this.add((Item)SNSItem.CHOCOLATE_DARK_EGG.get(), "Dark Chocolate Egg");
        this.add((Item)SNSItem.CHOCOLATE_WHITE_EGG.get(), "White Chocolate Egg");
        this.add((Item)SNSItem.CHOCOLATE_STICK.get(), "Chocolate Stick");
        this.add((Item)SNSItem.CINNAMON.get(), "Cinnamon");
        this.add((Item)SNSItem.CINNAMON_BUN.get(), "Cinnamon Bun");
        this.add((Item)SNSItem.CINNAMON_STICK.get(), "Cinnamon Stick");
        this.add((Item)SNSItem.COLA_BOTTLE.get(), "Cola Bottle");
        this.add((Item)SNSItem.CONE.get(), "Cone");
        this.add((Item)SNSItem.CRYSTALISED_SUGAR_STICK.get(), "Crystalised Sugar Stick");
        this.add((Item)SNSItem.GELATIN.get(), "Gelatin");
        this.add((Item)SNSItem.GUMMY_APPLE.get(), "Gummy Apple");
        this.add((Item)SNSItem.GUMMY_BANANA.get(), "Gummy Banana");
        this.add((Item)SNSItem.GUMMY_BLACKBERRY.get(), "Gummy Blackberry");
        this.add((Item)SNSItem.GUMMY_BLUEBERRY.get(), "Gummy Blueberry");
        this.add((Item)SNSItem.GUMMY_RASPBERRY.get(), "Gummy Raspberry");
        this.add((Item)SNSItem.GUMMY_STRAWBERRY.get(), "Gummy Strawberry");
        this.add((Item)SNSItem.HUMBUG.get(), "Humbug");
        this.add((Item)SNSItem.ICE_CREAM.get(), "Ice Cream");
        this.add((Item)SNSItem.VANILLA_ICE_CREAM.get(), "Vanilla Ice Cream");
        this.add((Item)SNSItem.MINT_IMPERIAL.get(), "Mint Imperial");
        this.add((Item)SNSItem.VANILLA_MARSHMALLOW.get(), "Vanilla Marshmallow");
        this.add((Item)SNSItem.BLACKBERRY_MARSHMALLOW.get(), "Blackberry Marshmallow");
        this.add((Item)SNSItem.BLUEBERRY_MARSHMALLOW.get(), "Blueberry Marshmallow");
        this.add((Item)SNSItem.RASPBERRY_MARSHMALLOW.get(), "Raspberry Marshmallow");
        this.add((Item)SNSItem.STRAWBERRY_MARSHMALLOW.get(), "Strawberry Marshmallow");
        this.add((Item)SNSItem.CHOCOLATE_MARSHMALLOW.get(), "Chocolate Marshmallow");
        this.add((Item)SNSItem.MINT_MARSHMALLOW.get(), "Mint Marshmallow");
        this.add((Item)SNSItem.PEPPERMINT_SWIRL.get(), "Peppermint Swirl");
        this.add((Item)SNSItem.POLO.get(), "Polo");
        this.add((Item)SNSItem.PRETZEL.get(), "Pretzel");
        this.add((Item)SNSItem.RAINBOW_STRIP.get(), "Rainbow Strip");
        this.add((Item)SNSItem.RAINBOW_STRIP_STICK.get(), "Rainbow Strip Stick");
        this.add((Item)SNSItem.RHUBARB_CUSTARD.get(), "Rhubarb & Custard Sweet");
        this.add((Item)SNSItem.STRAWBERRY_CREAM.get(), "Strawberry & Cream Sweet");
        this.add((Item)SNSItem.SPRINKLES_ORANGE.get(), "Orange Sprinkles");
        this.add((Item)SNSItem.SPRINKLES_PINK.get(), "Pink Sprinkles");
        this.add((Item)SNSItem.WAFFLE_BUCKET.get(), "Waffle Bucket");
        for (SNSFishBuckets.FishSpec fish : SNSFishBuckets.FISHES) {
            for (SNSFishBuckets.FluidSpec fluid : SNSFishBuckets.FLUIDS) {
                String key = "item.snsnf." + fish.id() + "_" + fluid.id() + "_bucket";
                this.add(key, fish.displayName() + " Bucket (" + fluid.displayName() + ")");
            }
        }
        this.add((Item)SNSItem.WAFFLE_CHOCOLATE_BUCKET.get(), "Waffle Bucket of Chocolate");
        this.add((Item)SNSItem.WAFFLE_CREAM_BUCKET.get(), "Waffle Bucket of Cream");
        this.add((Item)SNSItem.WAFFLE_MINT_WATER_BUCKET.get(), "Waffle Bucket of Mint Water");
        this.add((Item)SNSItem.WAFFLE_WATER_BUCKET.get(), "Waffle Bucket of Water");
        this.add((Item)SNSItem.WAFFLE_STICK.get(), "Waffle Stick");
        this.add("itemGroup.snsnf.sns_block", "Blocks - Sweet Not Savoury");
        this.add("itemGroup.snsnf.sns_decoration", "Decorations - Sweet Not Savoury");
        this.add("itemGroup.snsnf.sns_flora", "Flora - Sweet Not Savoury");
        this.add("itemGroup.snsnf.sns_item", "Items - Sweet Not Savoury");
        this.add("itemGroup.snsnf.sns_spawn_egg", "Spawn Eggs - Sweet Not Savoury");
        this.add("itemGroup.snsnf.sns_combat", "Combat - Sweet Not Savoury");
        this.add("painting.snsnf.candy_cane.author", "xStarlotte");
        this.add("painting.snsnf.candy_cane.title", "Candy Cane");
        this.add("painting.snsnf.candy_cane_cat.author", "xStarlotte");
        this.add("painting.snsnf.candy_cane_cat.title", "Candy Cane Cat");
        this.add("painting.snsnf.candy_cane_cat_apple.author", "xStarlotte");
        this.add("painting.snsnf.plain.author", "xStarlotte");
        this.add("painting.snsnf.plain.title", "Plain");
    }

    private record Parts(boolean button, boolean door, boolean fence, boolean fenceGate, boolean pressurePlate, boolean slab, boolean stairs, boolean trapdoor, boolean wall) {
        static Parts all() {
            return new Parts(true, true, true, true, true, true, true, true, true);
        }

        static Parts woodLike() {
            return Parts.all();
        }

        static Parts stoneLike() {
            return Parts.all();
        }

        static Parts victoria() {
            return new Parts(true, false, true, true, true, true, true, false, true);
        }
    }
}

