/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.cake;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.xstarlotte.snsnf.entity.client.cake.CakeRabbitModel;
import net.xstarlotte.snsnf.entity.client.variant.CakeRabbitVariant;
import net.xstarlotte.snsnf.entity.custom.cake.CakeRabbitEntity;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class CakeRabbitRenderer
extends GeoEntityRenderer<CakeRabbitEntity> {
    private static final Map<CakeRabbitVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(CakeRabbitVariant.class), map -> {
        map.put(CakeRabbitVariant.ANGEL, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/angel_cake_rabbit.png"));
        map.put(CakeRabbitVariant.BANANA_BREAD, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/banana_bread_rabbit.png"));
        map.put(CakeRabbitVariant.BANOFFEE_PIE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/banoffee_pie_rabbit.png"));
        map.put(CakeRabbitVariant.CARROT, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/carrot_cake_rabbit.png"));
        map.put(CakeRabbitVariant.CHOCOLATE_CHERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/chocolate_cherry_cake_rabbit.png"));
        map.put(CakeRabbitVariant.CHOCOLATE_ORANGE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/chocolate_orange_cake_rabbit.png"));
        map.put(CakeRabbitVariant.COFFEE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/coffee_cake_rabbit.png"));
        map.put(CakeRabbitVariant.FRUIT, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/fruit_cake_rabbit.png"));
        map.put(CakeRabbitVariant.LEMON_CURD, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/lemon_curd_cake_rabbit.png"));
        map.put(CakeRabbitVariant.PEACH, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/peach_cake_rabbit.png"));
        map.put(CakeRabbitVariant.RASPBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/raspberry_cake_rabbit.png"));
        map.put(CakeRabbitVariant.RED_VELVET, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/red_velvet_cake_rabbit.png"));
        map.put(CakeRabbitVariant.STRAWBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/strawberry_cake_rabbit.png"));
        map.put(CakeRabbitVariant.VANILLA, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/vanilla_cake_rabbit.png"));
        map.put(CakeRabbitVariant.VICTORIA_SPONGE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/victoria_sponge_cake_rabbit.png"));
    });

    public CakeRabbitRenderer(EntityRendererProvider.Context context) {
        super(context, new CakeRabbitModel());
    }

    public ResourceLocation getTextureLocation(CakeRabbitEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public void render(CakeRabbitEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.3f, 0.3f, 0.3f);
        } else {
            poseStack.scale(0.6f, 0.6f, 0.6f);
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

