/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.cake;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.xstarlotte.snsnf.entity.client.cake.PretzelflyModel;
import net.xstarlotte.snsnf.entity.client.variant.PretzelflyVariant;
import net.xstarlotte.snsnf.entity.custom.cake.PretzelflyEntity;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class PretzelflyRenderer
extends GeoEntityRenderer<PretzelflyEntity> {
    private static final Map<PretzelflyVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(PretzelflyVariant.class), map -> {
        map.put(PretzelflyVariant.MILK_CHOCOLATE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/milk_chocolate_pretzelfly.png"));
        map.put(PretzelflyVariant.DARK_CHOCOLATE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/dark_chocolate_pretzelfly.png"));
        map.put(PretzelflyVariant.WHITE_CHOCOLATE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/white_chocolate_pretzelfly.png"));
        map.put(PretzelflyVariant.HONEY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/honey_pretzelfly.png"));
        map.put(PretzelflyVariant.SUGAR, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/sugar_pretzelfly.png"));
        map.put(PretzelflyVariant.SPRINKLE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/sprinkle_pretzelfly.png"));
        map.put(PretzelflyVariant.PLAIN, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/pretzelfly.png"));
        map.put(PretzelflyVariant.STRAWBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/cake/strawberry_pretzelfly.png"));
    });

    public PretzelflyRenderer(EntityRendererProvider.Context context) {
        super(context, new PretzelflyModel());
    }

    public ResourceLocation getTextureLocation(PretzelflyEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public void render(PretzelflyEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.scale(0.9f, 0.9f, 0.9f);
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

