/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.herb;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.xstarlotte.snsnf.entity.client.herb.CandyCaneCatModel;
import net.xstarlotte.snsnf.entity.client.variant.CandyCaneCatVariant;
import net.xstarlotte.snsnf.entity.custom.herb.CandyCaneCatEntity;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class CandyCaneCatRenderer
extends GeoEntityRenderer<CandyCaneCatEntity> {
    private static final Map<CandyCaneCatVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(CandyCaneCatVariant.class), map -> map.put(CandyCaneCatVariant.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/herb/candy_cane_cat.png")));

    public CandyCaneCatRenderer(EntityRendererProvider.Context context) {
        super(context, new CandyCaneCatModel());
    }

    public ResourceLocation getTextureLocation(CandyCaneCatEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public void render(CandyCaneCatEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.4f, 0.4f, 0.4f);
        } else {
            poseStack.scale(0.8f, 0.8f, 0.8f);
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

