/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.ice_cream;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.xstarlotte.snsnf.entity.client.ice_cream.ParfaitPixieModel;
import net.xstarlotte.snsnf.entity.client.variant.ParfaitPixieVariant;
import net.xstarlotte.snsnf.entity.custom.ice_cream.ParfaitPixieEntity;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class ParfaitPixieRenderer
extends GeoEntityRenderer<ParfaitPixieEntity> {
    private static final Map<ParfaitPixieVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(ParfaitPixieVariant.class), map -> {
        map.put(ParfaitPixieVariant.BLACKBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/ice_cream/blackberry_parfait_pixie.png"));
        map.put(ParfaitPixieVariant.BLUEBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/ice_cream/blueberry_parfait_pixie.png"));
        map.put(ParfaitPixieVariant.CHOCOLATE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/ice_cream/chocolate_parfait_pixie.png"));
        map.put(ParfaitPixieVariant.LEMON, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/ice_cream/lemon_parfait_pixie.png"));
        map.put(ParfaitPixieVariant.ORANGE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/ice_cream/orange_parfait_pixie.png"));
        map.put(ParfaitPixieVariant.RASPBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/ice_cream/raspberry_parfait_pixie.png"));
        map.put(ParfaitPixieVariant.STRAWBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/ice_cream/strawberry_parfait_pixie.png"));
        map.put(ParfaitPixieVariant.TOFFEE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/ice_cream/toffee_parfait_pixie.png"));
    });

    public ParfaitPixieRenderer(EntityRendererProvider.Context context) {
        super(context, new ParfaitPixieModel());
    }

    public ResourceLocation getTextureLocation(ParfaitPixieEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public void render(ParfaitPixieEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.4f, 0.4f, 0.4f);
        } else {
            poseStack.scale(0.8f, 0.8f, 0.8f);
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

