/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.ice_cream;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.xstarlotte.snsnf.entity.client.ice_cream.WaffleFishModel;
import net.xstarlotte.snsnf.entity.client.variant.WaffleFishVariant;
import net.xstarlotte.snsnf.entity.custom.ice_cream.WaffleFishEntity;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class WaffleFishRenderer
extends GeoEntityRenderer<WaffleFishEntity> {
    private static final Map<WaffleFishVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(WaffleFishVariant.class), map -> {
        map.put(WaffleFishVariant.BLACKBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/ice_cream/blackberry_waffle_fish.png"));
        map.put(WaffleFishVariant.BLUEBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/ice_cream/blueberry_waffle_fish.png"));
        map.put(WaffleFishVariant.CHOCOLATE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/ice_cream/chocolate_waffle_fish.png"));
        map.put(WaffleFishVariant.LEMON, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/ice_cream/lemon_waffle_fish.png"));
        map.put(WaffleFishVariant.ORANGE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/ice_cream/orange_waffle_fish.png"));
        map.put(WaffleFishVariant.PEACH, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/ice_cream/peach_waffle_fish.png"));
        map.put(WaffleFishVariant.RASPBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/ice_cream/raspberry_waffle_fish.png"));
        map.put(WaffleFishVariant.STRAWBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/ice_cream/strawberry_waffle_fish.png"));
        map.put(WaffleFishVariant.TOFFEE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/ice_cream/toffee_waffle_fish.png"));
        map.put(WaffleFishVariant.VANILLA, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/ice_cream/vanilla_waffle_fish.png"));
    });

    public WaffleFishRenderer(EntityRendererProvider.Context context) {
        super(context, new WaffleFishModel());
    }

    public ResourceLocation getTextureLocation(WaffleFishEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public void render(WaffleFishEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.scale(2.0f, 2.0f, 2.0f);
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

