/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.sweet;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.xstarlotte.snsnf.entity.client.sweet.ChocolateChickenModel;
import net.xstarlotte.snsnf.entity.client.variant.ChocolateChickenVariant;
import net.xstarlotte.snsnf.entity.custom.sweet.ChocolateChickenEntity;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class ChocolateChickenRenderer
extends GeoEntityRenderer<ChocolateChickenEntity> {
    private static final Map<ChocolateChickenVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(ChocolateChickenVariant.class), map -> {
        map.put(ChocolateChickenVariant.DARK, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/dark_chocolate_chicken.png"));
        map.put(ChocolateChickenVariant.MILK, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/milk_chocolate_chicken.png"));
        map.put(ChocolateChickenVariant.WHITE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/white_chocolate_chicken.png"));
    });

    public ChocolateChickenRenderer(EntityRendererProvider.Context context) {
        super(context, new ChocolateChickenModel());
    }

    public ResourceLocation getTextureLocation(ChocolateChickenEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public void render(ChocolateChickenEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.35f, 0.35f, 0.35f);
        } else {
            poseStack.scale(0.7f, 0.7f, 0.7f);
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

