/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.sweet;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.xstarlotte.snsnf.entity.client.sweet.LaceSpiderModel;
import net.xstarlotte.snsnf.entity.client.variant.LaceSpiderVariant;
import net.xstarlotte.snsnf.entity.custom.sweet.LaceSpiderEntity;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class LaceSpiderRenderer
extends GeoEntityRenderer<LaceSpiderEntity> {
    private static final Map<LaceSpiderVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(LaceSpiderVariant.class), map -> {
        map.put(LaceSpiderVariant.STRAWBERRY, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/strawberry_lace_spider.png"));
        map.put(LaceSpiderVariant.COLA, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/cola_lace_spider.png"));
    });

    public LaceSpiderRenderer(EntityRendererProvider.Context context) {
        super(context, new LaceSpiderModel());
    }

    public ResourceLocation getTextureLocation(LaceSpiderEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public void render(LaceSpiderEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.scale(1.0f, 1.0f, 1.0f);
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

